/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class DoubleCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Double DEFAULT = new Double(0.0);
    private static final int WIRE_SIZE = 8;

    public DoubleCoder() {
        this(DEFAULT);
    }

    protected DoubleCoder(Object defaultValue) {
        super(defaultValue, 8);
    }

    public int getBrokerType() {
        return 24;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.writeLong(Double.doubleToLongBits((Double)data));
    }

    public Object decode(BytePoolReader reader) {
        return new Double(Double.longBitsToDouble(reader.readLong()));
    }

    public String getJavaClassName() {
        return Double.class.getName();
    }
}

