/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Date DEFAULT = new Date();
    protected static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    private static final int WIRE_SIZE = 8;

    public DateCoder() {
        super(DEFAULT, 8);
    }

    public int getBrokerType() {
        return 40;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        Date date = (Date)data;
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setTime(date);
        short year = (short)calendar.get(1);
        byte month = (byte)calendar.get(2);
        month = (byte)(month + 1);
        byte days = (byte)calendar.get(5);
        byte hours = (byte)calendar.get(11);
        byte minutes = (byte)calendar.get(12);
        short seconds = (byte)calendar.get(13);
        short milliSeconds = (short)calendar.get(14);
        hours = (byte)(hours | 0xA0);
        seconds = (short)(seconds << 10 & 0xFC00);
        seconds = (short)(seconds | milliSeconds);
        writer.writeShort(year);
        writer.writeByte(month);
        writer.writeByte(days);
        writer.writeByte(hours);
        writer.writeByte(minutes);
        writer.writeShort(seconds);
    }

    public Object decode(BytePoolReader reader) {
        int year = reader.readShort();
        int month = reader.readByte() - 1;
        int days = reader.readByte();
        int hours = reader.readByte();
        int isUtcBit = hours >> 5 & 1;
        hours &= 0x1F;
        int minutes = reader.readByte();
        int seconds = reader.readShort();
        int milliSeconds = seconds & 0x3FF;
        seconds = seconds >> 10 & 0x3F;
        if (this._verbose) {
            StringBuffer buf = new StringBuffer();
            buf.append("{year, month, days, hours, minutes, seconds, milliSeconds} = {");
            buf.append(year);
            buf.append(", ");
            buf.append(month);
            buf.append(", ");
            buf.append(days);
            buf.append(", ");
            buf.append(hours);
            buf.append(", ");
            buf.append(minutes);
            buf.append(", ");
            buf.append(seconds);
            buf.append(", ");
            buf.append(milliSeconds);
            buf.append('}');
            DateCoder.log(buf.toString());
        }
        GregorianCalendar calendar = isUtcBit == 0 ? new GregorianCalendar() : new GregorianCalendar(UTC);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, days);
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, milliSeconds);
        return calendar.getTime();
    }

    public String getJavaClassName() {
        return Date.class.getName();
    }
}

