/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class CharacterCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Character DEFAULT = new Character('\u0000');
    private static final int WIRE_SIZE = 2;

    public int getBrokerType() {
        return 50;
    }

    public int getCoderType() {
        return 1;
    }

    public CharacterCoder() {
        super(DEFAULT, 2);
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.writeShort(((Character)data).charValue());
    }

    public Object decode(BytePoolReader reader) {
        return new Character((char)reader.readShort());
    }

    public String getJavaClassName() {
        return Character.class.getName();
    }
}

