/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

public class BooleanCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final Boolean DEFAULT = new Boolean(false);
    private static final int WIRE_SIZE = 1;

    public BooleanCoder() {
        this(DEFAULT);
    }

    protected BooleanCoder(Object defaultValue) {
        super(defaultValue, 1);
    }

    public int getBrokerType() {
        return 33;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.writeByte((Boolean)data == true ? 1 : 0);
    }

    public Object decode(BytePoolReader reader) {
        return new Boolean(reader.readByte() == 1);
    }

    public String getJavaClassName() {
        return Boolean.class.getName();
    }
}

