/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.encoding.UnicodeValueCoder;
import com.wm.util.JournalLogger;
import java.math.BigInteger;

public class BigIntegerCoder
extends UnicodeValueCoder {
    public Object decode(BytePoolReader reader) {
        BigInteger integer;
        String data = (String)super.decode(reader);
        try {
            integer = new BigInteger(data);
        }
        catch (NumberFormatException nfe) {
            integer = new BigInteger("0");
            JournalLogger.log(30, 76, 2, data, integer.toString());
        }
        return integer;
    }

    public String getJavaClassName() {
        return BigInteger.class.getName();
    }
}

