/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.encoding;

import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.encoding.UnicodeValueCoder;
import com.wm.util.JournalLogger;
import java.math.BigDecimal;

public class BigDecimalCoder
extends UnicodeValueCoder {
    public Object decode(BytePoolReader reader) {
        BigDecimal decimal;
        String data = (String)super.decode(reader);
        try {
            decimal = new BigDecimal(data);
        }
        catch (NumberFormatException nfe) {
            decimal = new BigDecimal(0.0);
            JournalLogger.log(30, 76, 2, data, decimal.toString());
        }
        return decimal;
    }

    public String getJavaClassName() {
        return BigDecimal.class.getName();
    }
}

