/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BrokerBaseTypeCoder;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;

class byteArrayCoder
extends BrokerBaseTypeCoder
implements IBrokerSimpleTypeCoder {
    private static final byte[] DEFAULT = new byte[0];
    private static final int WIRE_SIZE = 12;

    public byteArrayCoder() {
        super(DEFAULT, 12);
    }

    public int getBrokerType() {
        return 129;
    }

    public int getCoderType() {
        return 1;
    }

    public void encode(BytePoolWriter writer, Object data) {
        writer.startField();
        int pos = writer.getPosition();
        writer.skip(4);
        writer.skip(2);
        writer.writeShort(1);
        byte[] bytes = (byte[])data;
        writer.write(bytes);
        if (this._verbose) {
            byteArrayCoder.log("arraySize=" + bytes.length);
        }
        writer.getPool().writeInt(pos, bytes.length);
        writer.endField();
    }

    public Object decode(BytePoolReader reader) {
        int sequenceLength = reader.readInt();
        int arraySize = reader.readInt();
        if (this._verbose) {
            byteArrayCoder.log("arraySize=" + arraySize);
        }
        reader.skip(2);
        int arrayType = reader.readShort();
        byte[] b = new byte[arraySize];
        reader.read(b);
        return b;
    }

    public String getJavaClassName() {
        return byte[].class.getName();
    }
}

