/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BrokerEncodingRegistry;
import com.wm.broker.coder.PrimitiveTypes;
import com.wm.broker.coder.URTypes;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.util.HashSet;
import com.wm.util.Name;
import com.wm.util.QName;

class SchemaUtil {
    private static final URTypes UR_TYPES = new URTypes();
    private static final PrimitiveTypes PRIMITIVE_TYPES = new PrimitiveTypes();

    SchemaUtil() {
    }

    static final QName computeCoderPrimitiveType(SimpleType st, BrokerEncodingRegistry er) {
        HashSet typeHeirarchy = st.getTypeHeirarchy();
        if (typeHeirarchy != null) {
            Object[] heirarchy = typeHeirarchy.toArray();
            for (int i = heirarchy.length - 1; i > -1; --i) {
                QName coderPrimitiveType = (QName)heirarchy[i];
                if (UR_TYPES.contains(coderPrimitiveType) || er.getTypeCoder(coderPrimitiveType) == null) continue;
                return coderPrimitiveType;
            }
        }
        Name sourceName = Name.create(st.getSourceName());
        return PRIMITIVE_TYPES.composeCoderPrimitiveType(sourceName);
    }
}

