/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BytePool;
import com.wm.broker.coder.Context;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.util.OIDTable;
import java.util.EmptyStackException;
import java.util.Stack;

class EncodingContext
extends Context {
    private OIDTable _SIDs = new OIDTable();
    private IDataCursor _currentWireCapsule;
    private Stack _typeReferences;
    private Stack _valueReferences;

    EncodingContext() {
        this._wireTags = IDataFactory.create();
        this._wireTagsCursor = this._wireTags.getCursor();
        this._typeReferences = new Stack();
        this._valueReferences = new Stack();
        this.setPool(new BytePool());
    }

    void putSID(Integer i, Object o) {
        this._SIDs.put(o, i);
    }

    Integer getSID(Object o) {
        return (Integer)this._SIDs.get(o);
    }

    void addWireCapsule(Integer sid) {
        IData capsule = this._wireTagsCursor.insertDataAfter(sid.toString());
        if (this._currentWireCapsule != null) {
            this._currentWireCapsule.destroy();
        }
        this._currentWireCapsule = capsule.getCursor();
    }

    void addWireTag(String tag, Object value) {
        if (this._currentWireCapsule.first(tag)) {
            this._currentWireCapsule.setValue(value);
        } else {
            this._currentWireCapsule.insertAfter(tag, value);
        }
    }

    void deleteWireTag(String tag) {
        if (this._currentWireCapsule.first(tag)) {
            this._currentWireCapsule.delete();
        }
    }

    IData getWireTags() {
        boolean hasWireTags = false;
        IDataCursor cursor = this._wireTags.getCursor();
        if (cursor.first()) {
            hasWireTags = true;
        }
        cursor.destroy();
        if (hasWireTags) {
            return this._wireTags;
        }
        return null;
    }

    void pushType(Object id) {
        this._typeReferences.push(id);
    }

    void popType() {
        this._typeReferences.pop();
    }

    boolean isRecursiveType(Object id) {
        try {
            int index;
            int size = this._typeReferences.size();
            if (size > 1 && (index = this._typeReferences.lastIndexOf(id, size - 2)) > -1) {
                return true;
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return false;
    }

    void pushValue(Object id) {
        this._valueReferences.push(id);
    }

    void popValue() {
        this._valueReferences.pop();
    }

    boolean isRecursiveValue(Object id) {
        try {
            int index;
            int size = this._valueReferences.size();
            if (size > 1 && (index = this._valueReferences.lastIndexOf(id, size - 2)) > -1) {
                return true;
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return false;
    }
}

