/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BytePool;
import java.util.Stack;

public class BytePoolWriter {
    private static byte[] padding = new byte[16];
    private static final int TYPE_FIELD = 0;
    private static final int TYPE_TAG = 1;
    private static final int TYPE_STRING_VALUE = 2;
    protected BytePool pool;
    private int pos;
    private int start;
    private Stack state;

    public BytePoolWriter(BytePool pool, int pos) {
        this.pool = pool;
        this.pos = pos;
        this.start = pos;
        this.state = new Stack();
    }

    public BytePool getPool() {
        return this.pool;
    }

    public void startField() {
        this.state.push(new State(this.pos, 4, true, 0));
    }

    public void startTag() {
        this.state.push(new State(this.pos, 2, false, 1));
    }

    public void startStringValue() {
        this.state.push(new State(this.pos, 4, true, 2));
    }

    public void startOffset() {
        this.state.push(new State());
    }

    public void endField() {
        ((State)this.state.pop()).padOut();
    }

    public void endTag() {
        ((State)this.state.pop()).padOut();
    }

    public void endStringValue() {
        ((State)this.state.pop()).padOut();
    }

    public void endOffset() {
        ((State)this.state.pop()).endOffset();
    }

    public int close() {
        return this.pos;
    }

    public void reset() {
        this.pos = this.start;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public int getOffset() {
        return this.pos - this.start;
    }

    public void setOffset(int off) {
        this.pos = this.start + off;
    }

    public void skip(int b) {
        this.pos += b;
    }

    public void write(byte[] b) {
        this.pool.write(this.pos, b, 0, b.length);
        this.pos += b.length;
    }

    public void write(byte[] b, int off, int len) {
        this.pool.write(this.pos, b, off, len);
        this.pos += len;
    }

    public void writeByte(int b) {
        this.pool.writeByte(this.pos, b);
        ++this.pos;
    }

    public void writeShort(int b) {
        this.pool.writeShort(this.pos, b);
        this.pos += 2;
    }

    public void writeInt(int b) {
        this.pool.writeInt(this.pos, b);
        this.pos += 4;
    }

    public void writeLong(long b) {
        this.pool.writeLong(this.pos, b);
        this.pos += 8;
    }

    private class State {
        private int loc;
        private int delta;
        private int type;

        State() {
            this.loc = BytePoolWriter.this.start;
            BytePoolWriter.this.start = BytePoolWriter.this.pos;
        }

        State(int loc, int head, boolean inc, int type) {
            this.type = type;
            this.loc = loc;
            this.delta = inc ? 0 : -head;
            BytePoolWriter.this.skip(head);
        }

        void padOut() {
            switch (this.type) {
                case 0: {
                    this.pad4();
                    BytePoolWriter.this.pool.writeInt(this.loc, BytePoolWriter.this.pos - this.loc + this.delta);
                    break;
                }
                case 1: {
                    BytePoolWriter.this.pool.writeShort(this.loc, BytePoolWriter.this.pos - this.loc + this.delta);
                    this.pad4();
                    break;
                }
                case 2: {
                    int len = BytePoolWriter.this.pos - this.loc + this.delta;
                    this.pad4();
                    BytePoolWriter.this.pool.writeInt(this.loc, len);
                }
            }
            BytePoolWriter.this.pool.ensureCapacity(BytePoolWriter.this.pos, 0);
        }

        void endOffset() {
            BytePoolWriter.this.start = this.loc;
        }

        void pad4() {
            int diff = BytePoolWriter.this.pos % 4;
            if (diff > 0) {
                BytePoolWriter.this.skip(4 - diff);
            }
        }
    }
}

