/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BytePool;

public class BytePoolReader {
    private BytePool pool;
    private int pos;

    public BytePoolReader(BytePool pool, int pos) {
        this.pool = pool;
        this.pos = pos;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void skip(int b) {
        this.pos += b;
    }

    public void read(byte[] b) {
        this.pool.read(this.pos, b, 0, b.length);
        this.pos += b.length;
    }

    public void read(byte[] b, int off, int len) {
        this.pool.read(this.pos, b, off, len);
        this.pos += len;
    }

    public int readByte() {
        int val = this.pool.readByte(this.pos);
        ++this.pos;
        return val;
    }

    public int readShort() {
        int val = this.pool.readShort(this.pos);
        this.pos += 2;
        return val;
    }

    public int readInt() {
        int val = this.pool.readInt(this.pos);
        this.pos += 4;
        return val;
    }

    public long readLong() {
        long val = this.pool.readLong(this.pos);
        this.pos += 8;
        return val;
    }
}

