/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BytePool;
import com.wm.broker.coder.BytePoolWriter;

public class BytePoolOffsetWriter
extends BytePoolWriter {
    private BytePoolWriter parent;
    private int head;
    private boolean inc;
    private int pad;

    public BytePoolOffsetWriter(BytePoolWriter parent, BytePool pool, int pos, int head, boolean inc, int pad) {
        super(pool, pos);
        this.parent = parent;
        this.head = head;
        this.inc = inc;
        this.pad = pad;
        this.skip(head);
    }

    public int close() {
        int len = this.inc ? this.getOffset() : this.getOffset() - this.head;
        this.setOffset(0);
        switch (this.head) {
            case 2: {
                this.writeShort(len);
                break;
            }
            case 4: {
                this.writeInt(len);
                break;
            }
        }
        if (this.pad > 0) {
            System.out.println("pad=" + this.pad + " len=" + len + " head=" + this.head + " padout=" + (this.pad - len % this.pad));
            if (this.inc) {
                this.setOffset(len + (this.pad - len % this.pad));
            } else {
                this.setOffset(this.head + len + (this.pad - len % this.pad));
            }
        } else {
            this.setOffset(this.head + len);
        }
        int pos = this.getPosition();
        if (this.parent != null) {
            this.parent.setPosition(pos);
        }
        this.pool.ensureCapacity(pos, 0);
        return pos;
    }
}

