/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import java.io.IOException;
import java.io.OutputStream;

public class BytePool {
    private static final int BLOCK = 4096;
    private int last;
    private int size;
    private int segSize;
    private byte[][] segment;

    BytePool() {
        this.segSize = 4096;
        this.segment = new byte[1][this.segSize];
        this.size = 0;
    }

    BytePool(byte[] b) {
        this.setPool(b);
    }

    private void setPool(byte[] b) {
        this.segSize = Math.max(b.length, 4096);
        this.segment = new byte[1][];
        this.segment[0] = b;
        this.size = b.length;
    }

    public void writeToStream(OutputStream stream) throws IOException {
        int off = 0;
        for (int i = 0; i < this.segment.length && off < this.last; off += this.segSize, ++i) {
            if (this.last - off <= this.segSize) {
                stream.write(this.segment[i], 0, this.last - off);
                return;
            }
            stream.write(this.segment[i]);
        }
    }

    public byte[] toByteArray() {
        byte[] b = new byte[this.last];
        int off = 0;
        for (int i = 0; i < this.segment.length && off < this.last; off += this.segSize, ++i) {
            if (this.last - off <= this.segSize) {
                System.arraycopy(this.segment[i], 0, b, off, this.last - off);
                return b;
            }
            System.arraycopy(this.segment[i], 0, b, off, this.segSize);
        }
        return b;
    }

    public int length() {
        return this.last;
    }

    public void read(int pos, byte[] buf, int off, int len) {
        this.ensureCapacity(pos, len);
        int seg = pos / this.segSize;
        int segoff = pos % this.segSize;
        while (len > 0) {
            int segrem = this.segSize - segoff;
            if (len <= segrem) {
                System.arraycopy(this.segment[seg], segoff, buf, off, len);
                return;
            }
            System.arraycopy(this.segment[seg], segoff, buf, off, segrem);
            off += segrem;
            len -= segrem;
            ++seg;
            segoff = 0;
        }
    }

    public int readByte(int pos) {
        this.ensureCapacity(pos, 1);
        return this.segment[pos / this.segSize][pos % this.segSize] & 0xFF;
    }

    public int readShort(int pos) {
        int seg = pos / this.segSize;
        int off = pos % this.segSize;
        if (this.segSize - off < 2) {
            return this.readByte(pos + 0) << 8 | this.readByte(pos + 1) << 0;
        }
        this.ensureCapacity(pos, 2);
        return (this.segment[seg][off + 0] & 0xFF) << 8 | (this.segment[seg][off + 1] & 0xFF) << 0;
    }

    public int readInt(int pos) {
        int seg = pos / this.segSize;
        int off = pos % this.segSize;
        if (this.segSize - off < 4) {
            return this.readByte(pos + 0) << 24 | this.readByte(pos + 1) << 16 | this.readByte(pos + 2) << 8 | this.readByte(pos + 3) << 0;
        }
        this.ensureCapacity(pos, 4);
        return (this.segment[seg][off + 0] & 0xFF) << 24 | (this.segment[seg][off + 1] & 0xFF) << 16 | (this.segment[seg][off + 2] & 0xFF) << 8 | (this.segment[seg][off + 3] & 0xFF) << 0;
    }

    public long readLong(int pos) {
        int seg = pos / this.segSize;
        int off = pos % this.segSize;
        if (this.segSize - off < 8) {
            return (long)this.readByte(pos + 0) << 56 | (long)this.readByte(pos + 1) << 48 | (long)this.readByte(pos + 2) << 40 | (long)this.readByte(pos + 3) << 32 | (long)this.readByte(pos + 4) << 24 | (long)this.readByte(pos + 5) << 16 | (long)this.readByte(pos + 6) << 8 | (long)this.readByte(pos + 7) << 0;
        }
        this.ensureCapacity(pos, 8);
        return ((long)this.segment[seg][off + 0] & 0xFFL) << 56 | ((long)this.segment[seg][off + 1] & 0xFFL) << 48 | ((long)this.segment[seg][off + 2] & 0xFFL) << 40 | ((long)this.segment[seg][off + 3] & 0xFFL) << 32 | ((long)this.segment[seg][off + 4] & 0xFFL) << 24 | ((long)this.segment[seg][off + 5] & 0xFFL) << 16 | ((long)this.segment[seg][off + 6] & 0xFFL) << 8 | ((long)this.segment[seg][off + 7] & 0xFFL) << 0;
    }

    public void write(int pos, byte[] buf, int off, int len) {
        this.ensureCapacity(pos, len);
        int seg = pos / this.segSize;
        int segoff = pos % this.segSize;
        while (len > 0) {
            int segrem = this.segSize - segoff;
            if (len <= segrem) {
                try {
                    System.arraycopy(buf, off, this.segment[seg], segoff, len);
                }
                catch (RuntimeException ex) {
                    System.out.println("no of segments = " + this.segment.length);
                    System.out.println("segment = " + seg);
                    System.out.println("segment offset = " + segoff);
                    System.out.println("segment remaining = " + segrem);
                    System.out.println("byte array length = " + len);
                    throw ex;
                }
                return;
            }
            System.arraycopy(buf, off, this.segment[seg], segoff, segrem);
            off += segrem;
            len -= segrem;
            ++seg;
            segoff = 0;
        }
    }

    public void writeByte(int pos, int val) {
        this.ensureCapacity(pos, 1);
        this.segment[pos / this.segSize][pos % this.segSize] = (byte)(val & 0xFF);
    }

    public void writeShort(int pos, int val) {
        int seg = pos / this.segSize;
        int off = pos % this.segSize;
        if (this.segSize - off < 2) {
            this.writeByte(pos + 0, val >> 8);
            this.writeByte(pos + 1, val >> 0);
        } else {
            this.ensureCapacity(pos, 2);
            this.segment[seg][off + 0] = (byte)(val >> 8 & 0xFF);
            this.segment[seg][off + 1] = (byte)(val >> 0 & 0xFF);
        }
    }

    public void writeInt(int pos, int val) {
        int seg = pos / this.segSize;
        int off = pos % this.segSize;
        if (this.segSize - off < 4) {
            this.writeByte(pos + 0, val >> 24);
            this.writeByte(pos + 1, val >> 16);
            this.writeByte(pos + 2, val >> 8);
            this.writeByte(pos + 3, val >> 0);
        } else {
            this.ensureCapacity(pos, 4);
            this.segment[seg][off + 0] = (byte)(val >> 24 & 0xFF);
            this.segment[seg][off + 1] = (byte)(val >> 16 & 0xFF);
            this.segment[seg][off + 2] = (byte)(val >> 8 & 0xFF);
            this.segment[seg][off + 3] = (byte)(val >> 0 & 0xFF);
        }
    }

    public void writeLong(int pos, long val) {
        int seg = pos / this.segSize;
        int off = pos % this.segSize;
        if (this.segSize - off < 8) {
            this.writeByte(pos + 0, (int)(val >> 56));
            this.writeByte(pos + 1, (int)(val >> 48));
            this.writeByte(pos + 2, (int)(val >> 40));
            this.writeByte(pos + 3, (int)(val >> 32));
            this.writeByte(pos + 4, (int)(val >> 24));
            this.writeByte(pos + 5, (int)(val >> 16));
            this.writeByte(pos + 6, (int)(val >> 8));
            this.writeByte(pos + 7, (int)(val >> 0));
        } else {
            this.ensureCapacity(pos, 8);
            this.segment[seg][off + 0] = (byte)(val >> 56 & 0xFFL);
            this.segment[seg][off + 1] = (byte)(val >> 48 & 0xFFL);
            this.segment[seg][off + 2] = (byte)(val >> 40 & 0xFFL);
            this.segment[seg][off + 3] = (byte)(val >> 32 & 0xFFL);
            this.segment[seg][off + 4] = (byte)(val >> 24 & 0xFFL);
            this.segment[seg][off + 5] = (byte)(val >> 16 & 0xFFL);
            this.segment[seg][off + 6] = (byte)(val >> 8 & 0xFFL);
            this.segment[seg][off + 7] = (byte)(val >> 0 & 0xFFL);
        }
    }

    public void ensureCapacity(int off, int len) {
        int end = off + len;
        if (end > this.size) {
            int diff = off + len - this.size;
            int nseg = diff / this.segSize + 1;
            byte[][] tmp = new byte[this.segment.length + nseg][];
            System.arraycopy(this.segment, 0, tmp, 0, this.segment.length);
            for (int i = this.segment.length; i < tmp.length; ++i) {
                tmp[i] = new byte[this.segSize];
            }
            this.segment = tmp;
            this.size = this.segment.length * this.segSize;
        }
        if (end > this.last) {
            this.last = end;
        }
    }
}

