/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BrokerCoderException;
import com.wm.broker.coder.BrokerConstants;
import com.wm.broker.coder.IBrokerTypeCoder;
import com.wm.broker.coder.ISMemDataCoder;
import com.wm.broker.coder.byteArrayCoder;
import com.wm.broker.coder.resources.BrokerCoderExceptionBundle;
import com.wm.broker.encoding.BigDecimalCoder;
import com.wm.broker.encoding.BigIntegerCoder;
import com.wm.broker.encoding.BooleanCoder;
import com.wm.broker.encoding.ByteCoder;
import com.wm.broker.encoding.CharacterCoder;
import com.wm.broker.encoding.DateCoder;
import com.wm.broker.encoding.DoubleCoder;
import com.wm.broker.encoding.FloatCoder;
import com.wm.broker.encoding.GregorianCalendarCoder;
import com.wm.broker.encoding.IntegerCoder;
import com.wm.broker.encoding.LegacyCharacterCoder;
import com.wm.broker.encoding.LegacyStringCoder;
import com.wm.broker.encoding.LongCoder;
import com.wm.broker.encoding.ShortCoder;
import com.wm.broker.encoding.UnicodeValueCoder;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.ISMemDataImpl;
import com.wm.util.JournalLogger;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.util.sort.QuickSort;
import com.wm.util.sort.Sortable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;

class BrokerEncodingRegistry
implements BrokerConstants {
    private Hashtable _javaCoders = new Hashtable(11);
    private Hashtable _schemaCoders = new Hashtable(11);
    private Hashtable _brokerTypeToJava = new Hashtable(11);
    private static final int BROKER_TYPE_UNKNOWN = -1;
    private static boolean bootstrapped;
    static final BrokerEncodingRegistry _er;

    private BrokerEncodingRegistry() {
    }

    static final BrokerEncodingRegistry current() {
        if (!bootstrapped) {
            BrokerEncodingRegistry.bootstrap();
        }
        return _er;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bootstrap() {
        Class<BrokerEncodingRegistry> clazz = BrokerEncodingRegistry.class;
        synchronized (BrokerEncodingRegistry.class) {
            if (bootstrapped) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                _er.register(byte[].class, (IBrokerTypeCoder)new byteArrayCoder());
                _er.register(ISMemDataImpl.class, (IBrokerTypeCoder)new ISMemDataCoder());
                UnicodeValueCoder stringCoder = new UnicodeValueCoder();
                _er.register(BigDecimal.class, (IBrokerTypeCoder)new BigDecimalCoder());
                _er.register(BigInteger.class, (IBrokerTypeCoder)new BigIntegerCoder());
                _er.register(GregorianCalendar.class, (IBrokerTypeCoder)new GregorianCalendarCoder());
                _er.register(Byte.class, (IBrokerTypeCoder)new ByteCoder());
                _er.register(Character.class, (IBrokerTypeCoder)new CharacterCoder());
                _er.register(String.class, (IBrokerTypeCoder)stringCoder);
                _er.register(Boolean.class, (IBrokerTypeCoder)new BooleanCoder());
                _er.register(Double.class, (IBrokerTypeCoder)new DoubleCoder());
                _er.register(Float.class, (IBrokerTypeCoder)new FloatCoder());
                _er.register(Long.class, (IBrokerTypeCoder)new LongCoder());
                _er.register(Short.class, (IBrokerTypeCoder)new ShortCoder());
                _er.register(Integer.class, (IBrokerTypeCoder)new IntegerCoder());
                _er.register(Date.class, (IBrokerTypeCoder)new DateCoder());
                _er.register(QName.create(WEBM_NS, Name.create("ISOLatin1String")), (IBrokerTypeCoder)new LegacyStringCoder());
                _er.register(QName.create(WEBM_NS, Name.create("ISOLatin1Character")), (IBrokerTypeCoder)new LegacyCharacterCoder());
                Hashtable<String, IBrokerTypeCoder> coders = new Hashtable<String, IBrokerTypeCoder>();
                coders.put("com.wm.broker.encoding.UnicodeValueCoder", stringCoder);
                IData simpleTypeMap = BrokerEncodingRegistry.getSimpleTypeMap();
                IDataCursor mc = simpleTypeMap.getCursor();
                while (mc.next()) {
                    String className = mc.getKey();
                    QName schemaType = (QName)mc.getValue();
                    IBrokerTypeCoder coder = (IBrokerTypeCoder)coders.get(className);
                    if (coder == null) {
                        try {
                            Class<?> clazz2 = Class.forName(className);
                            coder = (IBrokerTypeCoder)clazz2.newInstance();
                            coders.put(className, coder);
                        }
                        catch (Exception ex) {
                            JournalLogger.log(31, 76, 1, (Object)className);
                            continue;
                        }
                    }
                    _er.register(schemaType, coder);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            bootstrapped = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    IBrokerTypeCoder getTypeCoder(QName schemaType) {
        return (IBrokerTypeCoder)this._schemaCoders.get(schemaType);
    }

    IBrokerTypeCoder getTypeCoder(Class javaType) {
        return (IBrokerTypeCoder)this._javaCoders.get(javaType);
    }

    IBrokerTypeCoder getTypeCoder(int brokerType) {
        Class clazz = (Class)this._brokerTypeToJava.get(new Integer(brokerType));
        if (clazz != null) {
            return (IBrokerTypeCoder)this._javaCoders.get(clazz);
        }
        return null;
    }

    int getBrokerType(Class javaType) {
        IBrokerTypeCoder coder = (IBrokerTypeCoder)this._javaCoders.get(javaType);
        if (coder == null) {
            return -1;
        }
        return coder.getBrokerType();
    }

    int getBrokerType(QName schemaType) {
        IBrokerTypeCoder coder = (IBrokerTypeCoder)this._schemaCoders.get(schemaType);
        if (coder == null) {
            return -1;
        }
        return coder.getBrokerType();
    }

    void register(Class javaType, IBrokerTypeCoder typeCoder) throws BrokerCoderException {
        if (this._javaCoders.containsKey(javaType)) {
            throw new BrokerCoderException(BrokerCoderExceptionBundle.class, BrokerCoderExceptionBundle.DUPLICATE_JAVA_TYPE_CODER, "", javaType.toString());
        }
        this._javaCoders.put(javaType, typeCoder);
        Integer type = new Integer(typeCoder.getBrokerType());
        this._brokerTypeToJava.put(type, javaType);
    }

    void register(QName schemaType, IBrokerTypeCoder typeCoder) throws BrokerCoderException {
        if (this._schemaCoders.containsKey(schemaType)) {
            throw new BrokerCoderException(BrokerCoderExceptionBundle.class, BrokerCoderExceptionBundle.DUPLICATE_SCHEMA_TYPE_CODER, "", "{" + schemaType.getNamespace() + "} " + schemaType.getNCName());
        }
        this._schemaCoders.put(schemaType, typeCoder);
    }

    void unregister(Class javaType) throws BrokerCoderException {
        if (!this._javaCoders.containsKey(javaType)) {
            throw new BrokerCoderException(BrokerCoderExceptionBundle.class, BrokerCoderExceptionBundle.NON_EXISTENT_JAVA_TYPE_CODER, "", javaType.toString());
        }
        IBrokerTypeCoder typeCoder = (IBrokerTypeCoder)this._javaCoders.get(javaType);
        Integer type = new Integer(typeCoder.getBrokerType());
        this._javaCoders.remove(javaType);
        this._brokerTypeToJava.remove(type);
    }

    void unregister(QName schemaType) throws BrokerCoderException {
        if (!this._schemaCoders.containsKey(schemaType)) {
            throw new BrokerCoderException(BrokerCoderExceptionBundle.class, BrokerCoderExceptionBundle.NON_EXISTENT_SCHEMA_TYPE_CODER, "", "{" + schemaType.getNamespace() + "} " + schemaType.getNCName());
        }
        this._schemaCoders.remove(schemaType);
    }

    public String toString() {
        Object key;
        StringBuffer sb = new StringBuffer();
        sb.append("Registered Java Classes for Broker Types\n");
        Enumeration brokerTypes = this._brokerTypeToJava.keys();
        while (brokerTypes.hasMoreElements()) {
            key = brokerTypes.nextElement();
            sb.append(Integer.toHexString((Integer)key));
            sb.append(" = ");
            sb.append(this._brokerTypeToJava.get(key).toString());
            sb.append('\n');
        }
        sb.append("Registered Java Type Coders\n");
        Enumeration javaCoders = this._javaCoders.keys();
        while (javaCoders.hasMoreElements()) {
            key = javaCoders.nextElement();
            sb.append(key.toString());
            sb.append(" = ");
            sb.append(this._javaCoders.get(key).getClass().toString());
            sb.append('\n');
        }
        sb.append("Registered Schema Type Coders\n");
        Enumeration schemaCoders = this._schemaCoders.keys();
        while (schemaCoders.hasMoreElements()) {
            QName schemaType = (QName)schemaCoders.nextElement();
            sb.append('{');
            sb.append(schemaType.getNamespace());
            sb.append("} ");
            sb.append(schemaType.getNCName());
            sb.append(" = ");
            sb.append(this._schemaCoders.get(schemaType).getClass().toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public IData[] list() {
        IBrokerTypeCoder coder;
        Sortable[] list = new Values[this._javaCoders.size() + this._schemaCoders.size()];
        Enumeration javaCoders = this._javaCoders.keys();
        int i = 0;
        while (javaCoders.hasMoreElements()) {
            Object key = javaCoders.nextElement();
            coder = (IBrokerTypeCoder)this._javaCoders.get(key);
            Object[][] o = new Object[][]{{"name", key.toString()}, {"typeCoder", coder.getClass().toString()}, {"brokerType", this.getBrokerType(coder)}};
            list[i++] = new Values(o);
        }
        Enumeration schemaCoders = this._schemaCoders.keys();
        while (schemaCoders.hasMoreElements()) {
            QName schemaType = (QName)schemaCoders.nextElement();
            coder = (IBrokerTypeCoder)this._schemaCoders.get(schemaType);
            Object[][] o = new Object[][]{{"name", "{" + schemaType.getNamespace() + "} " + schemaType.getNCName()}, {"typeCoder", coder.getClass().toString()}, {"brokerType", this.getBrokerType(coder)}};
            list[i++] = new Values(o);
        }
        Sortable[] sortedList = QuickSort.sort(list);
        IData[] idataList = new IData[sortedList.length];
        System.arraycopy(sortedList, 0, idataList, 0, sortedList.length);
        return idataList;
    }

    private String getBrokerType(IBrokerTypeCoder coder) {
        int brokerType = coder.getBrokerType();
        switch (brokerType) {
            case 1: {
                return "BYTE";
            }
            case 2: {
                return "SHORT";
            }
            case 4: {
                return "INT";
            }
            case 8: {
                return "LONG";
            }
            case 20: {
                return "FLOAT";
            }
            case 24: {
                return "DOUBLE";
            }
            case 33: {
                return "BOOLEAN";
            }
            case 40: {
                return "DATE";
            }
            case 49: {
                return "CHAR";
            }
            case 50: {
                return "UNICODE_CHAR";
            }
            case 65: {
                return "STRING";
            }
            case 66: {
                return "UNICODE_STRING";
            }
            case 129: {
                return "SEQUENCE";
            }
            case 130: {
                return "STRUCTURE";
            }
        }
        return "I don't know";
    }

    private static final IData getSimpleTypeMap() {
        IData map = IDataFactory.create();
        IDataCursor mc = map.getCursor();
        String _string = "com.wm.broker.encoding.UnicodeValueCoder";
        String _boolean = "com.wm.broker.encoding.SchemaBooleanCoder";
        String _byte = "com.wm.broker.encoding.SchemaByteCoder";
        String _date = "com.wm.broker.encoding.SchemaDateCoder";
        String _dateTime = "com.wm.broker.encoding.SchemaDateTimeCoder";
        String _double = "com.wm.broker.encoding.SchemaDoubleCoder";
        String _float = "com.wm.broker.encoding.SchemaFloatCoder";
        String _int = "com.wm.broker.encoding.SchemaIntCoder";
        String _long = "com.wm.broker.encoding.SchemaLongCoder";
        String _short = "com.wm.broker.encoding.SchemaShortCoder";
        String _time = "com.wm.broker.encoding.SchemaTimeCoder";
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("anySimpleType")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("string")));
        mc.insertAfter(_boolean, QName.create(SCHEMA_10_NS, Name.create("boolean")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("decimal")));
        mc.insertAfter(_float, QName.create(SCHEMA_10_NS, Name.create("float")));
        mc.insertAfter(_double, QName.create(SCHEMA_10_NS, Name.create("double")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("duration")));
        mc.insertAfter(_dateTime, QName.create(SCHEMA_10_NS, Name.create("dateTime")));
        mc.insertAfter(_time, QName.create(SCHEMA_10_NS, Name.create("time")));
        mc.insertAfter(_date, QName.create(SCHEMA_10_NS, Name.create("date")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("gYearMonth")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("gYear")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("gMonthDay")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("gDay")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("gMonth")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("hexBinary")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("base64Binary")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("anyURI")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("QName")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("NOTATION")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("normalizedString")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("token")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("language")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("NMTOKEN")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("NMTOKENS")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("Name")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("NCName")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("ID")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("IDREF")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("IDREFS")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("ENTITY")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("ENTITIES")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("integer")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("nonPositiveInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("negativeInteger")));
        mc.insertAfter(_long, QName.create(SCHEMA_10_NS, Name.create("long")));
        mc.insertAfter(_int, QName.create(SCHEMA_10_NS, Name.create("int")));
        mc.insertAfter(_short, QName.create(SCHEMA_10_NS, Name.create("short")));
        mc.insertAfter(_byte, QName.create(SCHEMA_10_NS, Name.create("byte")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("nonNegativeInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("unsignedLong")));
        mc.insertAfter(_long, QName.create(SCHEMA_10_NS, Name.create("unsignedInt")));
        mc.insertAfter(_int, QName.create(SCHEMA_10_NS, Name.create("unsignedShort")));
        mc.insertAfter(_short, QName.create(SCHEMA_10_NS, Name.create("unsignedByte")));
        mc.insertAfter(_string, QName.create(SCHEMA_10_NS, Name.create("positiveInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("anySimpleType")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("string")));
        mc.insertAfter(_boolean, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("boolean")));
        mc.insertAfter(_float, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("float")));
        mc.insertAfter(_double, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("double")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("decimal")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("timeDuration")));
        mc.insertAfter(_dateTime, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("recurringDuration")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("binary")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("uriReference")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("ID")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("IDREF")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("ENTITY")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("QName")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("CDATA")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("token")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("language")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("IDREFS")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("ENTITIES")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("NMTOKEN")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("NMTOKENS")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("Name")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("NCName")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("NOTATION")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("integer")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("nonPositiveInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("negativeInteger")));
        mc.insertAfter(_long, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("long")));
        mc.insertAfter(_int, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("int")));
        mc.insertAfter(_short, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("short")));
        mc.insertAfter(_byte, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("byte")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("nonNegativeInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("unsignedLong")));
        mc.insertAfter(_long, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("unsignedInt")));
        mc.insertAfter(_int, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("unsignedShort")));
        mc.insertAfter(_short, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("unsignedByte")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("positiveInteger")));
        mc.insertAfter(_dateTime, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("timeInstant")));
        mc.insertAfter(_time, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("time")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("timePeriod")));
        mc.insertAfter(_date, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("date")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("month")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("year")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("century")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("recurringDate")));
        mc.insertAfter(_string, QName.create(SCHEMA_OCTOBER_2000_NS, Name.create("recurringDay")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("anySimpleType")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("string")));
        mc.insertAfter(_boolean, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("boolean")));
        mc.insertAfter(_float, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("float")));
        mc.insertAfter(_double, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("double")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("decimal")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("timeDuration")));
        mc.insertAfter(_dateTime, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("recurringDuration")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("binary")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("uriReference")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("ID")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("IDREF")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("ENTITY")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("QName")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("CDATA")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("token")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("language")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("IDREFS")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("ENTITIES")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("NMTOKEN")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("NMTOKENS")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("Name")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("NCName")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("NOTATION")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("integer")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("nonPositiveInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("negativeInteger")));
        mc.insertAfter(_long, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("long")));
        mc.insertAfter(_int, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("int")));
        mc.insertAfter(_short, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("short")));
        mc.insertAfter(_byte, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("byte")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("nonNegativeInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("unsignedLong")));
        mc.insertAfter(_long, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("unsignedInt")));
        mc.insertAfter(_int, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("unsignedShort")));
        mc.insertAfter(_short, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("unsignedByte")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("positiveInteger")));
        mc.insertAfter(_dateTime, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("timeInstant")));
        mc.insertAfter(_time, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("time")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("timePeriod")));
        mc.insertAfter(_date, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("date")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("month")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("year")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("century")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("recurringDate")));
        mc.insertAfter(_string, QName.create(SCHEMA_SEPTEMBER_2000_NS, Name.create("recurringDay")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("urSimpleType")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("string")));
        mc.insertAfter(_boolean, QName.create(SCHEMA_APRIL_2000_NS, Name.create("boolean")));
        mc.insertAfter(_float, QName.create(SCHEMA_APRIL_2000_NS, Name.create("float")));
        mc.insertAfter(_double, QName.create(SCHEMA_APRIL_2000_NS, Name.create("double")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("decimal")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("timeDuration")));
        mc.insertAfter(_dateTime, QName.create(SCHEMA_APRIL_2000_NS, Name.create("recurringDuration")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("binary")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("uriReference")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("ID")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("IDREF")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("ENTITY")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("NOTATION")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("QName")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("language")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("IDREFS")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("ENTITIES")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("NMTOKEN")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("NMTOKENS")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("Name")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("NCName")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("integer")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("nonPositiveInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("negativeInteger")));
        mc.insertAfter(_long, QName.create(SCHEMA_APRIL_2000_NS, Name.create("long")));
        mc.insertAfter(_int, QName.create(SCHEMA_APRIL_2000_NS, Name.create("int")));
        mc.insertAfter(_short, QName.create(SCHEMA_APRIL_2000_NS, Name.create("short")));
        mc.insertAfter(_byte, QName.create(SCHEMA_APRIL_2000_NS, Name.create("byte")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("nonNegativeInteger")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("unsignedLong")));
        mc.insertAfter(_long, QName.create(SCHEMA_APRIL_2000_NS, Name.create("unsignedInt")));
        mc.insertAfter(_int, QName.create(SCHEMA_APRIL_2000_NS, Name.create("unsignedShort")));
        mc.insertAfter(_short, QName.create(SCHEMA_APRIL_2000_NS, Name.create("unsignedByte")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("positiveInteger")));
        mc.insertAfter(_dateTime, QName.create(SCHEMA_APRIL_2000_NS, Name.create("timeInstant")));
        mc.insertAfter(_time, QName.create(SCHEMA_APRIL_2000_NS, Name.create("time")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("timePeriod")));
        mc.insertAfter(_date, QName.create(SCHEMA_APRIL_2000_NS, Name.create("date")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("month")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("year")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("century")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("recurringDate")));
        mc.insertAfter(_string, QName.create(SCHEMA_APRIL_2000_NS, Name.create("recurringDay")));
        return map;
    }

    static {
        _er = new BrokerEncodingRegistry();
    }
}

