/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.ArrayType;
import com.wm.broker.coder.BrokerCoderException;
import com.wm.broker.coder.BrokerCoderRuntimeException;
import com.wm.broker.coder.BrokerConstants;
import com.wm.broker.coder.BrokerEncodingRegistry;
import com.wm.broker.coder.BytePool;
import com.wm.broker.coder.BytePoolReader;
import com.wm.broker.coder.BytePoolWriter;
import com.wm.broker.coder.Context;
import com.wm.broker.coder.GivenValueInformation;
import com.wm.broker.coder.HeaderInformation;
import com.wm.broker.coder.IBrokerCoder;
import com.wm.broker.coder.IBrokerDateTypeCoder;
import com.wm.broker.coder.IBrokerSimpleTypeCoder;
import com.wm.broker.coder.SchemaUtil;
import com.wm.broker.coder.TagInformation;
import com.wm.broker.coder.WireValueInformation;
import com.wm.broker.coder.resources.BrokerCoderExceptionBundle;
import com.wm.broker.coder.resources.BrokerCoderRuntimeExceptionBundle;
import com.wm.broker.encoding.StringValueCoder;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.schema.SimpleType;
import com.wm.util.BrokerUtil;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.IntegerList;
import com.wm.util.JavaWrapperType;
import com.wm.util.JournalLogger;
import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.util.Table;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.coder.IDataCoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;

class BrokerCoder
extends IDataCoder
implements IBrokerCoder,
BrokerConstants {
    private static IBrokerSimpleTypeCoder nameCoder = new StringValueCoder(true);
    private static final Class TABLE = Table.class;
    private static int HEADER_NUM_OF_FIELDS_POS = 24;
    private static int LATEST_SUPPORTED_WIRE_FORMAT_VERSION = 3;
    private boolean _useMultiReferences = true;
    private int _wireFormatVersion = 3;
    private boolean _verbose = new Boolean(System.getProperty("watt.core.brokerCoder.verbose"));
    static final int VALUE_NORMAL = 0;
    static final int VALUE_MULTI_REFERENCE = 1;
    static final int VALUE_NULL = 2;
    static final int VALUE_HAS_SOURCE_TIME_ZONE = 3;
    static final int TAG_NORMAL = 0;
    static final int TAG_INVALID = 1;
    static final int TAG_WITHOUT_DECLARATION = 2;
    static final int TYPE_SIMPLE = 0;
    static final int TYPE_COMPLEX = 1;
    static final int TYPE_ARRAY = 2;

    BrokerCoder() {
        String strWireFormat = System.getProperty("watt.core.brokerCoder.wireFormat");
        if (strWireFormat != null) {
            try {
                int wireFormatVersion = Integer.parseInt(strWireFormat);
                if (wireFormatVersion <= LATEST_SUPPORTED_WIRE_FORMAT_VERSION) {
                    this._wireFormatVersion = wireFormatVersion;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void encode(OutputStream os, IData data) throws BrokerCoderRuntimeException {
        throw new UnsupportedOperationException();
    }

    public IData decode(InputStream is) throws BrokerCoderRuntimeException {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public void setUseMultiReferences(boolean use) {
        this._useMultiReferences = use;
    }

    public void setWireFormatVersion(int version) throws BrokerCoderException {
        if (version > LATEST_SUPPORTED_WIRE_FORMAT_VERSION) {
            Object[] args = new Object[]{Integer.toString(version), Integer.toString(LATEST_SUPPORTED_WIRE_FORMAT_VERSION)};
            throw new BrokerCoderException(BrokerCoderExceptionBundle.class, BrokerCoderExceptionBundle.UNSUPPORTED_VERSION, "", args);
        }
        this._wireFormatVersion = version;
    }

    public int getLatestSupportedWireFormatVersion() {
        return LATEST_SUPPORTED_WIRE_FORMAT_VERSION;
    }

    public byte[] encodeToBytes(IData data, NSRecord record) throws BrokerCoderRuntimeException, IOException {
        if (data == null || record == null) {
            JournalLogger.log(26, 76, 1);
            throw new BrokerCoderRuntimeException(BrokerCoderRuntimeExceptionBundle.class, BrokerCoderRuntimeExceptionBundle.NULL_ARGUMENTS, "");
        }
        if (this._verbose) {
            BrokerCoder.log(this.toString());
            BrokerCoder.log("------ Received ------");
            BrokerCoder.print(data);
        }
        Context context = Context.create(0, null);
        context.setSchema(record);
        NSName id = record.getNSName();
        if (id != null) {
            context.pushType(id);
        }
        BytePool pool = context.getPool();
        BytePoolWriter writer = new BytePoolWriter(pool, 0);
        writer.startField();
        String brokerEventTypeName = context.getBrokerEventTypeName();
        if (brokerEventTypeName == null) {
            JournalLogger.log(27, 76, 1);
            throw new BrokerCoderRuntimeException(BrokerCoderRuntimeExceptionBundle.class, BrokerCoderRuntimeExceptionBundle.MISSING_EVENT_TYPE_NAME, "");
        }
        this.encodeHeader(writer, brokerEventTypeName);
        int noOfBodyFields = this.encodeFields(context, data, record, this._wireFormatVersion, true, writer);
        writer.endField();
        IDataCursor dataCursor = data.getCursor();
        IData envelope = null;
        if (dataCursor.last() && dataCursor.getKey().equals("_env")) {
            envelope = (IData)dataCursor.getValue();
        }
        dataCursor.destroy();
        if (envelope == null) {
            envelope = IDataFactory.create();
        }
        IDataCursor envCursor = envelope.getCursor();
        envCursor.insertAfter("is_WireFormatVersion", new Integer(this._wireFormatVersion));
        IData wireTags = context.getWireTags();
        if (wireTags != null) {
            ByteOutputBuffer bob = new ByteOutputBuffer();
            new IDataBinCoder().encode(bob, wireTags);
            envCursor.insertAfter("is_WireTags", bob.toByteArray());
        }
        this.encodeStructure(context, envelope, (NSRecord)record.getFieldByName("_env"), 0, writer);
        this.applyFinishingTouch(writer, noOfBodyFields);
        if (wireTags != null) {
            envCursor.delete();
        }
        envCursor.delete();
        envCursor.destroy();
        byte[] bytes = pool.toByteArray();
        if (this._verbose) {
            BrokerCoder.log("------ Produced ------");
            BrokerCoder.printBytes(bytes);
        }
        return bytes;
    }

    public IData decodeFromBytes(byte[] bytes, NSRecord record) throws BrokerCoderRuntimeException, IOException {
        if (bytes == null || record == null) {
            JournalLogger.log(32, 76, 1);
            throw new BrokerCoderRuntimeException(BrokerCoderRuntimeExceptionBundle.class, BrokerCoderRuntimeExceptionBundle.NULL_ARGUMENTS2, "");
        }
        if (this._verbose) {
            BrokerCoder.log(this.toString());
            BrokerCoder.log("------ Received ------");
            BrokerCoder.printBytes(bytes);
        }
        Context context = Context.create(1, bytes);
        context.setSchema(record);
        BytePool pool = context.getPool();
        BytePoolReader reader = new BytePoolReader(pool, 0);
        HeaderInformation headerInfo = this.decodeHeader(reader);
        int dataPosition = reader.getPosition();
        reader.setPosition(headerInfo.dataLength);
        int wireFormatVersion = 0;
        IData envelope = this.decodeStructure(context, (NSRecord)record.getFieldByName("_env"), 0, reader);
        IData wireTags = null;
        IDataCursor envCursor = envelope.getCursor();
        if (envCursor.first("is_WireFormatVersion")) {
            wireFormatVersion = (Integer)envCursor.getValue();
            envCursor.delete();
        }
        if (this._verbose) {
            BrokerCoder.log("#### wireFormatVersion, from byte[] is=" + wireFormatVersion + " ####");
        }
        if (wireFormatVersion > LATEST_SUPPORTED_WIRE_FORMAT_VERSION) {
            Object[] args = new Object[]{Integer.toString(wireFormatVersion), Integer.toString(LATEST_SUPPORTED_WIRE_FORMAT_VERSION)};
            JournalLogger.log(28, 76, args);
            throw new BrokerCoderRuntimeException(BrokerCoderRuntimeExceptionBundle.class, BrokerCoderRuntimeExceptionBundle.UNSUPPORTED_VERSION, "", args);
        }
        if (envCursor.first("is_WireTags")) {
            byte[] rawWireTags = (byte[])envCursor.getValue();
            wireTags = new IDataBinCoder().decode(new ByteArrayInputStream(rawWireTags));
            envCursor.delete();
        }
        if (wireTags != null) {
            if (this._verbose) {
                BrokerCoder.log(this.toString());
                BrokerCoder.log("------ Wire Tags ------");
                BrokerCoder.print(wireTags);
            }
            context.setWireTags(wireTags);
        }
        reader.setPosition(dataPosition);
        IData data = this.decodeFields(context, headerInfo.noOfFields, record, wireFormatVersion, reader);
        IDataCursor dataCursor = data.getCursor();
        dataCursor.last();
        dataCursor.insertAfter("_env", envelope);
        envCursor.destroy();
        dataCursor.destroy();
        if (this._verbose) {
            BrokerCoder.log("------ Produced ------");
            BrokerCoder.print(data);
        }
        return data;
    }

    private void encodeHeader(BytePoolWriter writer, String brokerEventTypeName) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("encodeHeader: (eventTypeName=" + brokerEventTypeName + ")");
        }
        writer.writeInt(15786192);
        writer.writeInt(65537);
        writer.writeInt(0);
        int pos = writer.getPosition();
        writer.skip(4);
        writer.writeInt(0);
        writer.skip(2);
        writer.writeShort(1);
        nameCoder.encode(writer, brokerEventTypeName);
        writer.writeLong(0L);
        writer.getPool().writeInt(pos, writer.getPosition());
    }

    private void applyFinishingTouch(BytePoolWriter writer, int noOfBodyFields) {
        if (this._verbose) {
            BrokerCoder.log("applyFinishingTouch: (noOfBodyFields=" + noOfBodyFields + ")");
        }
        writer.getPool().writeShort(HEADER_NUM_OF_FIELDS_POS, noOfBodyFields);
        if (this._verbose) {
            BrokerCoder.log("#### Adding Mysterious End Marker - 0008 0000 ####");
        }
        writer.writeInt(8);
        writer.writeInt(0);
    }

    private int encodeFields(Context context, IData data, NSRecord record, int wireFormatVersion, boolean isTopLevel, BytePoolWriter writer) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("encodeFields: data=(" + data + ") record=(" + record + ") @ " + writer.getPosition());
        }
        IDataCursor cursor = data.getCursor();
        int count = 0;
        boolean success = false;
        while (cursor.next()) {
            NSField field;
            String key = cursor.getKey();
            Object val = cursor.getValue();
            if (isTopLevel && key.equals("_env") || !(success = this.encodeField(context, key, val, field = record != null && key != null ? record.getFieldByName(key) : null, wireFormatVersion, writer))) continue;
            ++count;
        }
        cursor.destroy();
        return count;
    }

    private boolean encodeField(Context context, String key, Object value, NSField field, int wireFormatVersion, BytePoolWriter writer) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("encodeField: (" + key + "=" + value + ") field=(" + field + ") @ " + writer.getPosition());
        }
        TagInformation tagInfo = this.computeTagInformation(context, key, value, field, wireFormatVersion);
        if (this._verbose) {
            BrokerCoder.log(tagInfo.toString());
        }
        String computedKey = key;
        int brokerType = 0;
        boolean useSurrogate = false;
        if (tagInfo.nature != 0) {
            switch (wireFormatVersion) {
                case 2: 
                case 3: {
                    useSurrogate = true;
                    if (!this._verbose) break;
                    BrokerCoder.log("#### Using Surrogate ... ####");
                    break;
                }
                case 1: {
                    if (this._verbose) {
                        BrokerCoder.log("#### Dropping off ... ####");
                    }
                    if (tagInfo.isTypeReference) {
                        context.popType();
                    }
                    return false;
                }
                default: {
                    if (tagInfo.nature != 1) break;
                    if (this._verbose) {
                        BrokerCoder.log("#### Dropping off ... ####");
                    }
                    if (tagInfo.isTypeReference) {
                        context.popType();
                    }
                    return false;
                }
            }
        }
        if (useSurrogate) {
            computedKey = "is_Surrogate";
            brokerType = 4;
        } else {
            switch (tagInfo.type) {
                case 0: {
                    brokerType = tagInfo.coder.getBrokerType();
                    break;
                }
                case 1: {
                    brokerType = 130;
                    break;
                }
                case 2: {
                    brokerType = 129;
                    break;
                }
            }
        }
        writer.startField();
        this.writeFieldHeader(brokerType, computedKey, writer);
        this.encodeValue(context, key, value, field, tagInfo, wireFormatVersion, writer);
        writer.endField();
        if (tagInfo.isTypeReference) {
            context.popType();
        }
        return true;
    }

    private void writeFieldHeader(int brokerType, String name, BytePoolWriter writer) {
        if (this._verbose) {
            BrokerCoder.log("writeFieldHeader: (type=" + this.hex(brokerType) + ") (name=" + name + ") @ " + writer.getPosition());
        }
        writer.writeShort(brokerType);
        nameCoder.encode(writer, name);
    }

    private void encodeValue(Context context, String key, Object value, NSField field, TagInformation tagInfo, int wireFormatVersion, BytePoolWriter writer) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("encodeValue: (" + value + ") @ " + writer.getPosition());
        }
        boolean useDefaultValue = false;
        boolean isTable = false;
        GivenValueInformation valueInfo = null;
        if (wireFormatVersion >= 1) {
            valueInfo = this.computeValueInformation(context, value, tagInfo, wireFormatVersion);
            if (this._verbose) {
                BrokerCoder.log(valueInfo.toString());
            }
            if (tagInfo.nature != 0 || tagInfo.isUnknownType || valueInfo.nature != 0) {
                if (this._verbose) {
                    BrokerCoder.log("#### Creating a wire capsule ... ####");
                }
                context.addWireCapsule(valueInfo.SID);
            }
            if (tagInfo.nature != 0) {
                context.addWireTag("tag", key);
                context.addWireTag("value", value);
                useDefaultValue = true;
            }
            if (tagInfo.isUnknownType) {
                context.addWireTag("value", value);
                useDefaultValue = true;
            }
            if (valueInfo.nature != 0) {
                switch (valueInfo.nature) {
                    case 2: {
                        context.addWireTag("value", null);
                        useDefaultValue = true;
                        break;
                    }
                    case 1: {
                        context.deleteWireTag("value");
                        context.addWireTag("ref", valueInfo.ref);
                        if (wireFormatVersion >= 3 && !valueInfo.isRecursive) break;
                        useDefaultValue = true;
                        break;
                    }
                    case 3: {
                        context.addWireTag("soureTimeZone", valueInfo.sourceTimeZone);
                        IBrokerDateTypeCoder coder = (IBrokerDateTypeCoder)tagInfo.coder;
                        if (this._verbose) {
                            BrokerCoder.log("#### Converting this date value to UTC ... ####");
                        }
                        coder.encode(writer, value, valueInfo.sourceTimeZone);
                        return;
                    }
                }
            }
            isTable = valueInfo.isTable;
        } else if (value == null) {
            useDefaultValue = true;
        }
        if (this._verbose && useDefaultValue) {
            BrokerCoder.log("#### Using Default Value ... ####");
        }
        switch (tagInfo.type) {
            case 0: {
                IBrokerSimpleTypeCoder coder = (IBrokerSimpleTypeCoder)tagInfo.coder;
                coder.encode(writer, useDefaultValue ? coder.getDefaultValue() : value);
                break;
            }
            case 1: {
                this.encodeStructure(context, useDefaultValue ? STRUCTURE_DEFAULT_VALUE : (IData)value, (NSRecord)field, wireFormatVersion, writer);
                break;
            }
            case 2: {
                TagInformation itemInfo = tagInfo.additionalInformation;
                if (useDefaultValue) {
                    writer.startField();
                    writer.writeInt(0);
                    writer.writeShort(0);
                    if (field.getDimensions() > 1) {
                        writer.writeShort(129);
                    } else if (itemInfo.nature == 0) {
                        writer.writeShort(itemInfo.coder.getBrokerType());
                    } else {
                        writer.writeShort(130);
                    }
                    writer.endField();
                    break;
                }
                this.encodeArray(context, isTable ? ((Table)value).getItems() : (Object[])value, field, itemInfo, wireFormatVersion, writer);
                break;
            }
        }
        if (wireFormatVersion >= 1 && valueInfo.tracked) {
            context.popValue();
        }
    }

    private void encodeStructure(Context context, IData data, NSRecord record, int wireFormatVersion, BytePoolWriter writer) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("encodeStructure: data=(" + data + ") record=(" + record + ") @ " + writer.getPosition());
        }
        writer.startField();
        int numpos = writer.getPosition();
        writer.skip(4);
        int count = this.encodeFields(context, data, record, wireFormatVersion, false, writer);
        writer.endField();
        writer.getPool().writeShort(numpos, count);
    }

    private void encodeArray(Context context, Object[] array, NSField field, TagInformation tagInfo, int wireFormatVersion, BytePoolWriter writer) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("encodeArray: (array=" + array.getClass().toString() + ", size=" + array.length + ") @ " + writer.getPosition());
        }
        writer.startField();
        writer.writeInt(array.length);
        writer.writeShort(0);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null && array[i].getClass().isArray()) {
                if (i == 0) {
                    writer.writeShort(129);
                }
                this.encodeArray(context, (Object[])array[i], field, tagInfo, wireFormatVersion, writer);
                continue;
            }
            if (i == 0) {
                if (tagInfo.type == 0) {
                    writer.writeShort(tagInfo.coder.getBrokerType());
                } else {
                    writer.writeShort(130);
                }
            }
            this.encodeValue(context, null, array[i], field, tagInfo, wireFormatVersion, writer);
        }
        writer.endField();
    }

    private TagInformation computeTagInformation(Context context, String key, NSField field) {
        QName schemaType = null;
        BrokerEncodingRegistry er = BrokerEncodingRegistry.current();
        TagInformation tagInfo = new TagInformation();
        if (field != null) {
            switch (field.getType()) {
                case 1: {
                    SimpleType simpleType;
                    schemaType = field.getSchemaTypeName();
                    if (schemaType != null && er.getTypeCoder(schemaType) == null) {
                        schemaType = null;
                    }
                    if (schemaType == null && (simpleType = (SimpleType)field.getContentType()) != null) {
                        schemaType = SchemaUtil.computeCoderPrimitiveType(simpleType, er);
                    }
                    if (schemaType == null) {
                        schemaType = DEFAULT_SIMPLE_CODER_PRIMITIVE_TYPE;
                    }
                    tagInfo.coderPrimitiveType = schemaType;
                    tagInfo.coder = er.getTypeCoder(schemaType);
                    break;
                }
                case 4: {
                    tagInfo.isTypeReference = true;
                    NSName id = ((NSRecordRef)field).getTargetName();
                    context.pushType(id);
                    if (context.isRecursiveType(id)) {
                        if (this._verbose) {
                            BrokerCoder.log("#### Oh NO! type recursion and is the point of recursion ####");
                        }
                        tagInfo.nature = 2;
                        return tagInfo;
                    }
                }
                case 2: {
                    tagInfo.type = 1;
                    tagInfo.coder = er.getTypeCoder(DEFAULT_COMPLEX_WRAPPER_TYPE);
                    break;
                }
                default: {
                    int javaWrapperType = field.getJavaWrapperType();
                    if (javaWrapperType == 0) {
                        tagInfo.coder = er.getTypeCoder(byte[].class);
                        tagInfo.isUnknownType = true;
                        break;
                    }
                    tagInfo.coder = er.getTypeCoder(JavaWrapperType.getClazz(javaWrapperType));
                }
            }
            if (!tagInfo.isUnknownType && field.getDimensions() > 0) {
                TagInformation temp = new TagInformation();
                temp.isTypeReference = tagInfo.isTypeReference;
                tagInfo.isTypeReference = false;
                temp.additionalInformation = tagInfo;
                tagInfo = temp;
                tagInfo.type = 2;
            }
        }
        if (key != null) {
            if (field == null) {
                tagInfo.nature = 2;
            }
            if (!BrokerUtil.validateFieldName(key)) {
                tagInfo.nature = 1;
            }
        } else {
            tagInfo.nature = 1;
        }
        return tagInfo;
    }

    private TagInformation computeTagInformation(Context context, String key, Object value, NSField field, int wireFormatVersion) {
        TagInformation tagInfo = this.computeTagInformation(context, key, field);
        BrokerEncodingRegistry er = BrokerEncodingRegistry.current();
        if (wireFormatVersion >= 1) {
            if (tagInfo.nature != 0) {
                tagInfo.coder = er.getTypeCoder(4);
            }
        } else if (tagInfo.coder == null) {
            tagInfo.coder = er.getTypeCoder(value.getClass());
        }
        return tagInfo;
    }

    private TagInformation computeTagInformation(Context context, String key, int brokerType, NSField field, int wireFormatVersion) {
        TagInformation tagInfo = this.computeTagInformation(context, key, field);
        BrokerEncodingRegistry er = BrokerEncodingRegistry.current();
        if (wireFormatVersion >= 1) {
            if (tagInfo.nature != 0) {
                tagInfo.coder = er.getTypeCoder(brokerType);
            }
            if (tagInfo.isUnknownType) {
                // empty if block
            }
        } else if (tagInfo.nature != 0 || tagInfo.isUnknownType) {
            if (key.equals("is_WireTags")) {
                tagInfo.coder = er.getTypeCoder(byte[].class);
            } else {
                switch (brokerType) {
                    case 129: {
                        tagInfo.isUnknownType = true;
                        tagInfo.coder = null;
                        TagInformation temp = new TagInformation();
                        temp.additionalInformation = tagInfo;
                        tagInfo = temp;
                        tagInfo.type = 2;
                        break;
                    }
                    case 130: {
                        tagInfo.type = 1;
                        tagInfo.coder = er.getTypeCoder(DEFAULT_COMPLEX_WRAPPER_TYPE);
                        break;
                    }
                    default: {
                        tagInfo.coder = er.getTypeCoder(brokerType);
                    }
                }
            }
        }
        return tagInfo;
    }

    private GivenValueInformation computeValueInformation(Context context, Object value, TagInformation tagInfo, int wireFormatVersion) {
        GivenValueInformation valueInfo = new GivenValueInformation();
        valueInfo.SID = context.getNextSID();
        if (value == null) {
            valueInfo.nature = 2;
        } else {
            IBrokerDateTypeCoder coder;
            Class<?> clazz = value.getClass();
            if (this._useMultiReferences && (tagInfo.type != 0 || clazz == Date.class || clazz == GregorianCalendar.class || clazz == byte[].class)) {
                context.pushValue(value);
                valueInfo.tracked = true;
                Integer ref = context.getSID(value);
                if (ref == null) {
                    context.putSID(valueInfo.SID, value);
                } else {
                    valueInfo.nature = 1;
                    valueInfo.ref = ref;
                    valueInfo.isRecursive = context.isRecursiveValue(value);
                }
            }
            if (valueInfo.nature != 1 && tagInfo.coderPrimitiveType != null && tagInfo.coder.getCoderType() == 2 && (coder = (IBrokerDateTypeCoder)tagInfo.coder).hasTimeZone(value)) {
                valueInfo.nature = 3;
                valueInfo.sourceTimeZone = coder.retrieveTimeZone(value);
            }
            if (valueInfo.nature == 0 && clazz == TABLE) {
                valueInfo.isTable = true;
            }
        }
        return valueInfo;
    }

    private WireValueInformation computeValueInformation(Context context) {
        WireValueInformation valueInfo = new WireValueInformation();
        valueInfo.SID = context.getNextSID();
        IData wireCapsule = context.getWireCapsule(valueInfo.SID);
        if (wireCapsule != null) {
            IDataCursor cursor = wireCapsule.getCursor();
            while (cursor.next()) {
                String key = cursor.getKey();
                if (key.equals("tag")) {
                    valueInfo.tag = (String)cursor.getValue();
                    continue;
                }
                if (key.equals("value")) {
                    valueInfo.value = cursor.getValue();
                    if (valueInfo.value != null) continue;
                    valueInfo.nature = 2;
                    continue;
                }
                if (key.equals("ref")) {
                    valueInfo.nature = 1;
                    valueInfo.ref = (Integer)cursor.getValue();
                    continue;
                }
                if (!key.equals("soureTimeZone")) continue;
                valueInfo.nature = 3;
                valueInfo.sourceTimeZone = (Integer)cursor.getValue();
            }
            cursor.destroy();
        }
        return valueInfo;
    }

    private HeaderInformation decodeHeader(BytePoolReader reader) throws BrokerCoderRuntimeException {
        int dataLength = reader.readInt();
        int cookie = reader.readInt();
        int version = reader.readInt();
        int checksum = reader.readInt();
        int headerLength = reader.readInt();
        int clock = reader.readInt();
        int noOfFields = reader.readShort();
        int numnames = reader.readShort();
        String eventType = (String)nameCoder.decode(reader);
        if (this._verbose) {
            BrokerCoder.log("decodeHeader: eventType=" + eventType + " cookie=" + this.hex(cookie) + " brokerWireVersion=" + this.hex(version) + " dataLength=" + dataLength + " headerLength=" + headerLength + " noOfFields=" + noOfFields);
        }
        reader.setPosition(headerLength);
        HeaderInformation headerInfo = new HeaderInformation();
        headerInfo.dataLength = dataLength;
        headerInfo.noOfFields = noOfFields;
        return headerInfo;
    }

    private IData decodeStructure(Context context, NSRecord record, int wireFormatVersion, BytePoolReader reader) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("decodeStructure: record=(" + record + ") @ " + reader.getPosition());
        }
        int len = reader.readInt();
        int count = reader.readShort();
        reader.skip(2);
        if (this._verbose) {
            BrokerCoder.log(" ** length=(" + this.hex(len) + ") noOfFields=(" + count + ")");
        }
        return this.decodeFields(context, count, record, wireFormatVersion, reader);
    }

    private IData decodeFields(Context context, int count, NSRecord record, int wireFormatVersion, BytePoolReader reader) throws BrokerCoderRuntimeException {
        if (this._verbose) {
            BrokerCoder.log("decodeFields: noOfFields=[" + count + "] record=(" + record + ") @ " + reader.getPosition());
        }
        IData data = IDataFactory.create();
        IDataCursor cursor = data.getCursor();
        BrokerField brokerField = new BrokerField();
        for (int i = 0; i < count; ++i) {
            brokerField.readHeader(reader);
            String tagFromWire = brokerField.name;
            NSField field = record != null && brokerField.name != null ? record.getFieldByName(brokerField.name) : null;
            TagInformation tagInfo = this.computeTagInformation(context, brokerField.name, brokerField.type, field, wireFormatVersion);
            if (this._verbose) {
                BrokerCoder.log(tagInfo.toString());
            }
            brokerField.readValue(context, tagInfo, field, wireFormatVersion, reader);
            if (brokerField.name == null) {
                if (this._verbose) {
                    BrokerCoder.log("Unable to locate a declaration for tag - " + tagFromWire);
                    BrokerCoder.log("Unable to decode, SORRY");
                }
                Object[] args = new Object[]{context.getSchema().getNSName().toString()};
                JournalLogger.log(33, 76, 1, args);
                throw new BrokerCoderRuntimeException(BrokerCoderRuntimeExceptionBundle.class, BrokerCoderRuntimeExceptionBundle.INVALID_DOCUMENT, "", args);
            }
            cursor.insertAfter(brokerField.name, brokerField.value);
            if (this._verbose) {
                BrokerCoder.log(" ** insert (" + brokerField.name + "=" + brokerField.value + ")");
            }
            brokerField.nextField(reader);
            if (!tagInfo.isTypeReference) continue;
            context.popType();
        }
        cursor.destroy();
        return data;
    }

    private void decodeValue(Context context, BrokerField brokerField, TagInformation tagInfo, NSField field, int wireFormatVersion, BytePoolReader reader) throws BrokerCoderRuntimeException {
        WireValueInformation valueInfo;
        if (this._verbose) {
            BrokerCoder.log("decodeValue: field=(" + field + ") brokerType=(" + this.hex(brokerField.type) + ") @ " + reader.getPosition());
        }
        if (wireFormatVersion >= 1) {
            valueInfo = this.computeValueInformation(context);
            if (this._verbose) {
                BrokerCoder.log(valueInfo.toString());
            }
            if (tagInfo.nature != 0) {
                brokerField.name = valueInfo.tag;
            }
            if (valueInfo.value != null) {
                brokerField.value = valueInfo.value;
                return;
            }
        } else {
            valueInfo = null;
        }
        brokerField.value = this.decodeValue(context, tagInfo, valueInfo, field, wireFormatVersion, reader);
    }

    private Object decodeValue(Context context, TagInformation tagInfo, NSField field, int wireFormatVersion, BytePoolReader reader) throws BrokerCoderRuntimeException {
        WireValueInformation valueInfo = null;
        if (wireFormatVersion >= 1) {
            valueInfo = this.computeValueInformation(context);
            if (this._verbose) {
                BrokerCoder.log(valueInfo.toString());
            }
        } else {
            valueInfo = null;
        }
        return this.decodeValue(context, tagInfo, valueInfo, field, wireFormatVersion, reader);
    }

    private Object decodeValue(Context context, TagInformation tagInfo, WireValueInformation valueInfo, NSField field, int wireFormatVersion, BytePoolReader reader) throws BrokerCoderRuntimeException {
        Object value = null;
        Object reference = null;
        boolean bearWithIt = false;
        if (valueInfo != null && valueInfo.nature != 0) {
            boolean skipDefaultValue = false;
            switch (valueInfo.nature) {
                case 2: {
                    skipDefaultValue = true;
                    break;
                }
                case 1: {
                    if (this._verbose) {
                        BrokerCoder.log("#### Processing multi-ref ... ####");
                    }
                    value = context.getObject(valueInfo.ref);
                    if (wireFormatVersion < 3) {
                        skipDefaultValue = true;
                    } else {
                        if (this._verbose) {
                            BrokerCoder.log("#### Walking thru a copy (grin and bear it) of multi-ref ... ####");
                        }
                        bearWithIt = true;
                        reference = value;
                    }
                    if (value != null) break;
                    JournalLogger.log(29, 76, 2, (Object)valueInfo.ref);
                    break;
                }
                case 3: {
                    if (this._verbose) {
                        BrokerCoder.log("#### Applying time zone ... ####");
                    }
                    IBrokerDateTypeCoder dateCoder = (IBrokerDateTypeCoder)tagInfo.coder;
                    value = dateCoder.decode(reader, valueInfo.sourceTimeZone);
                }
            }
            if (skipDefaultValue) {
                if (tagInfo.type == 2) {
                    int position = reader.getPosition();
                    int sequenceLength = reader.readInt();
                    reader.setPosition(position + sequenceLength);
                } else {
                    tagInfo.coder.skipDefaultValue(reader);
                }
                if (this._verbose) {
                    BrokerCoder.log("#### Skipping default value ... ####");
                }
            }
            if (!bearWithIt) {
                return value;
            }
        }
        switch (tagInfo.type) {
            case 0: {
                IBrokerSimpleTypeCoder coder = (IBrokerSimpleTypeCoder)tagInfo.coder;
                value = coder.decode(reader);
                if (!this._verbose) break;
                BrokerCoder.log("decodeValue: (simple value=" + value + ")");
                break;
            }
            case 1: {
                value = this.decodeStructure(context, (NSRecord)field, wireFormatVersion, reader);
                break;
            }
            case 2: {
                value = this.decodeArray(context, tagInfo.additionalInformation, field, wireFormatVersion, reader);
                break;
            }
        }
        if (valueInfo != null) {
            context.putSID(valueInfo.SID, value);
        }
        if (bearWithIt) {
            return reference;
        }
        return value;
    }

    private Object decodeArray(Context context, TagInformation tagInfo, NSField field, int wireFormatVersion, BytePoolReader reader) throws BrokerCoderRuntimeException {
        NSField fld = field;
        ArrayType arrayType = this.computeArrayType(reader, field);
        if (this._verbose) {
            BrokerCoder.log("decodeArray: (" + arrayType.toString() + ")");
        }
        if (tagInfo.coder == null) {
            BrokerEncodingRegistry er = BrokerEncodingRegistry.current();
            tagInfo.coder = er.getTypeCoder(arrayType.getBrokerType());
            if (tagInfo.isUnknownType && arrayType.getBrokerType() == 130) {
                tagInfo.type = 1;
                fld = null;
            }
            if (this._verbose) {
                BrokerCoder.log("#### Updated tag information (using bits from the wire) " + tagInfo.toString() + " ####");
            }
        }
        Object[] array = this.decodeArray(context, tagInfo, arrayType, 1, fld, wireFormatVersion, reader);
        return array;
    }

    private ArrayType computeArrayType(BytePoolReader reader, NSField field) {
        int arrayPosition = reader.getPosition();
        IntegerList dimensions = new IntegerList();
        int arrayType = 129;
        int arraySize = 0;
        while (arrayType == 129) {
            reader.skip(4);
            arraySize = reader.readInt();
            dimensions.addInteger(arraySize);
            reader.skip(2);
            arrayType = reader.readShort();
        }
        reader.setPosition(arrayPosition);
        if (field != null) {
            int fieldDimensions = field.getDimensions();
            while (dimensions.size() < fieldDimensions) {
                dimensions.addInteger(0);
            }
        }
        int[] dims = new int[dimensions.size()];
        dimensions.copyInto(dims);
        return new ArrayType(arrayType, dims);
    }

    private Object[] decodeArray(Context context, TagInformation tagInfo, ArrayType computedArrayType, int currentDimension, NSField field, int wireFormatVersion, BytePoolReader reader) throws BrokerCoderRuntimeException {
        int startPosition = reader.getPosition();
        int sequenceLength = reader.readInt();
        int arraySizePosition = reader.getPosition();
        int arraySize = reader.readInt();
        reader.skip(2);
        int arrayType = reader.readShort();
        if (this._verbose) {
            BrokerCoder.log("decodeArray: length=(" + this.hex(sequenceLength) + ") size=[" + this.hex(arraySize) + "] brokerType=(" + this.hex(arrayType) + ") @ " + reader.getPosition());
        }
        Object[] array = (Object[])tagInfo.coder.createArray(computedArrayType.getDimensions().length - currentDimension, arraySize);
        for (int i = 0; i < arraySize; ++i) {
            try {
                if (arrayType == 129) {
                    array[i] = this.decodeArray(context, tagInfo, computedArrayType, currentDimension + 1, field, wireFormatVersion, reader);
                    continue;
                }
                array[i] = this.decodeValue(context, tagInfo, field, wireFormatVersion, reader);
                continue;
            }
            catch (RuntimeException ex) {
                if (this._verbose) {
                    BrokerCoder.log("Postion(arraySize)=" + arraySizePosition + ", arraySize=" + arraySize + ", i=" + i + ", array.length=" + array.length);
                }
                throw ex;
            }
        }
        reader.setPosition(startPosition + sequenceLength);
        return array;
    }

    private String hex(int val) {
        return Integer.toHexString(val);
    }

    private static void printBytes(byte[] b) {
        StringBuffer lt = new StringBuffer(Strings.lpad("0", ' ', 5) + " .. ");
        StringBuffer rt = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            lt.append(" " + Strings.lpad(Integer.toHexString(b[i] & 0xFF), ' ', 3));
            rt.append(" " + BrokerCoder.printChar(b[i]));
            if ((i + 1) % 12 == 0) {
                System.out.println(Strings.rpad(lt.toString(), ' ', 65) + " .. " + rt);
                lt = new StringBuffer(Strings.lpad(Integer.toString(i + 1), ' ', 5) + " .. ");
                rt = new StringBuffer();
                continue;
            }
            if ((i + 1) % 4 != 0) continue;
            lt.append(" | ");
            rt.append(" | ");
        }
        System.out.println(Strings.rpad(lt.toString(), ' ', 65) + " .. " + rt);
    }

    private static char printChar(byte b) {
        if (b < 32 || b > 126) {
            return ' ';
        }
        return (char)b;
    }

    private static void log(String msg) {
        System.out.println("\\coder\\ > " + msg);
    }

    private static void print(IData data) {
        StringBuffer sb = new StringBuffer();
        BrokerCoder.appendReport(sb, 0, data);
        System.out.println(sb.toString());
    }

    private static void appendReport(StringBuffer sb, int indent, IData data) {
        IDataCursor cursor = data.getCursor();
        while (cursor.next()) {
            String key = cursor.getKey();
            Object value = cursor.getValue();
            if (value == null) {
                BrokerCoder.appendKey(sb, indent, key + " = null\n");
                continue;
            }
            if (value instanceof Object[]) {
                int i;
                if (value instanceof IData[]) {
                    IData[] dataArray = (IData[])value;
                    for (i = 0; i < dataArray.length; ++i) {
                        BrokerCoder.appendKey(sb, indent, key + '[' + i + ']' + '\n');
                        if (dataArray[i] != null) {
                            BrokerCoder.appendReport(sb, indent + 2, dataArray[i]);
                            continue;
                        }
                        BrokerCoder.appendKey(sb, indent, "");
                        sb.append(dataArray[i]);
                        if (i + 1 < dataArray.length) {
                            sb.append(',');
                        }
                        sb.append('\n');
                    }
                    continue;
                }
                if (value instanceof String[]) {
                    String[] stringArray = (String[])value;
                    BrokerCoder.appendKey(sb, indent, key + " = {");
                    for (i = 0; i < stringArray.length; ++i) {
                        sb.append(stringArray[i]);
                        if (i + 1 >= stringArray.length) continue;
                        sb.append(", ");
                    }
                    sb.append("}\n");
                    continue;
                }
                Object[] objectArray = (Object[])value;
                BrokerCoder.appendKey(sb, indent, key + " = *object[], size=" + objectArray.length + '\n');
                BrokerCoder.appendArray(sb, indent + 2, objectArray);
                continue;
            }
            if (value instanceof IData) {
                BrokerCoder.appendKey(sb, indent, key + " = \n");
                BrokerCoder.appendReport(sb, indent + 2, (IData)value);
                continue;
            }
            if (value instanceof String) {
                String string = (String)value;
                BrokerCoder.appendKey(sb, indent, key + " = " + string + "\n");
                continue;
            }
            BrokerCoder.appendKey(sb, indent, key + " = " + value.toString() + " (" + value.getClass() + ")\n");
        }
    }

    private static void appendKey(StringBuffer sb, int indent, String key) {
        char[] charArray = new char[indent];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = 32;
        }
        sb.append(charArray);
        sb.append(key);
    }

    private static void appendArray(StringBuffer sb, int indent, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null && array[i].getClass().isArray()) {
                try {
                    BrokerCoder.appendArray(sb, indent, (Object[])array[i]);
                }
                catch (ClassCastException cce) {
                    System.out.println(cce);
                }
                continue;
            }
            if (i == 0) {
                BrokerCoder.appendKey(sb, indent, "");
                sb.append('(');
                if (array[i] == null) {
                    sb.append("class UNKNOWN");
                } else {
                    sb.append(array[i].getClass());
                }
                sb.append(")\n");
            }
            BrokerCoder.appendKey(sb, indent, "");
            sb.append(array[i]);
            if (i + 1 < array.length) {
                sb.append(',');
            }
            sb.append('\n');
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Class=");
        sb.append(this.getClass().toString());
        sb.append(", latestSupportedWireFormatVersion=");
        sb.append(this.getLatestSupportedWireFormatVersion());
        sb.append(", wireFormatVersion=");
        sb.append(this._wireFormatVersion);
        sb.append(", useMultiReferences=");
        sb.append(this._useMultiReferences);
        sb.append(", verbose=");
        sb.append(this._verbose);
        return sb.toString();
    }

    private class BrokerField {
        public String name;
        public Object value;
        public int pos;
        public int length;
        public int type;
        public int data;

        private BrokerField() {
        }

        public boolean nameMatch(String check) {
            return check == this.name || check != null && this.name != null && check.equals(this.name);
        }

        public void readHeader(BytePoolReader reader) {
            this.pos = reader.getPosition();
            this.length = reader.readInt();
            this.type = reader.readShort();
            this.name = (String)nameCoder.decode(reader);
            this.data = reader.getPosition();
            if (this.data % 4 > 0) {
                this.data += 4 - this.data % 4;
            }
            if (BrokerCoder.this._verbose) {
                BrokerCoder.log("field @ " + this.pos + " brokerType=" + BrokerCoder.this.hex(this.type) + " length=" + BrokerCoder.this.hex(this.length) + " tag=" + this.name);
            }
        }

        public void readValue(Context context, TagInformation tagInfo, NSField field, int wireFormatVersion, BytePoolReader reader) {
            reader.setPosition(this.data);
            BrokerCoder.this.decodeValue(context, this, tagInfo, field, wireFormatVersion, reader);
        }

        public void nextField(BytePoolReader reader) {
            reader.setPosition(this.pos + this.length);
        }
    }
}

