/*
 * Decompiled with CFR 0.152.
 */
package com.wm.broker.coder;

import com.wm.broker.coder.BytePoolReader;
import java.lang.reflect.Array;

public abstract class BrokerBaseTypeCoder {
    private Object _default;
    private int _wireSize;
    protected boolean _verbose;
    private static final String[] DIMENSION_PREFIX = new String[]{"", "[L", "[[L", "[[[L", "[[[[L", "[[[[[L", "[[[[[[L", "[[[[[[[L", "[[[[[[[[L", "[[[[[[[[[L", "[[[[[[[[[[L"};

    public BrokerBaseTypeCoder(Object defaultValue, int wireSize) {
        this._default = defaultValue;
        this._wireSize = wireSize;
        this._verbose = new Boolean(System.getProperty("watt.core.brokerTypeCoder.verbose"));
    }

    public abstract String getJavaClassName();

    private Class getJavaClass(int dimensions) {
        if (dimensions < 0 || dimensions > 255) {
            throw new IllegalArgumentException();
        }
        String className = "";
        if (dimensions == 0) {
            className = this.getJavaClassName();
        } else if (dimensions < 11) {
            className = DIMENSION_PREFIX[dimensions] + this.getJavaClassName() + ';';
        } else {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dimensions; ++i) {
                sb.append('[');
            }
            sb.append('L');
            sb.append(this.getJavaClassName());
            sb.append(';');
            className = sb.toString();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return clazz;
    }

    public Object createArray(int dimensions, int length) {
        Object array = null;
        try {
            array = Array.newInstance(this.getJavaClass(dimensions), length);
        }
        catch (IllegalArgumentException iae) {
        }
        catch (NegativeArraySizeException nase) {
            // empty catch block
        }
        return array;
    }

    public Object getDefaultValue() {
        return this._default;
    }

    public void skipDefaultValue(BytePoolReader reader) {
        reader.skip(this._wireSize);
    }

    protected static void log(String msg) {
        System.out.println("\\TYPE-coder\\ > " + msg);
    }
}

