/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.repo;

import com.wm.app.repov4.IRepoDirectory;
import com.wm.app.repov4.IRepository;
import com.wm.app.repov4.RepositoryException;
import com.wm.app.repov4.RepositoryNoEntryException;
import com.wm.util.Values;
import java.util.Enumeration;

public class RepositoryContext {
    private String ctxKey = null;
    private IRepository session;
    private IRepoDirectory root;
    private IRepoDirectory ctx;
    public static final int READ = 1;
    public static final int SHARE = 2;
    public static final int EXCLUSIVE = 3;
    public static final int INDEFINITE = -1;
    public static final int DELETED = 0;

    public RepositoryContext(IRepository session, IRepoDirectory root, IRepoDirectory ctx, String ctxKey) {
        this.session = session;
        this.root = root;
        this.ctx = ctx;
        this.ctxKey = ctxKey;
    }

    String getContextKey() {
        return this.ctxKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values get(String key, int mode, int wait) throws com.wm.app.repo.RepositoryException {
        Values v = null;
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                v = (Values)this.ctx.get(key);
                this.session.commit();
            }
            catch (RepositoryNoEntryException e) {
                try {
                    this.session.commit();
                }
                catch (Exception ee) {}
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
        return v;
    }

    public Values get(String key) throws com.wm.app.repo.RepositoryException {
        return this.get(key, 1, -1);
    }

    public Values get(String key, int mode) throws com.wm.app.repo.RepositoryException {
        return this.get(key, mode, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String key, Values value) throws com.wm.app.repo.RepositoryException {
        boolean rc = false;
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                if (!this.ctx.containsKey(key)) {
                    this.ctx.insert(key, (Object)value);
                    this.session.commit();
                    rc = true;
                }
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Values value) throws com.wm.app.repo.RepositoryException {
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                this.ctx.put(key, (Object)value);
                this.session.commit();
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String key, Values value) throws com.wm.app.repo.RepositoryException {
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                this.ctx.update(key, (Object)value);
                this.session.commit();
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String key) throws com.wm.app.repo.RepositoryException {
        boolean rc = false;
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                this.ctx.delete(key);
                this.session.commit();
                rc = true;
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) throws com.wm.app.repo.RepositoryException {
        boolean rc = false;
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                rc = this.ctx.containsKey(key);
                this.session.commit();
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration keys() throws com.wm.app.repo.RepositoryException {
        RepositoryEnumerator enumvar = null;
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                enumvar = new RepositoryEnumerator(this.ctx.getAllEntryKeys());
                this.session.commit();
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
        return enumvar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() throws com.wm.app.repo.RepositoryException {
        RepositoryEnumerator enumvar = null;
        IRepoDirectory iRepoDirectory = this.ctx;
        synchronized (iRepoDirectory) {
            try {
                enumvar = new RepositoryEnumerator(this.ctx.getAllEntryElements());
                this.session.commit();
            }
            catch (RepositoryException e) {
                this.cleanup(this.session);
                throw new com.wm.app.repo.RepositoryException(e.getMessage());
            }
        }
        return enumvar;
    }

    public boolean lockEntry(String key, int mode, int wait) throws com.wm.app.repo.RepositoryException {
        return true;
    }

    public void unlockEntry(String key) throws com.wm.app.repo.RepositoryException {
    }

    public String getKey() throws com.wm.app.repo.RepositoryException {
        return this.getContextKey();
    }

    public boolean isEntryLocked(String key) throws com.wm.app.repo.RepositoryException {
        return true;
    }

    public void close() throws com.wm.app.repo.RepositoryException {
        try {
            if (this.root != null) {
                this.root.destroy();
                this.root = null;
            }
            if (this.ctx != null) {
                this.ctx.destroy();
                this.ctx = null;
            }
            if (this.session != null) {
                this.session.logoff();
                this.session = null;
            }
        }
        catch (RepositoryException e) {
            throw new com.wm.app.repo.RepositoryException(e.getMessage());
        }
    }

    public boolean lockContext() throws com.wm.app.repo.RepositoryException {
        return true;
    }

    public void unlockContext() throws com.wm.app.repo.RepositoryException {
    }

    private void cleanup(IRepository session) {
        try {
            if (session != null) {
                session.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class RepositoryEnumerator
    implements Enumeration {
        private Object[] objs;
        private int idx = 0;

        RepositoryEnumerator(Object[] objs) {
            this.objs = objs;
        }

        public boolean hasMoreElements() {
            return this.idx < this.objs.length;
        }

        public Object nextElement() {
            return this.objs[this.idx++];
        }
    }
}

