/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.repo;

import com.wm.app.repo.RepositoryContext;
import com.wm.app.repov4.IRepoDirectory;
import com.wm.app.repov4.IRepository;
import com.wm.app.repov4.RepositoryException;
import com.wm.util.RepositoryManager;
import java.util.Enumeration;

public class Repository {
    protected Repository() {
    }

    public static Repository getCurrent() throws com.wm.app.repo.RepositoryException {
        return new Repository();
    }

    public RepositoryContext getContext(String context) throws com.wm.app.repo.RepositoryException {
        IRepository session = null;
        IRepoDirectory root = null;
        IRepoDirectory ctx = null;
        try {
            session = RepositoryManager.getCurrent().getDefaultRepoLogon();
            root = session.getRootDirectory();
            ctx = root.getDirectory("SYSTEM/SERVER/" + context);
            session.commit();
            return new RepositoryContext(session, root, ctx, context);
        }
        catch (RepositoryException e) {
            this.cleanup(session, root, ctx);
            throw new com.wm.app.repo.RepositoryException(e.getMessage());
        }
    }

    public RepositoryContext createContext(String context) throws com.wm.app.repo.RepositoryException {
        IRepository session = null;
        IRepoDirectory root = null;
        IRepoDirectory ctx = null;
        try {
            session = RepositoryManager.getCurrent().getDefaultRepoLogon();
            root = session.getRootDirectory();
            ctx = root.createDirectories("SYSTEM/SERVER/" + context);
            session.commit();
            return new RepositoryContext(session, root, ctx, context);
        }
        catch (RepositoryException e) {
            this.cleanup(session, root, ctx);
            throw new com.wm.app.repo.RepositoryException(e.getMessage());
        }
    }

    public void deleteContext(String context) throws com.wm.app.repo.RepositoryException {
        IRepository session = null;
        IRepoDirectory root = null;
        IRepoDirectory ctx = null;
        try {
            session = RepositoryManager.getCurrent().getDefaultRepoLogon();
            root = session.getRootDirectory();
            ctx = root.getDirectory("SYSTEM/SERVER/");
            ctx.delete(context);
            session.commit();
        }
        catch (RepositoryException e) {
            this.cleanup(session, root, ctx);
            throw new com.wm.app.repo.RepositoryException(e.getMessage());
        }
    }

    public void deleteContext(RepositoryContext context) throws com.wm.app.repo.RepositoryException {
        this.deleteContext(context.getContextKey());
    }

    public boolean contextExists(String context) throws com.wm.app.repo.RepositoryException {
        IRepository session = null;
        IRepoDirectory root = null;
        IRepoDirectory ctx = null;
        boolean rc = false;
        try {
            session = RepositoryManager.getCurrent().getDefaultRepoLogon();
            root = session.getRootDirectory();
            rc = root.containsKey("SYSTEM/SERVER/" + context);
            session.commit();
        }
        catch (RepositoryException e) {
            this.cleanup(session, root, ctx);
            throw new com.wm.app.repo.RepositoryException(e.getMessage());
        }
        return rc;
    }

    public Enumeration keys() throws com.wm.app.repo.RepositoryException {
        IRepository session = null;
        IRepoDirectory root = null;
        IRepoDirectory ctx = null;
        RepositoryEnumerator enumvar = null;
        try {
            session = RepositoryManager.getCurrent().getDefaultRepoLogon();
            root = session.getRootDirectory();
            ctx = root.getDirectory("SYSTEM/SERVER/");
            enumvar = new RepositoryEnumerator(ctx.keys(), session);
        }
        catch (RepositoryException e) {
            this.cleanup(session, root, ctx);
            throw new com.wm.app.repo.RepositoryException(e.getMessage());
        }
        return enumvar;
    }

    private void cleanup(IRepository session, IRepoDirectory root, IRepoDirectory ctx) {
        try {
            if (root != null) {
                root.destroy();
            }
            if (ctx != null) {
                ctx.destroy();
            }
            if (session != null) {
                session.logoff();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    class RepositoryEnumerator
    implements Enumeration {
        private Enumeration enumvar;
        private IRepository session;

        RepositoryEnumerator(Enumeration enumvar, IRepository session) {
            this.enumvar = enumvar;
            this.session = session;
        }

        public boolean hasMoreElements() {
            boolean rc = false;
            try {
                rc = this.enumvar.hasMoreElements();
                if (!rc) {
                    try {
                        this.session.commit();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                this.cleanup();
            }
            return rc;
        }

        public Object nextElement() {
            Object obj = null;
            try {
                obj = this.enumvar.nextElement();
            }
            catch (Exception e) {
                this.cleanup();
            }
            return obj;
        }

        private void cleanup() {
            try {
                this.session.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

