/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.util;

import java.util.Calendar;
import java.util.Date;

public class ExpirationInterval {
    public static final String EXCP_MSG_BUNDLE = "com.wm.passman.resources.PassManExceptionBundle";
    private Date _startDate;
    private Date _endDate;
    private Date _alarmDate;
    private int _expireInterval;
    private static final int SHORT_EXPIRE_INTERVAL = 12;
    private static final int LONG_EXPIRE_INTERVAL = 60;
    private static final int MAX_ALARM_INTERVAL = 30;

    public ExpirationInterval(Date inDate) {
        this._endDate = ExpirationInterval.calculateExpirationDate(inDate, 0);
        this._startDate = inDate;
        this._alarmDate = null;
        this._expireInterval = 0;
    }

    public ExpirationInterval(Date inDate, int inInterval) {
        this._endDate = ExpirationInterval.calculateExpirationDate(inDate, inInterval);
        this._startDate = inDate;
        this._alarmDate = null;
        if (inInterval < 0) {
            throw new IllegalArgumentException("interval");
        }
        this._expireInterval = inInterval;
    }

    public ExpirationInterval(Date inStartDate, Date inEndDate) {
        this._expireInterval = ExpirationInterval.calculateExpirationInterval(inStartDate, inEndDate);
        this._startDate = inStartDate;
        this._endDate = inEndDate;
        this._alarmDate = null;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Date getAlarmDate() {
        if (this._alarmDate == null) {
            this._alarmDate = this.calculateAlarmDate();
        }
        return this._alarmDate;
    }

    public int getInterval() {
        return this._expireInterval;
    }

    public boolean isExpired(Date inDate) {
        if (inDate == null) {
            throw new NullPointerException("date");
        }
        return this._expireInterval == 0 ? false : !this._endDate.after(inDate);
    }

    public int daysTilExpiration(Date inDate) {
        int returnInt = 0;
        returnInt = this.isExpired(inDate) ? 0 : (this._expireInterval == 0 ? Integer.MAX_VALUE : ExpirationInterval.calculateExpirationInterval(inDate, this._endDate));
        return returnInt;
    }

    public boolean isAboutToExpire(Date inDate) {
        boolean returnBool = false;
        if (this.isExpired(inDate) || this._expireInterval == 0) {
            returnBool = false;
        } else if (this._expireInterval == 1) {
            returnBool = true;
        } else {
            if (this._alarmDate == null) {
                this._alarmDate = this.calculateAlarmDate();
            }
            returnBool = !this._alarmDate.after(inDate);
        }
        return returnBool;
    }

    public static Date calculateExpirationDate(Date inStart, int inInterval) {
        if (inStart == null) {
            throw new NullPointerException("date");
        }
        if (inInterval < 0) {
            inInterval = 0;
        }
        Calendar returnCal = Calendar.getInstance();
        returnCal.setTime(inStart);
        returnCal.add(6, inInterval);
        return returnCal.getTime();
    }

    public static int calculateExpirationInterval(Date inStart, Date inEnd) {
        if (inStart == null) {
            throw new NullPointerException("start date");
        }
        if (inEnd == null) {
            throw new NullPointerException("end date");
        }
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(inStart);
        ExpirationInterval.truncateToDay(tempCal);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(inEnd);
        ExpirationInterval.truncateToDay(endCal);
        int returnInt = 0;
        while (tempCal.before(endCal)) {
            tempCal.add(5, 1);
            ++returnInt;
        }
        return returnInt;
    }

    private static Date truncateToDay(Date inDate) {
        Calendar temp = Calendar.getInstance();
        temp.setTime(inDate);
        ExpirationInterval.truncateToDay(temp);
        return temp.getTime();
    }

    private static void truncateToDay(Calendar inCal) {
        inCal.set(11, 0);
        inCal.set(12, 0);
        inCal.set(13, 0);
        inCal.set(14, 0);
    }

    private Date calculateAlarmDate() {
        int alarmingInterval = this.calculateAlarmingInterval();
        Calendar tempCal = Calendar.getInstance();
        tempCal.setTime(this._startDate);
        tempCal.add(5, this._expireInterval - alarmingInterval);
        return tempCal.getTime();
    }

    private int calculateAlarmingInterval() {
        int returnInt = 0;
        if (this._expireInterval != 0) {
            returnInt = 30;
            if (this._expireInterval <= 60) {
                if (this._expireInterval > 12) {
                    returnInt = this._expireInterval / 2;
                } else {
                    int halfShort = 6;
                    returnInt = Math.min(this._expireInterval, halfShort);
                }
            }
        }
        return returnInt;
    }
}

