/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.util;

import com.wm.app.passman.PassManConfig;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigProps {
    private static final String DS_CLASS_KEY = "ds.className";
    private static final String DS_FIELD_PREFIX = "ds.field.";
    private static final String MPW_CLASS_KEY = "mpw.className";
    private static final String MPW_FIELD_PREFIX = "mpw.field.";
    private static final String DEF_ENC_CODE_KEY = "enc.defaultCode";
    private static final String SANITY_ENC_CODE_KEY = "enc.sanityCode";
    private static final String ENC_PREFIX = "enc.";
    private static final String ENC_CLASS_TAIL = "className";
    private static final String ENC_FIELD_TAIL = "field.";
    private static final int ENC_PREF_LEN = "enc.".length();
    private static final int ENC_CLASS_TAIL_LEN = "className".length();
    private static final int MIN_ENC_CLASS_LEN = ENC_PREF_LEN + ENC_CLASS_TAIL_LEN + 1;

    private ConfigProps() {
    }

    public static PassManConfig configFromPropsFile(String inFileName) throws Exception {
        Properties props = inFileName == null ? new Properties() : ConfigProps.getProps(inFileName);
        PassManConfig returnConfig = new PassManConfig();
        ConfigProps.transferDataStoreProps(props, returnConfig);
        ConfigProps.transferMasterPwProps(props, returnConfig);
        ConfigProps.transferEncryptorProps(props, returnConfig);
        return returnConfig;
    }

    private static void transferDataStoreProps(Properties inProps, PassManConfig inConfig) {
        if (inProps != null && inProps.size() > 0) {
            String className = inProps.getProperty(DS_CLASS_KEY);
            Map dsMap = ConfigProps.extractFieldMap(inProps, DS_FIELD_PREFIX);
            inConfig.setDataStore(className, dsMap);
        }
    }

    private static void transferMasterPwProps(Properties inProps, PassManConfig inConfig) {
        if (inProps != null && inProps.size() > 0) {
            String className = inProps.getProperty(MPW_CLASS_KEY);
            Map mpwMap = ConfigProps.extractFieldMap(inProps, MPW_FIELD_PREFIX);
            inConfig.setMasterPassword(className, mpwMap);
        }
    }

    private static void transferEncryptorProps(Properties inProps, PassManConfig inConfig) {
        if (inProps != null && inProps.size() > 0) {
            String defaultCode = inProps.getProperty(DEF_ENC_CODE_KEY);
            inConfig.setDefaultEncryptorCode(defaultCode);
            String sanityCode = inProps.getProperty(SANITY_ENC_CODE_KEY);
            inConfig.setSanityEncryptorCode(sanityCode);
            String[] encSubKeys = ConfigProps.extractEncryptorSubKeys(inProps);
            if (encSubKeys == null || encSubKeys.length == 0) {
                ConfigProps.addEncryptorForSubKey(inProps, inConfig, null);
            } else {
                for (int ndx = 0; ndx < encSubKeys.length; ++ndx) {
                    ConfigProps.addEncryptorForSubKey(inProps, inConfig, encSubKeys[ndx]);
                }
            }
        }
    }

    private static void addEncryptorForSubKey(Properties inProps, PassManConfig inConfig, String inSubKey) {
        String classKey = ConfigProps.createEncryptorClassKey(inSubKey);
        String nextClassName = inProps.getProperty(classKey);
        if (nextClassName != null) {
            String fieldKey = ConfigProps.createEncryptorFieldKey(inSubKey);
            Map encMap = ConfigProps.extractFieldMap(inProps, fieldKey);
            inConfig.addEncryptor(nextClassName, encMap);
        }
    }

    private static String createEncryptorClassKey(String inSubKey) {
        return inSubKey == null || inSubKey.length() == 0 ? "enc.className" : ENC_PREFIX + inSubKey + "." + ENC_CLASS_TAIL;
    }

    private static String createEncryptorFieldKey(String inSubKey) {
        return inSubKey == null || inSubKey.length() == 0 ? "enc.field." : ENC_PREFIX + inSubKey + "." + ENC_FIELD_TAIL;
    }

    private static Properties getProps(String inFileName) throws Exception {
        Properties returnProps = new Properties();
        FileInputStream fis = new FileInputStream(inFileName);
        returnProps.load(fis);
        return returnProps;
    }

    private static Map extractFieldMap(Properties inProps, String inPrefix) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String[] keys = ConfigProps.extractPropKeysByPrefix(inProps, inPrefix);
        int prefLen = inPrefix.length();
        for (int ndx = 0; ndx < keys.length; ++ndx) {
            String nextKey = keys[ndx];
            String mapKey = nextKey.substring(prefLen);
            returnMap.put(mapKey, inProps.getProperty(nextKey));
        }
        return returnMap;
    }

    private static String[] extractPropKeysByPrefix(Properties inProps, String inPrefix) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        Enumeration<?> keys = inProps.propertyNames();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            if (!nextKey.startsWith(inPrefix)) continue;
            fieldNames.add(nextKey);
        }
        return fieldNames.toArray(new String[0]);
    }

    private static String[] extractEncryptorSubKeys(Properties inProps) {
        ArrayList<String> subKeys = new ArrayList<String>();
        Enumeration<?> keys = inProps.propertyNames();
        while (keys.hasMoreElements()) {
            int keyLen;
            String nextKey = (String)keys.nextElement();
            if (!nextKey.startsWith(ENC_PREFIX) || !nextKey.endsWith(ENC_CLASS_TAIL) || (keyLen = nextKey.length()) <= MIN_ENC_CLASS_LEN) continue;
            int lastNdx = keyLen - ENC_CLASS_TAIL_LEN - 1;
            subKeys.add(nextKey.substring(ENC_PREF_LEN, lastNdx));
        }
        return subKeys.toArray(new String[0]);
    }

    public static void main(String[] inArgs) {
        PrintStream dest = System.err;
        dest.println("ConfigProps tester begins");
        String inFileName = "./config/testConfig.prop";
        dest.println("ConfigProps tester begins, using file: " + inFileName);
        try {
            PassManConfig config = ConfigProps.configFromPropsFile(inFileName);
            StringBuffer dumpBuff = new StringBuffer();
            config.dump(dumpBuff);
            dest.println(dumpBuff.toString());
        }
        catch (Exception e) {
            dest.println("oops: type(" + e.getClass().getName() + "), msg(" + e.getMessage() + ")");
            e.printStackTrace(dest);
        }
        dest.println("program ends");
    }
}

