/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;

public class LoginDlg
extends JDialog {
    protected static final String MSG_BUNDLE_NAME = "com.wm.app.passman.resources.PassManMsgBundle";
    protected static final ResourceBundle MSG_BUNDLE = ResourceBundle.getBundle("com.wm.app.passman.resources.PassManMsgBundle");
    protected static final String ID_PREFIX = "BAP.0003.";
    protected static final String DEFAULT_TITLE_MSG_ID = "BAP.0003.00017";
    protected static final String DEFAULT_MPW_PROMPT_MSG_ID = "BAP.0003.00018";
    protected static final String OK_BUTTON_TITLE_MSG_ID = "BAP.0003.00019";
    protected static final String CANCEL_BUTTON_TITLE_MSG_ID = "BAP.0003.00020";
    protected static final int PW_FIELD_LEN = 20;
    protected String ACTION_CANCEL = "action.cancel";
    protected String ACTION_LOGIN = "action.login";
    private JPasswordField passwordTextField = null;
    protected String title = null;
    protected String prompt = null;
    private boolean accepted;

    public static void requestDelayedFocus(final Component c) {
        if (c != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    c.requestFocus();
                }
            });
        }
    }

    public LoginDlg(Frame parent, boolean modal) {
        this(parent, modal, null);
    }

    public LoginDlg(Frame parent, boolean modal, String inTitle) {
        this(parent, modal, inTitle, null);
    }

    public LoginDlg(Frame parent, boolean modal, String inTitle, String inPrompt) {
        super(parent, modal);
        this.title = inTitle == null ? MSG_BUNDLE.getString(DEFAULT_TITLE_MSG_ID) : inTitle;
        this.prompt = inPrompt == null ? MSG_BUNDLE.getString(DEFAULT_MPW_PROMPT_MSG_ID) : inPrompt;
        this.initComponents();
        this.pack();
        this.centerWindow();
    }

    public boolean wasAccepted() {
        return this.accepted;
    }

    public char[] getPassword() {
        return this.passwordTextField.getPassword();
    }

    protected void centerWindow() {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Point center = new Point((int)screen.getCenterX(), (int)screen.getCenterY());
        Point newLocation = new Point(center.x - this.getWidth() / 2, center.y - this.getHeight() / 2);
        if (screen.contains(newLocation.x, newLocation.y, this.getWidth(), this.getHeight())) {
            this.setLocation(newLocation);
        }
    }

    protected void initComponents() {
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        this.setTitle(this.title);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                LoginDlg.this.close(LoginDlg.this.ACTION_CANCEL);
            }
        });
        this.getAccessibleContext().setAccessibleDescription("login dialog");
        JLabel splashLabel = new JLabel(){

            public void paint(Graphics g) {
                super.paint(g);
                Font lf = new Font("SansSerif", 1, 16);
                g.setFont(lf);
                FontMetrics metrics = this.getFontMetrics(lf);
                Rectangle2D textBounds = metrics.getStringBounds(LoginDlg.this.title, g);
                int x = this.getWidth() - 10 - (int)textBounds.getWidth();
                int y = this.getHeight() - 20 - (int)textBounds.getHeight();
                x = Math.max(0, x);
                y = Math.max(0, y);
                g.setColor(new Color(175, 175, 175));
                g.drawString(LoginDlg.this.title, x, y);
                g.setColor(new Color(12, 63, 129));
                g.drawString(LoginDlg.this.title, x - 1, y - 1);
            }
        };
        splashLabel.setIcon(new ImageIcon("resources" + File.separator + "splash.jpg"));
        splashLabel.setHorizontalAlignment(0);
        splashLabel.setHorizontalTextPosition(0);
        contents.add((Component)splashLabel, "North");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel passwordLabel = new JLabel();
        passwordLabel.setText(this.prompt);
        GridBagConstraints gbc = null;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(11, 12, 0, 0);
        panel.add((Component)passwordLabel, gbc);
        this.passwordTextField = new JPasswordField(20);
        this.passwordTextField.setEchoChar('\u2022');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(11, 7, 0, 11);
        panel.add((Component)this.passwordTextField, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton loginButton = new JButton();
        loginButton.setText(MSG_BUNDLE.getString(OK_BUTTON_TITLE_MSG_ID));
        loginButton.setActionCommand(this.ACTION_LOGIN);
        loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LoginDlg.this.close(event);
            }
        });
        buttonPanel.add(loginButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton cancelButton = new JButton();
        cancelButton.setText(MSG_BUNDLE.getString(CANCEL_BUTTON_TITLE_MSG_ID));
        cancelButton.setActionCommand(this.ACTION_CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LoginDlg.this.close(event);
            }
        });
        buttonPanel.add(cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(17, 12, 11, 11);
        panel.add((Component)buttonPanel, gbc);
        contents.add((Component)panel, "Center");
        this.getRootPane().setDefaultButton(loginButton);
        JButton[] buttons = new JButton[]{loginButton, cancelButton};
        this.equalizeButtonSizes(buttons);
        LoginDlg.requestDelayedFocus(this.passwordTextField);
    }

    protected void equalizeButtonSizes(JButton[] buttons) {
        Dimension maxSize = new Dimension(0, 0);
        FontMetrics metrics = buttons[0].getFontMetrics(buttons[0].getFont());
        Graphics gfx = this.getGraphics();
        for (int i = 0; i < buttons.length; ++i) {
            Rectangle2D textBounds = metrics.getStringBounds(buttons[i].getText(), gfx);
            maxSize.width = Math.max(maxSize.width, (int)textBounds.getWidth());
            maxSize.height = Math.max(maxSize.height, (int)textBounds.getHeight());
        }
        Insets insets = buttons[0].getBorder().getBorderInsets(buttons[0]);
        maxSize.width += insets.left + insets.right;
        maxSize.height += insets.top + insets.bottom;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPreferredSize(maxSize);
            buttons[i].setMaximumSize(maxSize);
        }
    }

    protected void close(Object actionCommand) {
        String action = null;
        action = actionCommand instanceof ActionEvent ? ((ActionEvent)actionCommand).getActionCommand() : actionCommand.toString();
        this.accepted = true;
        if (action.equals(this.ACTION_CANCEL)) {
            this.accepted = false;
        } else if (action.equals(this.ACTION_LOGIN)) {
            // empty if block
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame(){

            public Dimension getPreferredSize() {
                return new Dimension(300, 300);
            }
        };
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(false);
        LoginDlg dialog = new LoginDlg((Frame)frame, true, "Test title", "Enter");
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }

            public void windowClosed(WindowEvent event) {
                System.exit(0);
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        String msg = dialog.wasAccepted() ? "password: " + new String(dialog.getPassword()) : "cancelled, no password!";
        System.out.println(msg);
    }
}

