/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.masterpw;

import com.wm.app.passman.masterpw.BaseMasterPassword;
import com.wm.app.passman.ui.LoginDlg;
import com.wm.passman.masterpw.MasterPasswordException;
import com.wm.util.io.Console;
import com.wm.util.security.WmSecureString;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFrame;

public class LoginMasterPassword
extends BaseMasterPassword {
    protected static final String MSG_BUNDLE_NAME = "com.wm.app.passman.resources.PassManMsgBundle";
    protected static final ResourceBundle MSG_BUNDLE = ResourceBundle.getBundle("com.wm.app.passman.resources.PassManMsgBundle");
    protected static final String ID_PREFIX = "BAP.0003.";
    protected static final String DEFAULT_TITLE_MSG_ID = "BAP.0003.00017";
    protected static final String DEFAULT_MPW_PROMPT_MSG_ID = "BAP.0003.00018";
    protected static final String SHORT_MPW_PROMPT_MSG_ID = "BAP.0003.00021";
    protected static final int DEFAULT_ATTEMPTS_LIMIT = 3;
    private String DEFAULT_GUI_TITLE = MSG_BUNDLE.getString("BAP.0003.00017");
    private String DEFAULT_CONSOLE_TITLE = "\n\n" + MSG_BUNDLE.getString("BAP.0003.00018") + "\n\n";
    private String DEFAULT_PROMPT = MSG_BUNDLE.getString("BAP.0003.00021");
    private boolean _useGUI = true;
    private String _title = null;
    private String _prompt = null;

    public void setUseGUI(String useGUI) {
        this._useGUI = new Boolean(useGUI);
    }

    public void setTitle(String inTitle) {
        if (inTitle != null) {
            this._title = inTitle;
        }
    }

    public void setPrompt(String inPrompt) {
        if (inPrompt != null) {
            this._prompt = inPrompt;
        }
    }

    public void setAttemptsLimit(String inLimitStr) {
        int limit = super.parseLoginAttemptsLimit(inLimitStr, 3);
        super.setLoginAttemptsLimit(limit);
    }

    public WmSecureString retrieve(boolean inForceFlag) throws MasterPasswordException {
        if (this._mpw == null || inForceFlag) {
            this._mpw = this._useGUI ? this.masterFromGui() : this.masterFromConsole();
        }
        return new WmSecureString(this._mpw);
    }

    protected synchronized WmSecureString masterFromGui() {
        JFrame frame = new JFrame(){

            public Dimension getPreferredSize() {
                return new Dimension(200, 100);
            }
        };
        frame.pack();
        frame.setVisible(false);
        String title = this._title == null ? this.DEFAULT_GUI_TITLE : this._title;
        String prompt = this._prompt == null ? this.DEFAULT_PROMPT : this._prompt;
        LoginDlg dialog = new LoginDlg((Frame)frame, true, title, prompt);
        dialog.pack();
        dialog.toFront();
        dialog.setVisible(true);
        WmSecureString returnStr = dialog.wasAccepted() ? new WmSecureString(dialog.getPassword()) : new WmSecureString("");
        frame.dispose();
        return returnStr;
    }

    protected synchronized WmSecureString masterFromConsole() {
        WmSecureString returnStr = null;
        String title = this._title == null ? this.DEFAULT_CONSOLE_TITLE : this._title;
        String prompt = this._prompt == null ? this.DEFAULT_PROMPT : this._prompt;
        try {
            Console c = Console.get(Console.NO_ECHO);
            returnStr = c.readLine(prompt, title);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return returnStr;
    }

    public void store(WmSecureString inPw) throws MasterPasswordException {
        this._mpw = new WmSecureString(inPw);
    }

    public void reset() throws MasterPasswordException {
        this._mpw = new WmSecureString("manage");
    }

    public static void main(String[] args) {
        String prompt = "Test prompt";
        String title = "Test Title";
        LoginMasterPassword.testGui("Test prompt", "Test Title");
        LoginMasterPassword.testConsole("Test prompt", "Test Title");
        System.out.println("program ends");
        System.exit(0);
    }

    private static void testGui(String inPrompt, String inTitle) {
        LoginMasterPassword lmp = new LoginMasterPassword();
        lmp.setPrompt(inPrompt);
        lmp.setTitle(inTitle);
        lmp.setUseGUI("true");
        LoginMasterPassword.retrieveMaster(lmp, "dialog");
    }

    private static void testConsole(String inPrompt, String inTitle) {
        LoginMasterPassword lmp = new LoginMasterPassword();
        lmp.setPrompt(inPrompt);
        lmp.setTitle(inTitle);
        lmp.setUseGUI("false");
        LoginMasterPassword.retrieveMaster(lmp, "console");
    }

    private static void retrieveMaster(LoginMasterPassword inLmp, String inSource) {
        WmSecureString secPw = null;
        try {
            System.out.println("retrieve password from " + inSource);
            secPw = inLmp.retrieve();
        }
        catch (Exception e) {
            System.out.println("login master.retrieve threw this:  type(" + e.getClass().getName() + "), msg(" + e.getMessage() + ")");
        }
        System.out.println(inSource + " password: " + secPw);
    }
}

