/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.masterpw;

import com.wm.app.passman.masterpw.BaseMasterPassword;
import com.wm.app.passman.util.FileName;
import com.wm.passman.masterpw.MasterPasswordException;
import com.wm.util.io.Files;
import com.wm.util.security.WmSecureString;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;

public abstract class FileMasterPassword
extends BaseMasterPassword {
    private static final String DEFAULT_MPW_FILE = "mpw.dat";
    private static final String BACKUP_FILE_SUFFIX = ".bak";
    private static final String BAD_FILE_SUFFIX = ".bad";
    private String _fileName = "mpw.dat";

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String inFileName) {
        this._logger.log(3, 8, 6, "set file name(" + inFileName + ")", new String[]{inFileName});
        if (inFileName != null && inFileName.length() > 0) {
            this._fileName = FileName.normalize(inFileName);
        }
    }

    public WmSecureString retrieve(boolean inForceFlag) throws MasterPasswordException {
        this._logger.log(3, 9, 6, "retrieve master");
        if (this._mpw == null || inForceFlag) {
            try {
                this.loadFromFile();
            }
            catch (MasterPasswordException mpe) {
                this.retryLoadFromFile(mpe);
            }
        }
        return new WmSecureString(this._mpw);
    }

    public void store(WmSecureString inPw) throws MasterPasswordException {
        this._logger.log(3, 13, 6, "store master");
        this.validateNewMaster(inPw);
        if (this._mpw != null) {
            this.saveOldMaster(this._mpw);
        }
        this._mpw = new WmSecureString(inPw);
        this.saveToFile();
    }

    public void reset() throws MasterPasswordException {
        super.reset();
        String nowString = String.valueOf(new Date().getTime());
        String badFileName = this._fileName + BAD_FILE_SUFFIX + "." + nowString;
        this.renameCurrentFile(badFileName);
        this._mpw = new WmSecureString("manage");
        this.saveToFile();
    }

    protected Object[] loadObjects() throws MasterPasswordException {
        Object[] returnArray = null;
        String targetName = this._fileName;
        try {
            returnArray = this.loadObjects(targetName);
        }
        catch (MasterPasswordException mpe) {
            this._logger.logWarning("loadObjects(" + targetName + ")", mpe, "can't loadObjects from " + targetName);
            returnArray = null;
        }
        targetName = this._fileName + BACKUP_FILE_SUFFIX;
        if (returnArray == null) {
            try {
                returnArray = this.loadObjects(targetName);
            }
            catch (MasterPasswordException mpe) {
                this._logger.logWarning("loadObjects(" + targetName + ")", mpe, "can't loadObjects from " + targetName);
                throw mpe;
            }
        }
        return returnArray;
    }

    protected Object[] loadObjects(String inFileName) throws MasterPasswordException {
        this._logger.log(3, 11, 6, "enter loadObjects, file: " + inFileName, new String[]{inFileName});
        File mpwFile = new File(inFileName);
        if (!mpwFile.exists() || mpwFile.length() == 0L) {
            throw new MasterPasswordException("BAP.0104.00007", "com.wm.app.passman.resources.PassManExceptionBundle", new String[]{inFileName}, "null/empty file: " + inFileName);
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        ArrayList<Object> returnList = new ArrayList<Object>();
        try {
            fis = new FileInputStream(mpwFile);
            ois = new ObjectInputStream(fis);
            while (true) {
                Object nextObj = ois.readObject();
                returnList.add(nextObj);
            }
        }
        catch (EOFException ee) {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e2) {
                this._logger.logWarning("ois/fis.close()", e2, "can't close input stream");
            }
        }
        catch (Exception e) {
            try {
                throw new MasterPasswordException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e2) {
                    this._logger.logWarning("ois/fis.close()", e2, "can't close input stream");
                }
                throw throwable;
            }
        }
        return returnList.toArray(new Object[0]);
    }

    protected void saveObjects(Object[] inArray) throws MasterPasswordException {
        File passFile = new File(this._fileName);
        this.saveBackup(passFile);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(passFile);
            oos = new ObjectOutputStream(fos);
            for (int ndx = 0; ndx < inArray.length; ++ndx) {
                oos.writeObject(inArray[ndx]);
            }
        }
        catch (Exception e) {
            throw new MasterPasswordException(e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                this._logger.logWarning("oos/fos.close()", e, "can't close output stream");
            }
        }
        this.removeBackup(this._fileName);
    }

    protected void retryLoadFromFile(MasterPasswordException inExcept) throws MasterPasswordException {
        throw inExcept;
    }

    protected abstract void loadFromFile() throws MasterPasswordException;

    protected abstract void saveToFile() throws MasterPasswordException;

    private void saveBackup(File inFile) throws MasterPasswordException {
        try {
            Files.backup(inFile);
        }
        catch (IOException ioe) {
            throw new MasterPasswordException(ioe);
        }
    }

    private boolean renameCurrentFile(String inFileName) {
        boolean renameStatus = false;
        if (inFileName != null) {
            File srcFile = new File(this._fileName);
            File destFile = new File(inFileName);
            if (srcFile.exists() && !srcFile.equals(destFile)) {
                renameStatus = srcFile.renameTo(destFile);
            }
        }
        return renameStatus;
    }

    private void removeBackup(String inFileName) throws MasterPasswordException {
        String bakFileName = inFileName + BACKUP_FILE_SUFFIX;
        File bakFile = new File(bakFileName);
        bakFile.delete();
    }
}

