/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.masterpw;

import com.wm.app.passman.encryption.EntrustEncryptor;
import com.wm.app.passman.masterpw.FileMasterPassword;
import com.wm.passman.masterpw.MasterPasswordException;
import com.wm.util.security.Bytes;
import com.wm.util.security.WmSecureString;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class EntrustMasterPassword
extends FileMasterPassword {
    private static final String DEFAULT_MPW_FILE = "empwd.dat";
    private static final int DEFAULT_REPETITION_COUNT = 4;
    private EntrustEncryptor _encryptor = new EntrustEncryptor();
    private byte[] _salt = this._encryptor.getSalt();
    private WmSecureString _password = null;

    public void setRepeatLimit(String count) {
        int ct = this.parseRepetitionCount(count, 4);
        super.setRepetitionCount(ct);
    }

    protected void retryLoadFromFile(MasterPasswordException inExcept) throws MasterPasswordException {
        this._logger.log(3, 14, 6, "retry load");
        this._mpw = new WmSecureString("manage");
        this.saveToFile();
        this.loadFromFile();
    }

    protected void loadFromFile() throws MasterPasswordException {
        this._logger.log(3, 15, 6, "enter loadFromFile()");
        Object[] contents = null;
        try {
            contents = this.loadObjects();
        }
        catch (Exception e) {
            throw new MasterPasswordException(e);
        }
        byte[] indices = (byte[])contents[0];
        byte[] byValue = Bytes.indicesToValues(indices);
        int encPwIdx = byValue[0] + 1;
        byte[][] encPw = (byte[][])contents[encPwIdx];
        int saltAlgsIdx = byValue[1] + 1;
        int[][] saltAlgs = (int[][])contents[saltAlgsIdx];
        int obscSaltIdx = byValue[2] + 1;
        byte[] obscSalt = (byte[])contents[obscSaltIdx];
        int pwdAlgsIdx = byValue[3] + 1;
        int[][] pwdAlgs = (int[][])contents[pwdAlgsIdx];
        int obscPwdIdx = byValue[4] + 1;
        byte[] obscPwd = (byte[])contents[obscPwdIdx];
        this._salt = this.unobscure(obscSalt, saltAlgs);
        this._encryptor.setSalt(this._salt);
        byte[] pwd = this.unobscure(obscPwd, pwdAlgs);
        try {
            this._password = new WmSecureString(pwd, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        this.decryptPasswords(encPw, this._encryptor, this._password);
    }

    protected void saveToFile() throws MasterPasswordException {
        byte[][] encPw = this.encryptPasswords(this._encryptor, this.getPassword());
        byte[] indices = new byte[]{0, 1, 2, 3, 4};
        indices = this.obscure(indices, this.createAlgorithms(1000));
        int[][] saltAlgs = this.createAlgorithms(this._salt.length);
        byte[] obscSalt = this.obscure(this._salt, saltAlgs);
        byte[] pwd = null;
        try {
            pwd = this.getPassword().toByteArray("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        int[][] pwdAlgs = this.createAlgorithms(pwd.length);
        byte[] obscPwd = this.obscure(pwd, pwdAlgs);
        Object[] contents = new Object[]{encPw, saltAlgs, obscSalt, pwdAlgs, obscPwd};
        Object[] objectsToSave = new Object[indices.length + 1];
        objectsToSave[0] = indices;
        for (int i = 0; i < indices.length; ++i) {
            objectsToSave[i + 1] = contents[indices[i]];
        }
        try {
            this.saveObjects(objectsToSave);
        }
        catch (Exception e) {
            throw new MasterPasswordException(e);
        }
    }

    protected WmSecureString getPassword() {
        if (this._password == null) {
            Random random = new Random();
            byte[] bytes = new byte[32];
            random.nextBytes(bytes);
            try {
                this._password = new WmSecureString(bytes, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this._password;
    }

    protected int[][] createAlgorithms(int maxSize) {
        return Bytes.createAlgorithms(maxSize, 10000);
    }

    protected byte[] obscure(byte[] s, int[][] algorithms) {
        return Bytes.applyAlgorithms(s, algorithms, false);
    }

    protected byte[] unobscure(byte[] s, int[][] algorithms) {
        return Bytes.applyAlgorithms(s, algorithms, true);
    }
}

