/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.masterpw;

import java.io.PrintStream;

public class EncryptionHelper {
    private EncryptionHelper() {
    }

    public static byte[] getSeed(byte[] inSeed, int inId, int inSize) {
        byte[] returnArray = null;
        if (inSeed == null || inSeed.length == 0) {
            return EncryptionHelper.noSeed(inSize);
        }
        if (inSeed.length == 1) {
            return EncryptionHelper.singleSeed(inSeed[0], inSize);
        }
        switch (inId) {
            case 1: {
                returnArray = EncryptionHelper.algorithm1(inSeed, inSize);
                break;
            }
            case 2: {
                returnArray = EncryptionHelper.algorithm2(inSeed, inSize);
                break;
            }
            case 3: {
                returnArray = EncryptionHelper.algorithm3(inSeed, inSize);
                break;
            }
            case 4: {
                returnArray = EncryptionHelper.algorithm4(inSeed, inSize);
                break;
            }
            case 5: {
                returnArray = EncryptionHelper.algorithm5(inSeed, inSize);
                break;
            }
            default: {
                returnArray = EncryptionHelper.algorithm0(inSeed, inSize);
            }
        }
        return returnArray;
    }

    private static byte[] noSeed(int inSize) {
        byte[] returnArray = new byte[inSize];
        for (int ndx = 0; ndx < inSize; ++ndx) {
            returnArray[ndx] = (byte)ndx;
        }
        return returnArray;
    }

    private static byte[] singleSeed(byte inByte, int inSize) {
        byte[] returnArray = new byte[inSize];
        for (int ndx = 0; ndx < inSize; ++ndx) {
            returnArray[ndx] = inByte;
        }
        return returnArray;
    }

    private static byte[] algorithm0(byte[] inSeed, int inSize) {
        byte[] returnArray = new byte[inSize];
        int outNdx = 0;
        while (outNdx < inSize) {
            for (int inNdx = 0; inNdx < inSeed.length && outNdx < inSize; ++inNdx, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
        }
        return returnArray;
    }

    private static byte[] algorithm1(byte[] inSeed, int inSize) {
        byte[] returnArray = new byte[inSize];
        int outNdx = 0;
        while (outNdx < inSize) {
            for (int inNdx = inSeed.length - 1; inNdx >= 0 && outNdx < inSize; --inNdx, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
        }
        return returnArray;
    }

    private static byte[] algorithm2(byte[] inSeed, int inSize) {
        byte[] returnArray = new byte[inSize];
        int outNdx = 0;
        while (outNdx < inSize) {
            int inNdx;
            for (inNdx = 0; inNdx < inSeed.length && outNdx < inSize; inNdx += 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
            for (inNdx = 1; inNdx < inSeed.length && outNdx < inSize; inNdx += 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
        }
        return returnArray;
    }

    private static byte[] algorithm3(byte[] inSeed, int inSize) {
        byte[] returnArray = new byte[inSize];
        int lastEvenNdx = 0;
        int lastOddNdx = 1;
        if (inSeed.length % 2 == 0) {
            lastEvenNdx = inSeed.length - 2;
            lastOddNdx = inSeed.length - 1;
        } else {
            lastEvenNdx = inSeed.length - 1;
            lastOddNdx = inSeed.length - 2;
        }
        int outNdx = 0;
        while (outNdx < inSize) {
            int inNdx;
            for (inNdx = lastEvenNdx; inNdx >= 0 && outNdx < inSize; inNdx -= 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
            for (inNdx = lastOddNdx; inNdx >= 0 && outNdx < inSize; inNdx -= 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
        }
        return returnArray;
    }

    private static byte[] algorithm4(byte[] inSeed, int inSize) {
        byte[] returnArray = new byte[inSize];
        int outNdx = 0;
        while (outNdx < inSize) {
            int inNdx;
            for (inNdx = 1; inNdx < inSeed.length && outNdx < inSize; inNdx += 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
            for (inNdx = 0; inNdx < inSeed.length && outNdx < inSize; inNdx += 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
        }
        return returnArray;
    }

    private static byte[] algorithm5(byte[] inSeed, int inSize) {
        byte[] returnArray = new byte[inSize];
        int lastEvenNdx = 0;
        int lastOddNdx = 1;
        if (inSeed.length % 2 == 0) {
            lastEvenNdx = inSeed.length - 2;
            lastOddNdx = inSeed.length - 1;
        } else {
            lastEvenNdx = inSeed.length - 1;
            lastOddNdx = inSeed.length - 2;
        }
        int outNdx = 0;
        while (outNdx < inSize) {
            int inNdx;
            for (inNdx = lastOddNdx; inNdx >= 0 && outNdx < inSize; inNdx -= 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
            for (inNdx = lastEvenNdx; inNdx >= 0 && outNdx < inSize; inNdx -= 2, ++outNdx) {
                returnArray[outNdx] = inSeed[inNdx];
            }
        }
        return returnArray;
    }

    public static void main(String[] inArgs) {
        PrintStream msgDest = System.err;
        msgDest.println("EncryptionHelper test begins");
        byte[] nullSource = null;
        byte[] emptySource = new byte[]{};
        byte[] shortSource = new byte[]{65};
        byte[] realSource = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88};
        EncryptionHelper.testOne("null", 0, 4, nullSource, msgDest);
        EncryptionHelper.testOne("empty", 2, 8, emptySource, msgDest);
        EncryptionHelper.testOne("short", 4, 16, shortSource, msgDest);
        EncryptionHelper.testOne("real", 0, 36, realSource, msgDest);
        EncryptionHelper.testOne("real", 1, 36, realSource, msgDest);
        EncryptionHelper.testOne("real", 2, 36, realSource, msgDest);
        EncryptionHelper.testOne("real", 3, 36, realSource, msgDest);
        EncryptionHelper.testOne("real", 4, 36, realSource, msgDest);
        EncryptionHelper.testOne("real", 5, 36, realSource, msgDest);
        EncryptionHelper.testOne("real", 2, 16, realSource, msgDest);
        msgDest.println("program ends");
    }

    private static void testOne(String inSourceTitle, int inId, int inSize, byte[] inSource, PrintStream inMsgDest) {
        byte[] result = EncryptionHelper.getSeed(inSource, inId, inSize);
        EncryptionHelper.dumpSourceAndResult(inSourceTitle, inId, inSize, inSource, result, inMsgDest);
    }

    private static void dumpSourceAndResult(String inSourceTitle, int inId, int inSize, byte[] inSource, byte[] inResult, PrintStream inMsgDest) {
        inMsgDest.println("source: " + inSourceTitle + ", id: " + inId + ", size: " + inSize);
        if (inSource == null) {
            inMsgDest.println("...source: NULL!");
        } else if (inSource.length == 0) {
            inMsgDest.println("...source: EMPTY!");
        } else {
            inMsgDest.println("...source: " + new String(inSource));
        }
        if (inResult == null) {
            inMsgDest.println("...result: NULL!");
        } else if (inResult.length == 0) {
            inMsgDest.println("...result: EMPTY!");
        } else {
            inMsgDest.println("...result (" + new String(inResult) + ")");
        }
    }
}

