/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.masterpw;

import com.wm.app.passman.encryption.DefaultEncryptor;
import com.wm.app.passman.masterpw.FileMasterPassword;
import com.wm.passman.encryption.Encryptor;
import com.wm.passman.masterpw.MasterPasswordException;
import com.wm.util.security.WmSecureString;

public class DefaultMasterPassword
extends FileMasterPassword {
    private static final String DEFAULT_MPW_FILE = "defaultMpw.dat";
    private static final int DEFAULT_REPETITION_COUNT = 4;
    private Encryptor _encryptor = new DefaultEncryptor();

    public void setRepeatLimit(String inCountStr) {
        int count = super.parseRepetitionCount(inCountStr, 4);
        super.setRepetitionCount(count);
    }

    protected void retryLoadFromFile(MasterPasswordException inExcept) throws MasterPasswordException {
        this._logger.log(3, 14, 6, "retry load");
        this._mpw = new WmSecureString("manage");
        this.saveToFile();
        this.loadFromFile();
    }

    protected void loadFromFile() throws MasterPasswordException {
        this._logger.log(3, 15, 6, "enter loadFromFile()");
        Object[] fileContents = null;
        try {
            fileContents = this.loadObjects();
        }
        catch (Exception e) {
            throw new MasterPasswordException(e);
        }
        this.decryptPasswords((byte[][])fileContents[0], this._encryptor, null);
    }

    protected void saveToFile() throws MasterPasswordException {
        byte[][] encPw = this.encryptPasswords(this._encryptor, null);
        try {
            this.saveObjects(new Object[]{encPw});
        }
        catch (Exception e) {
            throw new MasterPasswordException(e);
        }
    }
}

