/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.masterpw;

import com.wm.app.passman.util.JavaLogger;
import com.wm.passman.encryption.EncryptionException;
import com.wm.passman.encryption.Encryptor;
import com.wm.passman.masterpw.MasterPassword;
import com.wm.passman.masterpw.MasterPasswordException;
import com.wm.passman.masterpw.PasswordValidationException;
import com.wm.passman.util.Logger;
import com.wm.util.security.WmSecureString;

public abstract class BaseMasterPassword
implements MasterPassword {
    protected static final String EXCP_MSG_BUNDLE = "com.wm.app.passman.resources.PassManExceptionBundle";
    protected static final int MAJOR_MSG_CODE = 3;
    private static final int DEFAULT_NO_REPEAT_COUNT = 1;
    private static final int DEFAULT_ATTEMPTS_LIMIT = 1;
    private int _oldPwCount = 0;
    private int _maxAttempts = 1;
    protected WmSecureString _mpw;
    protected WmSecureString[] _prevMpws;
    protected Logger _logger = new JavaLogger();

    protected BaseMasterPassword() {
        this(1, 1);
    }

    protected BaseMasterPassword(int inRepeatLimit, int inAttemptsLimit) {
        this._oldPwCount = inRepeatLimit <= 0 ? 0 : inRepeatLimit;
        this._maxAttempts = inAttemptsLimit < 0 ? 1 : inAttemptsLimit;
        this._mpw = null;
        this._prevMpws = new WmSecureString[0];
    }

    public void setLogger(Logger inLogger) {
        if (inLogger != null) {
            this._logger = inLogger;
        }
    }

    public WmSecureString retrieve() throws MasterPasswordException {
        return this.retrieve(false);
    }

    public abstract WmSecureString retrieve(boolean var1) throws MasterPasswordException;

    public abstract void store(WmSecureString var1) throws MasterPasswordException;

    public void reset() throws MasterPasswordException {
        this._prevMpws = new WmSecureString[0];
    }

    public int getRepetitionCount() {
        return this._oldPwCount + 1;
    }

    protected void setRepetitionCount(int inCount) {
        this._logger.log(3, 1, 6, "set repetition count(" + inCount + ")", new String[]{String.valueOf(inCount)});
        this._oldPwCount = Math.max(inCount - 1, 0);
    }

    public int getLoginAttemptsLimit() {
        return this._maxAttempts;
    }

    protected void setLoginAttemptsLimit(int inCount) {
        this._logger.log(3, 22, 6, "set login attempts limit(" + inCount + ")", new String[]{String.valueOf(inCount)});
        this._maxAttempts = Math.max(inCount, 0);
    }

    protected int getMaxPreviousMasters() {
        return this._oldPwCount;
    }

    protected int parseRepetitionCount(String inCountStr) {
        return this.parseRepetitionCount(inCountStr, 1);
    }

    protected int parseRepetitionCount(String inCountStr, int inDefault) {
        this._logger.log(3, 16, 6, "parse repetition count(" + inCountStr + ")", new String[]{inCountStr});
        int parsedCount = inDefault;
        try {
            parsedCount = Integer.parseInt(inCountStr);
        }
        catch (NumberFormatException nfe) {
            this._logger.log(3, 12, 2, "bad repetition count: " + inCountStr, new String[]{inCountStr});
            parsedCount = inDefault;
        }
        return parsedCount;
    }

    protected int parseLoginAttemptsLimit(String inCountStr) {
        return this.parseLoginAttemptsLimit(inCountStr, 1);
    }

    protected int parseLoginAttemptsLimit(String inCountStr, int inDefault) {
        this._logger.log(3, 23, 6, "parse attempts limit(" + inCountStr + ")", new String[]{inCountStr});
        int parsedCount = inDefault;
        try {
            parsedCount = Integer.parseInt(inCountStr);
        }
        catch (NumberFormatException nfe) {
            this._logger.log(3, 24, 2, "bad attempts limit: " + inCountStr, new String[]{inCountStr});
            parsedCount = inDefault;
        }
        return parsedCount;
    }

    public boolean validateNewMaster(WmSecureString inPw) throws PasswordValidationException, MasterPasswordException {
        this._logger.log(3, 2, 6, "validating new master password");
        boolean rc = true;
        if (inPw == null || inPw.length() == 0) {
            throw new PasswordValidationException("BAP.0104.00001", EXCP_MSG_BUNDLE, new String[0], "null/empty new master");
        }
        if (this._mpw == null) {
            this._mpw = this.retrieve();
        }
        if (this._mpw == null || this._mpw.length() == 0) {
            this._logger.log(3, 7, 3, "master password not previously set");
            rc = false;
        } else if (inPw.equals(this._mpw)) {
            throw new PasswordValidationException("BAP.0104.00002", EXCP_MSG_BUNDLE, new String[0], "same as current master");
        }
        if (rc && this.getMaxPreviousMasters() > 0) {
            rc = this.validateAgainstPreviousMasters(inPw);
        }
        this._logger.log(3, 3, 6, "end new master password validation");
        return rc;
    }

    private boolean validateAgainstPreviousMasters(WmSecureString inPw) throws PasswordValidationException, MasterPasswordException {
        boolean rc = true;
        if (this._prevMpws != null && inPw.length() > 0) {
            for (int ndx = 0; ndx < this._prevMpws.length; ++ndx) {
                if (!this._prevMpws[ndx].equals(inPw)) continue;
                throw new PasswordValidationException("BAP.0104.00003", EXCP_MSG_BUNDLE, new String[0], "same as previous master");
            }
        }
        return rc;
    }

    protected void saveOldMaster(WmSecureString inPw) {
        this._logger.log(3, 4, 6, "saving old master");
        if (this._prevMpws == null || this._prevMpws.length == 0) {
            this._prevMpws = new WmSecureString[1];
        } else if (this._prevMpws.length == this.getMaxPreviousMasters()) {
            System.arraycopy(this._prevMpws, 0, this._prevMpws, 1, this._prevMpws.length - 1);
        } else {
            WmSecureString[] temp = new WmSecureString[this._prevMpws.length + 1];
            System.arraycopy(this._prevMpws, 0, temp, 1, this._prevMpws.length);
            this._prevMpws = temp;
        }
        this._prevMpws[0] = inPw;
    }

    protected byte[][] encryptPasswords(Encryptor inEncryptor, WmSecureString inKey) {
        this._logger.log(3, 5, 6, "encrypting passwords");
        int pwCount = this._prevMpws == null ? 1 : this._prevMpws.length + 1;
        byte[][] returnArray = new byte[pwCount][];
        returnArray[0] = this.encryptMaster(this._mpw, inEncryptor, inKey);
        for (int ndx = 1; ndx < returnArray.length; ++ndx) {
            returnArray[ndx] = this.encryptMaster(this._prevMpws[ndx - 1], inEncryptor, inKey);
        }
        return returnArray;
    }

    protected void decryptPasswords(byte[][] inArray, Encryptor inEncryptor, WmSecureString inKey) throws MasterPasswordException {
        this._logger.log(3, 6, 6, "decrypting passwords");
        if (inArray == null || inArray.length < 1) {
            throw new PasswordValidationException("BAP.0104.00009", EXCP_MSG_BUNDLE, new String[0], "no masters to decrypt");
        }
        this._mpw = this.decryptMaster(inArray[0], inEncryptor, inKey);
        int prevMpwCount = Math.min(inArray.length - 1, this.getMaxPreviousMasters());
        this._prevMpws = new WmSecureString[prevMpwCount];
        for (int ndx = 0; ndx < this._prevMpws.length; ++ndx) {
            this._prevMpws[ndx] = this.decryptMaster(inArray[ndx + 1], inEncryptor, inKey);
        }
    }

    private byte[] encryptMaster(WmSecureString inBuff, Encryptor inEncryptor, WmSecureString inKey) {
        byte[] returnBytes = null;
        try {
            returnBytes = inEncryptor.encrypt(inBuff, inKey);
        }
        catch (EncryptionException e) {
            this._logger.logWarning("BaseMasterPassword.encryptMaster", e, "error encrypting: " + e.toString());
            returnBytes = null;
        }
        return returnBytes;
    }

    private WmSecureString decryptMaster(byte[] inBytes, Encryptor inEncryptor, WmSecureString inKey) {
        WmSecureString returnStr = null;
        try {
            returnStr = inEncryptor.decrypt(inBytes, inKey);
        }
        catch (EncryptionException e) {
            this._logger.logWarning("BaseMasterPassword.decryptMaster", e, "error decrypting: " + e.toString());
            returnStr = null;
        }
        return returnStr;
    }
}

