/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.encryption;

import com.wm.app.passman.encryption.BaseEncryptor;
import com.wm.passman.encryption.EncryptionException;
import com.wm.util.security.WmSecureString;
import iaik.security.cipher.PBEKeyBMP;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.PBEParameterSpec;

public class EntrustEncryptor
extends BaseEncryptor {
    private final String CIPHER = "PbeWithSHAAnd3_KeyTripleDES_CBC";
    private final String ENC_CODE = "EntrustPbePlus";
    private PBEParameterSpec _pbeParamSpec;
    private byte[] _salt;

    public EntrustEncryptor() {
        this(null);
    }

    public EntrustEncryptor(byte[] salt) {
        this._salt = salt;
        try {
            this.setCode("EntrustPbePlus");
        }
        catch (EncryptionException ee) {
            this._logger.log(4, 1, 1, "error setting enc code(EntrustPbePlus)", new String[]{"EntrustPbePlus"});
        }
    }

    public byte[] getSalt() {
        if (this._salt == null) {
            Random random = new Random();
            byte[] newSalt = new byte[16];
            random.nextBytes(newSalt);
            this.setSalt(newSalt);
        }
        return this._salt;
    }

    public void setSalt(byte[] salt) {
        this._salt = salt;
        this._pbeParamSpec = null;
    }

    public void setSalt(String salt) {
        this.setSalt(salt.getBytes());
    }

    public byte[] encrypt(WmSecureString str, WmSecureString password) throws EncryptionException {
        if (str == null) {
            throw new EncryptionException("BAP.0105.00003", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "null encryption target");
        }
        if (password == null) {
            throw new EncryptionException("BAP.0105.00002", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "null encryption key");
        }
        return this.convert(1, str.toByteArray(), password, "error encrypting");
    }

    public WmSecureString decrypt(byte[] data, WmSecureString password) throws EncryptionException {
        if (password == null) {
            throw new EncryptionException("BAP.0105.00004", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "null decryption key");
        }
        byte[] returnBytes = data == null || data.length == 0 ? new byte[]{} : this.convert(2, data, password, "error decrypting");
        return new WmSecureString(returnBytes);
    }

    protected Cipher getCipher(int mode, String password) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("PbeWithSHAAnd3_KeyTripleDES_CBC", "Entrust");
        PBEKeyBMP pbeKey = new PBEKeyBMP(password);
        if (this._pbeParamSpec == null) {
            boolean iterations = true;
            this._pbeParamSpec = new PBEParameterSpec(this.getSalt(), 1);
        }
        cipher.init(mode, (Key)pbeKey, this._pbeParamSpec);
        return cipher;
    }

    protected byte[] convert(int mode, byte[] data, WmSecureString password, String errorMsg) throws EncryptionException {
        try {
            Cipher cipher = this.getCipher(mode, password.toString());
            byte[] converted = cipher.doFinal(data);
            return converted;
        }
        catch (Exception e) {
            this._logger.logError("EntrustEncryptor#convert(" + mode + ", data, password, " + errorMsg + ")", e, e.getMessage());
            throw new EncryptionException(e);
        }
    }

    private final void dumpSalt(StringBuffer inBuff) {
        if (this._salt == null) {
            inBuff.append("...null salt!\n");
        } else {
            inBuff.append("...salt bytes: ");
            for (int ndx = 0; ndx < this._salt.length; ++ndx) {
                if (ndx > 0) {
                    inBuff.append(",");
                }
                inBuff.append(this._salt[ndx]);
            }
            inBuff.append("\n");
        }
    }
}

