/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.encryption;

import com.wm.app.passman.encryption.BaseEncryptor;
import com.wm.passman.encryption.EncryptionException;
import com.wm.util.codec.Base64;
import com.wm.util.security.WmSecureString;
import java.io.UnsupportedEncodingException;

public class DefaultEncryptor
extends BaseEncryptor {
    private static final String DEFAULT_ENC_CODE = "Base64";

    public DefaultEncryptor() {
        try {
            this.setCode(DEFAULT_ENC_CODE);
        }
        catch (EncryptionException ee) {
            this._logger.log(4, 1, 1, "serious problem with enc code(Base64)", new String[]{DEFAULT_ENC_CODE});
        }
    }

    public byte[] encrypt(WmSecureString inBuff, WmSecureString inMaster) throws EncryptionException {
        if (inBuff == null) {
            throw new NullPointerException("encrypt(null,master)");
        }
        byte[] returnArray = null;
        try {
            returnArray = Base64.encode(inBuff.toByteArray("UTF-16BE"));
        }
        catch (UnsupportedEncodingException uee) {
            this._logger.logError("secBuff.toByteArray(UTF-16BE)", uee, "can't encode with UTF-16BE");
            throw new EncryptionException(uee);
        }
        return returnArray;
    }

    public WmSecureString decrypt(byte[] inArray, WmSecureString inMaster) throws EncryptionException {
        WmSecureString returnBuff = null;
        if (inArray == null || inArray.length == 0) {
            returnBuff = new WmSecureString("");
        } else {
            try {
                returnBuff = new WmSecureString(Base64.decode(inArray), "UTF-16BE");
            }
            catch (UnsupportedEncodingException uee) {
                this._logger.logError("new WmSecureString(..., UTF-16BE)", uee, "can't make a String using UTF-16BE");
                throw new EncryptionException(uee);
            }
        }
        return returnBuff;
    }
}

