/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.encryption;

import com.wm.app.passman.util.JavaLogger;
import com.wm.passman.encryption.EncryptionException;
import com.wm.passman.encryption.Encryptor;
import com.wm.passman.util.Logger;
import com.wm.util.security.WmSecureString;

public abstract class BaseEncryptor
implements Encryptor {
    public static final String EXCP_MSG_BUNDLE = "com.wm.app.passman.resources.PassManExceptionBundle";
    public static final int MAJOR_MSG_CODE = 4;
    protected static final String ENCODING = "UTF-16BE";
    private String _encCode;
    protected Logger _logger = new JavaLogger();

    public void setLogger(Logger inLogger) {
        if (inLogger != null) {
            this._logger = inLogger;
        }
    }

    public String getCode() {
        return this._encCode;
    }

    protected void setCode(String inCode) throws EncryptionException {
        if (inCode == null || inCode.length() == 0) {
            throw new EncryptionException("BAP.0105.00001", EXCP_MSG_BUNDLE, new String[]{inCode}, "unknown encryption code: " + inCode);
        }
        this._encCode = inCode;
    }

    public abstract byte[] encrypt(WmSecureString var1, WmSecureString var2) throws EncryptionException;

    public abstract WmSecureString decrypt(byte[] var1, WmSecureString var2) throws EncryptionException;
}

