/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.datastore;

import com.wm.app.passman.datastore.IDataStore;
import com.wm.app.passman.util.PassmanBasicData;
import com.wm.data.DataCursorEmulator;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataSharedCursor;
import com.wm.passman.datastore.DataStorageException;
import com.wm.passman.datastore.DataStoreTransactionException;
import com.wm.txn.ITransaction;
import com.wm.txn.TransactionException;
import com.wm.util.data.TxnData;

public class TxnDataStore
extends IDataStore {
    private IData _data;
    private ITransaction _txn;
    private IDataSharedCursor _cursor;

    public void beginTransaction() throws DataStoreTransactionException, DataStorageException {
        if (this.inTransaction()) {
            throw new DataStoreTransactionException("BAP.0103.00012", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "transaction in progress");
        }
        try {
            this._cursor = this.fetchData().getSharedCursor();
            this._txn = this._cursor.startTXN();
        }
        catch (TransactionException te) {
            throw new DataStoreTransactionException(te);
        }
    }

    public void commitTransaction() throws DataStoreTransactionException, DataStorageException {
        if (this.inTransaction()) {
            try {
                this._txn.commitTXN();
            }
            catch (TransactionException te) {
                throw new DataStoreTransactionException(te);
            }
        } else {
            throw new DataStoreTransactionException("BAP.0103.00013", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "can't commit, transaction not in progress");
        }
        this._cursor.destroy();
        this._txn = null;
        this.saveToFile(this.fromTData());
    }

    public void rollbackTransaction() throws DataStoreTransactionException, DataStorageException {
        if (this.inTransaction()) {
            try {
                this._txn.abortTXN();
            }
            catch (TransactionException te) {
                throw new DataStoreTransactionException(te);
            }
        } else {
            throw new DataStoreTransactionException("BAP.0103.00013", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "can't rollback, transaction not in progress");
        }
        this._cursor.destroy();
        this._txn = null;
    }

    public void store(final String handle, final IDataPortable obj) throws DataStorageException {
        this._logger.log(2, 2, 6, "store handle(" + handle + ")", new String[]{handle});
        this.runTransaction(new Transaction(){

            public Object run(IDataCursor cursor) {
                TxnDataStore.this.store(cursor, handle, obj);
                return null;
            }
        }, true);
    }

    public synchronized Object remove(final String handle) throws DataStorageException {
        this._logger.log(2, 3, 6, "remove handle(" + handle + ")", new String[]{handle});
        return this.runTransaction(new Transaction(){

            public Object run(IDataCursor cursor) {
                return TxnDataStore.this.delete(cursor, handle);
            }
        }, true);
    }

    public synchronized Object retrieve(final String handle) throws DataStorageException {
        this._logger.log(2, 1, 6, "retrieve handle(" + handle + ")", new String[]{handle});
        return this.runTransaction(new Transaction(){

            public Object run(IDataCursor cursor) {
                return TxnDataStore.this.get(cursor, handle);
            }
        }, false);
    }

    public String[] listHandles() throws DataStorageException {
        this._logger.log(2, 3, 6, "enter listHandles()");
        return (String[])this.runTransaction(new Transaction(){

            public Object run(IDataCursor cursor) {
                return TxnDataStore.this.getKeys(cursor);
            }
        }, false);
    }

    protected Object runTransaction(Transaction trans, boolean saveToFile) throws DataStorageException {
        if (this.inTransaction()) {
            return trans.run(DataCursorEmulator.create(this._cursor));
        }
        try {
            IDataSharedCursor dsc = this.fetchData().getSharedCursor();
            ITransaction txn = dsc.startTXN();
            DataCursorEmulator dc = DataCursorEmulator.create(dsc);
            Object obj = trans.run(dc);
            txn.commitTXN();
            dsc.destroy();
            dc.destroy();
            if (saveToFile) {
                this.saveToFile(this.fromTData());
            }
            return obj;
        }
        catch (TransactionException te) {
            throw new DataStoreTransactionException(te);
        }
    }

    protected IData getDefaultData() {
        try {
            TxnData td = TxnData.create();
            return td.getData();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected IData fromTData() throws DataStorageException {
        IData writable = PassmanBasicData.create();
        IDataSharedCursor txsc = this._data.getSharedCursor();
        IDataCursor wc = writable.getCursor();
        DataCursorEmulator txc = DataCursorEmulator.create(txsc);
        try {
            this.copy(txsc, txc, wc);
        }
        catch (TransactionException te) {
            throw new DataStorageException(te);
        }
        return writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(IDataSharedCursor shared, IDataCursor from, IDataCursor to) throws TransactionException {
        try {
            ITransaction t = shared.startTXN();
            this.copy(from, to);
            t.commitTXN();
        }
        finally {
            shared.destroy();
            from.destroy();
            to.destroy();
        }
    }

    protected IData fetchData() throws DataStorageException {
        if (this._data == null) {
            IData dataIn = this.readFile();
            this._data = this.getDefaultData();
            IDataCursor rdc = dataIn.getCursor();
            IDataSharedCursor txsc = this._data.getSharedCursor();
            DataCursorEmulator txc = DataCursorEmulator.create(txsc);
            try {
                this.copy(txsc, rdc, txc);
            }
            catch (TransactionException te) {
                throw new DataStorageException(te);
            }
        }
        return this._data;
    }

    protected boolean inTransaction() {
        return this._txn != null;
    }

    protected static interface Transaction {
        public Object run(IDataCursor var1);
    }
}

