/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.datastore;

import com.wm.app.passman.util.JavaLogger;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.passman.datastore.DataStorageException;
import com.wm.passman.datastore.DataStore;
import com.wm.passman.util.Logger;
import com.wm.util.codec.BinaryCodec;
import com.wm.util.codec.SimpleReferenceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;

public abstract class IDataStore
implements DataStore {
    public static final String EXCP_MSG_BUNDLE = "com.wm.app.passman.resources.PassManExceptionBundle";
    public static final int MAJOR_MSG_CODE = 2;
    private static final String DEFAULT_FILE_NAME = "defaultPassStore";
    protected String _fileName = "defaultPassStore";
    protected Logger _logger = new JavaLogger();

    public void setLogger(Logger logger) {
        if (logger != null) {
            this._logger = logger;
        }
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) throws DataStorageException {
        if (fileName == null || fileName.length() == 0) {
            throw new DataStorageException("BAP.0103.00001", EXCP_MSG_BUNDLE, new String[]{fileName}, "invalid file name: " + fileName);
        }
        this._fileName = fileName;
    }

    protected IData readFile() throws DataStorageException {
        this._logger.log(2, 8, 6, "enter initFromFile, using " + this._fileName + ")", new String[]{this._fileName});
        IData data = null;
        File passFile = new File(this._fileName);
        if (passFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(passFile);
            }
            catch (Exception e) {
                throw new DataStorageException("BAP.0103.00006", EXCP_MSG_BUNDLE, new String[]{this._fileName}, "problem with FileInputStream from: " + this._fileName);
            }
            BinaryCodec bc = new BinaryCodec();
            try {
                data = (IData)bc.decode(fis, new SimpleReferenceManager());
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw new DataStorageException("BAP.0103.00008", EXCP_MSG_BUNDLE, new String[]{this._fileName}, "problem with decode from: " + this._fileName);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        this._logger.logWarning("fis.close()", e, "can't close input streams");
                    }
                }
            }
        }
        data = this.getDefaultData();
        this._logger.log(2, 9, 6, "leave initFromFile");
        return data;
    }

    protected abstract IData getDefaultData();

    protected void saveToFile(IData data) throws DataStorageException {
        this._logger.log(2, 10, 6, "enter saveToFile, using " + this._fileName, new String[]{this._fileName});
        File passFile = new File(this._fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(passFile);
        }
        catch (Exception e) {
            throw new DataStorageException("BAP.0103.00009", EXCP_MSG_BUNDLE, new String[]{this._fileName}, "problem with FileOutputStream to: " + this._fileName);
        }
        BinaryCodec bc = new BinaryCodec();
        try {
            bc.encode(data, fos, new SimpleReferenceManager());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new DataStorageException("BAP.0103.00011", EXCP_MSG_BUNDLE, new String[]{this._fileName}, "problem with encode to: " + this._fileName);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    this._logger.logWarning("fos.close()", e, "can't close output streams");
                }
            }
        }
        this._logger.log(2, 11, 6, "leave saveToFile");
    }

    protected void store(IDataCursor cursor, String key, Object value) {
        if (cursor.first(key)) {
            cursor.setValue(value);
        } else {
            cursor.insertAfter(key, value);
        }
    }

    protected Object get(IDataCursor cursor, String key) {
        return cursor.first(key) ? cursor.getValue() : null;
    }

    protected Object delete(IDataCursor cursor, String key) {
        Object obj = null;
        if (cursor.first(key)) {
            obj = cursor.getValue();
            cursor.delete();
        }
        return obj;
    }

    protected String[] getKeys(IDataCursor cursor) {
        ArrayList<String> keys = new ArrayList<String>();
        if (cursor.first()) {
            do {
                String key;
                if ((key = cursor.getKey()) == null) {
                    this._logger.log(2, 99, 1, "dropping null handle from list");
                    continue;
                }
                if ((key = key.trim()).length() == 0) {
                    this._logger.log(2, 99, 1, "dropping empty handle from list");
                    continue;
                }
                keys.add(key);
            } while (cursor.next());
        }
        return keys.toArray(new String[0]);
    }

    protected void copy(IDataCursor from, IDataCursor to) {
        if (from.first()) {
            do {
                String key = from.getKey();
                Object val = from.getValue();
                to.insertAfter(key, val);
            } while (from.next());
        }
    }
}

