/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman.datastore;

import com.wm.app.passman.datastore.IDataStore;
import com.wm.app.passman.util.PassmanBasicData;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.passman.datastore.DataStorageException;
import com.wm.passman.datastore.DataStoreTransactionException;

public class DefaultDataStore
extends IDataStore {
    private IData _data;
    private IData _buData;

    public synchronized Object retrieve(String inHandle) throws DataStorageException {
        this._logger.log(2, 1, 6, "retrieve handle(" + inHandle + ")", new String[]{inHandle});
        if (this._data == null) {
            this._data = this.readFile();
        }
        IDataCursor csr = this._data.getCursor();
        Object returnObj = this.get(csr, inHandle);
        csr.destroy();
        return returnObj;
    }

    public void store(String inHandle, IDataPortable inObj) throws DataStorageException {
        this._logger.log(2, 2, 6, "store handle(" + inHandle + ")", new String[]{inHandle});
        if (this._data == null) {
            this._data = this.readFile();
        }
        IDataCursor csr = this._data.getCursor();
        this.store(csr, inHandle, inObj);
        csr.destroy();
        this.saveToFile(this._data);
    }

    public synchronized Object remove(String inHandle) throws DataStorageException {
        this._logger.log(2, 3, 6, "remove handle(" + inHandle + ")", new String[]{inHandle});
        if (this._data == null) {
            this._data = this.readFile();
        }
        IDataCursor csr = this._data.getCursor();
        Object returnObj = this.delete(csr, inHandle);
        csr.destroy();
        this.saveToFile(this._data);
        return returnObj;
    }

    public String[] listHandles() throws DataStorageException {
        this._logger.log(2, 3, 6, "enter listHandles()");
        if (this._data == null) {
            this._data = this.readFile();
        }
        IDataCursor csr = this._data.getCursor();
        String[] handles = this.getKeys(csr);
        csr.destroy();
        return handles;
    }

    public void beginTransaction() throws DataStoreTransactionException {
        if (this._buData != null) {
            throw new DataStoreTransactionException("BAP.0103.00012", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "transaction in progress");
        }
        this._buData = PassmanBasicData.create();
        if (this._data != null) {
            this.copyIData(this._data, this._buData);
        }
    }

    public void commitTransaction() throws DataStoreTransactionException, DataStorageException {
        if (this._buData == null) {
            throw new DataStoreTransactionException("BAP.0103.00013", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "can't commit, transaction not in progress");
        }
        this._buData = null;
        this.saveToFile(this._data);
    }

    public void rollbackTransaction() throws DataStoreTransactionException, DataStorageException {
        if (this._buData == null) {
            throw new DataStoreTransactionException("BAP.0103.00014", "com.wm.app.passman.resources.PassManExceptionBundle", new String[0], "can't rollback, transaction not in progress");
        }
        this._data = this._buData;
        this._buData = null;
        this.saveToFile(this._data);
    }

    private void copyIData(IData inSrc, IData inDest) {
        IDataCursor srcCsr = inSrc.getCursor();
        IDataCursor destCsr = inDest.getCursor();
        this.copy(srcCsr, destCsr);
        srcCsr.destroy();
        destCsr.destroy();
    }

    protected IData getDefaultData() {
        return PassmanBasicData.create();
    }
}

