/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman;

import com.wm.app.log.JournalLogHandler;
import com.wm.app.log.JournalLogManager;
import com.wm.app.passman.PassMan;
import com.wm.app.passman.PassManConfig;
import com.wm.app.passman.encryption.EncryptorImpl;
import com.wm.app.passman.util.BaseLoggerImpl;
import com.wm.app.passman.util.BasicLogger;
import com.wm.app.passman.util.JavaLogger;
import com.wm.passman.PasswordManagerException;
import com.wm.passman.datastore.DataStore;
import com.wm.passman.encryption.Encryptor;
import com.wm.passman.masterpw.MasterPassword;
import com.wm.passman.util.Logger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class PasswordManagerFactory {
    protected static final String MSG_BUNDLE_NAME = "com.wm.app.passman.resources.PassManMsgBundle";
    private static Map _managers;
    public static final int MAJOR_MSG_CODE = 1;
    private static final String DEFAULT_DS_CLASS_NAME = "com.wm.app.passman.datastore.DefaultDataStore";
    private static final String DEFAULT_MPW_CLASS_NAME = "com.wm.app.passman.masterpw.DefaultMasterPassword";
    private static final String DEFAULT_ENC_CLASS_NAME = "com.wm.app.passman.encryption.DefaultEncryptor";

    private PasswordManagerFactory() {
    }

    public static final PassMan create(String inName, PassManConfig inConfig, JournalLogManager inLogMgr, JournalLogHandler inLogHandler) throws PasswordManagerException {
        PassMan returnObj = null;
        if (_managers == null) {
            _managers = new HashMap();
        }
        if (_managers.containsKey(inName)) {
            returnObj = (PassMan)_managers.get(inName);
        } else {
            returnObj = PasswordManagerFactory.createPassMan(inConfig, inLogMgr, inLogHandler);
            _managers.put(inName, returnObj);
        }
        return returnObj;
    }

    public static final PassMan create(PassManConfig inConfig, JournalLogManager inLogMgr, JournalLogHandler inLogHandler) throws PasswordManagerException {
        return PasswordManagerFactory.create("default", inConfig, inLogMgr, inLogHandler);
    }

    public static final PassMan create(DataStore inDataStore, MasterPassword inMaster, Logger inLogger) throws PasswordManagerException {
        PassMan returnMgr = new PassMan(inDataStore, inMaster, inLogger);
        returnMgr.setSanityEncryptor(new EncryptorImpl());
        returnMgr.completeSetup();
        return returnMgr;
    }

    private static final PassMan createPassMan(PassManConfig inConfig, JournalLogManager inLogMgr, JournalLogHandler inLogHandler) throws PasswordManagerException {
        BaseLoggerImpl logger = new JavaLogger();
        logger.setFilterLevel(2);
        if (inLogMgr != null && inLogHandler != null) {
            logger = new BasicLogger(inLogMgr, inLogHandler);
        }
        DataStore dsm = PasswordManagerFactory.initDataStore(inConfig, logger);
        logger.log(1, 0, 6, "created a dsm", new Object[]{dsm});
        MasterPassword mpwm = PasswordManagerFactory.initMpw(inConfig, logger);
        logger.log(1, 1, 6, "created an mpwm", new Object[]{mpwm});
        PassMan returnMgr = new PassMan(dsm, mpwm, logger);
        logger.log(1, 2, 6, "created a passman", new Object[]{returnMgr});
        PasswordManagerFactory.setEncryptors(returnMgr, inConfig, logger);
        returnMgr.completeSetup();
        return returnMgr;
    }

    private static final DataStore initDataStore(PassManConfig inConfig, Logger inLogger) throws PasswordManagerException {
        String dsClassName = inConfig.getDataStoreClass();
        if (dsClassName == null) {
            dsClassName = DEFAULT_DS_CLASS_NAME;
        }
        inLogger.log(1, 4, 6, "ds class(" + dsClassName + ")", new String[]{dsClassName});
        Class<?> dsClass = null;
        try {
            dsClass = Class.forName(dsClassName);
        }
        catch (Exception e) {
            throw new PasswordManagerException(e);
        }
        DataStore returnDS = null;
        try {
            returnDS = (DataStore)dsClass.newInstance();
        }
        catch (Exception e) {
            throw new PasswordManagerException(e);
        }
        returnDS.setLogger(inLogger);
        Map paramsData = inConfig.getDataStoreParams();
        if (paramsData != null) {
            for (String nextName : paramsData.keySet()) {
                String nextValue = (String)paramsData.get(nextName);
                inLogger.log(1, 5, 6, "dsm param(" + nextName + ")=>(" + nextValue + ")", new String[]{nextName, nextValue});
                PasswordManagerFactory.setOneParam(returnDS, nextName, nextValue, inLogger);
            }
        }
        return returnDS;
    }

    private static final void setOneParam(Object inObj, String inParamName, String inParamValue, Logger inLogger) throws PasswordManagerException {
        String setMethName = "set" + inParamName.substring(0, 1).toUpperCase() + inParamName.substring(1);
        Class[] paramClass = new Class[]{String.class};
        Object[] paramVals = new Object[]{inParamValue};
        Method setMeth = null;
        try {
            setMeth = inObj.getClass().getMethod(setMethName, paramClass);
        }
        catch (NoSuchMethodException e) {
            inLogger.log(MSG_BUNDLE_NAME, 1, 11, 3, "can't find setter method: " + setMethName, new String[]{setMethName});
            setMeth = null;
        }
        catch (Exception e) {
            throw new PasswordManagerException(e);
        }
        if (setMeth != null) {
            try {
                setMeth.invoke(inObj, paramVals);
            }
            catch (Exception e) {
                throw new PasswordManagerException(e);
            }
        }
    }

    private static final MasterPassword initMpw(PassManConfig inConfig, Logger inLogger) throws PasswordManagerException {
        String mpwClassName = inConfig.getMasterPasswordClass();
        if (mpwClassName == null) {
            mpwClassName = DEFAULT_MPW_CLASS_NAME;
        }
        inLogger.log(1, 6, 6, "mpwm class(" + mpwClassName + ")", new String[]{mpwClassName});
        Class<?> mpwClass = null;
        try {
            mpwClass = Class.forName(mpwClassName);
        }
        catch (Exception e) {
            throw new PasswordManagerException(e);
        }
        MasterPassword returnMpw = null;
        try {
            returnMpw = (MasterPassword)mpwClass.newInstance();
        }
        catch (Exception e) {
            throw new PasswordManagerException(e);
        }
        returnMpw.setLogger(inLogger);
        Map paramsData = inConfig.getMasterPasswordParams();
        if (paramsData != null) {
            for (String nextName : paramsData.keySet()) {
                String nextValue = (String)paramsData.get(nextName);
                inLogger.log(1, 7, 6, "mpwm param(" + nextName + ")=>(" + nextValue + ")", new String[]{nextName, nextValue});
                PasswordManagerFactory.setOneParam(returnMpw, nextName, nextValue, inLogger);
            }
        }
        return returnMpw;
    }

    private static final void setEncryptors(PassMan inMgr, PassManConfig inConfig, Logger inLogger) throws PasswordManagerException {
        String[] encNameList = inConfig.listEncryptorClassNames();
        if (encNameList != null && encNameList.length > 0) {
            Encryptor sanityEnc;
            String sanityEncCode;
            Encryptor defEnc;
            for (int ndx = 0; ndx < encNameList.length; ++ndx) {
                String nextClassName = encNameList[ndx];
                Map nextParams = inConfig.getEncryptorParams(nextClassName);
                Encryptor newEnc = PasswordManagerFactory.createEncryptor(nextParams, nextClassName, inLogger);
                if (newEnc == null) continue;
                inLogger.log(1, 10, 6, "adding encryptor", new Object[]{newEnc});
                inMgr.addEncryptor(newEnc);
            }
            String defEncCode = inConfig.getDefaultEncryptorCode();
            if (defEncCode != null && (defEnc = inMgr.getEncryptor(defEncCode)) != null) {
                inMgr.setDefaultEncryptor(defEnc);
            }
            if ((sanityEncCode = inConfig.getSanityEncryptorCode()) != null && (sanityEnc = inMgr.getEncryptor(sanityEncCode)) != null) {
                inMgr.setSanityEncryptor(sanityEnc);
            }
        }
    }

    private static final Encryptor createEncryptor(Map inData, String inClassName, Logger inLogger) throws PasswordManagerException {
        Class<?> encClass = null;
        try {
            encClass = Class.forName(inClassName);
        }
        catch (Exception e) {
            throw new PasswordManagerException(e);
        }
        Encryptor returnEnc = null;
        try {
            returnEnc = (Encryptor)encClass.newInstance();
        }
        catch (Exception e) {
            throw new PasswordManagerException(e);
        }
        returnEnc.setLogger(inLogger);
        if (inData != null) {
            for (String nextName : inData.keySet()) {
                String nextValue = (String)inData.get(nextName);
                inLogger.log(1, 9, 6, "encm param(" + nextName + ")=>(" + nextValue + ")", new String[]{nextName, nextValue});
                PasswordManagerFactory.setOneParam(returnEnc, nextName, nextValue, inLogger);
            }
        }
        return returnEnc;
    }
}

