/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman;

import com.wm.app.passman.util.PassmanBasicData;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PassManConfig {
    private static final String CLASS_KEY = "Class";
    private static final String PARAMS_KEY = "Params";
    private static final String DATASTORE_KEY = "DataStore";
    private static final String MPW_KEY = "MasterPassword";
    private static final String ENC_INFO_KEY = "EncryptorInfo";
    private static final String ENC_LIST_FACT_KEY = "EncryptorList";
    private static final String DEF_ENC_CODE_FACT_KEY = "DefaultCode";
    private static final String SANITY_ENC_CODE_FACT_KEY = "SanityCode";
    private Map _map = new HashMap();

    public String getDataStoreClass() {
        return (String)this.getDataStoreMap().get(CLASS_KEY);
    }

    public Map getDataStoreParams() {
        return (Map)this.getDataStoreMap().get(PARAMS_KEY);
    }

    public void setDataStore(String inClassName, Map inParams) {
        if (inClassName != null && inClassName.length() > 0) {
            Map dsMap = this.getDataStoreMap();
            dsMap.put(CLASS_KEY, inClassName);
            dsMap.put(PARAMS_KEY, inParams);
        }
    }

    public String getMasterPasswordClass() {
        return (String)this.getMasterPasswordMap().get(CLASS_KEY);
    }

    public Map getMasterPasswordParams() {
        return (Map)this.getMasterPasswordMap().get(PARAMS_KEY);
    }

    public void setMasterPassword(String inClassName, Map inParams) {
        if (inClassName != null && inClassName.length() > 0) {
            Map mpwMap = this.getMasterPasswordMap();
            mpwMap.put(CLASS_KEY, inClassName);
            mpwMap.put(PARAMS_KEY, inParams);
        }
    }

    public String getDefaultEncryptorCode() {
        return (String)this.getEncryptorInfoMap().get(DEF_ENC_CODE_FACT_KEY);
    }

    public void setDefaultEncryptorCode(String inCode) {
        if (inCode != null && inCode.length() > 0) {
            Map encMap = this.getEncryptorInfoMap();
            encMap.put(DEF_ENC_CODE_FACT_KEY, inCode);
        }
    }

    public String getSanityEncryptorCode() {
        return (String)this.getEncryptorInfoMap().get(SANITY_ENC_CODE_FACT_KEY);
    }

    public void setSanityEncryptorCode(String inCode) {
        if (inCode != null && inCode.length() > 0) {
            Map encMap = this.getEncryptorInfoMap();
            encMap.put(SANITY_ENC_CODE_FACT_KEY, inCode);
        }
    }

    public void addEncryptor(String inClassName, Map inParams) {
        if (inClassName != null && inClassName.length() > 0) {
            ArrayList encList = this.getEncryptorList();
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            newMap.put(CLASS_KEY, inClassName);
            newMap.put(PARAMS_KEY, inParams);
            encList.add(newMap);
        }
    }

    public String[] listEncryptorClassNames() {
        ArrayList<String> returnList = new ArrayList<String>();
        ArrayList encList = this.getEncryptorList();
        for (int ndx = 0; ndx < encList.size(); ++ndx) {
            Map nextEnc = (Map)encList.get(ndx);
            String nextClass = (String)nextEnc.get(CLASS_KEY);
            returnList.add(nextClass);
        }
        return returnList.toArray(new String[0]);
    }

    public Map getEncryptorParams(String inClassName) {
        ArrayList encList;
        Map encMap;
        Map returnMap = new HashMap();
        if (inClassName != null && inClassName.length() > 0 && (encMap = this.lookupEncryptorMap(encList = this.getEncryptorList(), inClassName)) != null) {
            returnMap = (Map)encMap.get(PARAMS_KEY);
        }
        return returnMap;
    }

    private Map lookupEncryptorMap(ArrayList inList, String inClassName) {
        Map returnMap = null;
        if (inClassName != null && inClassName.length() > 0) {
            for (int ndx = 0; ndx < inList.size(); ++ndx) {
                Map nextMap = (Map)inList.get(ndx);
                String nextClass = (String)nextMap.get(CLASS_KEY);
                if (!inClassName.equals(nextClass)) continue;
                returnMap = nextMap;
                break;
            }
        }
        return returnMap;
    }

    private Map getDataStoreMap() {
        HashMap returnMap = (HashMap)this._map.get(DATASTORE_KEY);
        if (returnMap == null) {
            returnMap = new HashMap();
            this._map.put(DATASTORE_KEY, returnMap);
        }
        return returnMap;
    }

    private Map getMasterPasswordMap() {
        HashMap returnMap = (HashMap)this._map.get(MPW_KEY);
        if (returnMap == null) {
            returnMap = new HashMap();
            this._map.put(MPW_KEY, returnMap);
        }
        return returnMap;
    }

    private Map getEncryptorInfoMap() {
        HashMap returnMap = (HashMap)this._map.get(ENC_INFO_KEY);
        if (returnMap == null) {
            returnMap = new HashMap();
            this._map.put(ENC_INFO_KEY, returnMap);
        }
        return returnMap;
    }

    private ArrayList getEncryptorList() {
        Map encMap = this.getEncryptorInfoMap();
        ArrayList returnList = (ArrayList)encMap.get(ENC_LIST_FACT_KEY);
        if (returnList == null) {
            returnList = new ArrayList();
            encMap.put(ENC_LIST_FACT_KEY, returnList);
        }
        return returnList;
    }

    public void dump(StringBuffer inBuff) {
        String prefix = "..";
        if (inBuff != null) {
            inBuff.append("PassMan configuration parameters:\n");
            this.dumpInfoMap("data store", prefix, this.getDataStoreMap(), inBuff);
            this.dumpInfoMap("master password", prefix, this.getMasterPasswordMap(), inBuff);
            inBuff.append("Encryptor Info:\n");
            inBuff.append(prefix + "Default code: " + this.getDefaultEncryptorCode() + "\n");
            inBuff.append(prefix + "Sanity code: " + this.getSanityEncryptorCode() + "\n");
            String[] allEncClasses = this.listEncryptorClassNames();
            ArrayList encList = this.getEncryptorList();
            for (int ndx = 0; ndx < allEncClasses.length; ++ndx) {
                Map encMap = this.lookupEncryptorMap(encList, allEncClasses[ndx]);
                this.dumpInfoMap("encryptor #" + ndx, prefix, encMap, inBuff);
            }
        }
    }

    private void dumpInfoMap(String inTitle, String inPrefix, Map inMap, StringBuffer inBuff) {
        if (inMap == null) {
            inBuff.append(inPrefix + "no " + inTitle + " information registered\n");
        } else {
            inBuff.append(inPrefix + inTitle + ":\n");
            String newPrefix = inPrefix + inPrefix;
            inBuff.append(newPrefix + "class: " + inMap.get(CLASS_KEY) + "\n");
            Map params = (Map)inMap.get(PARAMS_KEY);
            if (params == null) {
                inBuff.append(newPrefix + "params: NULL\n");
            } else {
                inBuff.append(newPrefix + "params:\n");
                for (String nextKey : params.keySet()) {
                    inBuff.append(newPrefix + inPrefix + nextKey + "=>" + params.get(nextKey) + "\n");
                }
            }
        }
    }

    public void dump(IData inData) {
        if (inData != null) {
            IDataCursor csr = inData.getCursor();
            IData dsData = this.dumpInfoMap("dataStore", this.getDataStoreMap());
            csr.insertAfter("dataStore", dsData);
            IData mpwData = this.dumpInfoMap("masterPassword", this.getMasterPasswordMap());
            csr.insertAfter("masterPassword", mpwData);
            IData encData = this.dumpEncryptorInfo();
            csr.insertAfter("encryptorInfo", encData);
            csr.destroy();
        }
    }

    private IData dumpInfoMap(String inLabel, Map inMap) {
        IData returnData = PassmanBasicData.create();
        IDataCursor topCsr = returnData.getCursor();
        if (inMap == null) {
            topCsr.insertAfter(inLabel, "null ");
        } else {
            topCsr.insertAfter(inLabel + CLASS_KEY, inMap.get(CLASS_KEY));
            IData paramData = PassmanBasicData.create();
            IDataCursor paramCsr = paramData.getCursor();
            Map params = (Map)inMap.get(PARAMS_KEY);
            if (params == null) {
                paramCsr.insertAfter(inLabel + PARAMS_KEY, "null ");
            } else {
                for (String nextKey : params.keySet()) {
                    paramCsr.insertAfter(nextKey, params.get(nextKey));
                }
            }
            paramCsr.destroy();
            topCsr.insertAfter(inLabel + PARAMS_KEY, paramData);
        }
        topCsr.destroy();
        return returnData;
    }

    private IData dumpEncryptorInfo() {
        IData returnData = PassmanBasicData.create();
        IDataCursor csr = returnData.getCursor();
        String defCode = this.getDefaultEncryptorCode();
        csr.insertAfter("defaultEncryptor", defCode == null ? "unknown" : defCode);
        String sanityCode = this.getSanityEncryptorCode();
        csr.insertAfter("sanityEncryptor", sanityCode == null ? "unknown" : sanityCode);
        String[] allEncClasses = this.listEncryptorClassNames();
        ArrayList encList = this.getEncryptorList();
        ArrayList<IData> encDataList = new ArrayList<IData>();
        for (int ndx = 0; ndx < allEncClasses.length; ++ndx) {
            IData encData = this.dumpInfoMap("encryptor", this.lookupEncryptorMap(encList, allEncClasses[ndx]));
            encDataList.add(encData);
        }
        csr.insertAfter("encryptorList", encDataList.toArray(new IData[0]));
        csr.destroy();
        return returnData;
    }
}

