/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.passman;

import com.wm.app.passman.encryption.EncryptorImpl;
import com.wm.app.passman.util.ExpirationInterval;
import com.wm.passman.PasswordAdministrator;
import com.wm.passman.PasswordManager;
import com.wm.passman.PasswordManagerException;
import com.wm.passman.PasswordSanityException;
import com.wm.passman.PasswordWrapper;
import com.wm.passman.datastore.DataStorageException;
import com.wm.passman.datastore.DataStore;
import com.wm.passman.encryption.EncryptionException;
import com.wm.passman.encryption.Encryptor;
import com.wm.passman.masterpw.MasterPassword;
import com.wm.passman.masterpw.MasterPasswordException;
import com.wm.passman.util.Logger;
import com.wm.util.security.WmSecureString;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PassMan
implements PasswordManager,
PasswordAdministrator {
    public static final String EXCP_MSG_BUNDLE = "com.wm.app.passman.resources.PassManExceptionBundle";
    public static final String MSG_BUNDLE = "com.wm.app.passman.resources.PassManMsgBundle";
    public static final String PROD_ID_CODE = "BAP";
    public static final int MAJOR_MSG_CODE = 0;
    private static final String INTERNAL_HANDLE_PREFIX = "wm.passman.core";
    public static final String SANITY_CHECK_HANDLE = "wm.passman.core.sanityCheck";
    public static final String SANITY_CHECK_PW = "secuwityIsVewyVewyImpowtant";
    private static final String HANDLE_EXPIRE_INTERVAL = "wm.passman.core.expireInterval";
    private static final String HANDLE_EXPIRE_LCD = "wm.passman.core.expireLastChangedDate";
    public static final int EXPIRE_DATE_STYLE = 3;
    public static final int EXPIRE_TIME_STYLE = 1;
    private Map _encryptors;
    private DataStore _ds;
    private MasterPassword _mpw;
    private Date _masterLastChanged;
    private int _masterExpireInterval;
    private String _defaultEncCode;
    private String _noopEncCode;
    private String _sanityEncCode;
    private boolean _sanityFlag;
    private Logger _logger;
    private static final int DEFAULT_EXPIRATION_INTERVAL = 90;

    PassMan(DataStore inDs, MasterPassword inMpw, Logger inLogger) throws DataStorageException, MasterPasswordException, PasswordManagerException {
        if (inDs == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"data store"}, "Can't use null ds");
        }
        this._ds = inDs;
        if (inMpw == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"master password"}, "Can't use null mpw");
        }
        this._mpw = inMpw;
        if (inLogger == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"logger"}, "Can't use null logger");
        }
        this._logger = inLogger;
        this._sanityFlag = true;
        this.initializeEncryptors();
    }

    public void completeSetup() throws PasswordManagerException {
        String[] storedHandles = this._ds.listHandles();
        if (storedHandles == null || storedHandles.length == 0) {
            this._mpw.reset();
        }
        int maxRetries = this._mpw.getLoginAttemptsLimit();
        for (int cnt = 0; cnt < maxRetries; ++cnt) {
            this._mpw.retrieve(true);
            if (this.sanityCheck()) break;
            this._sanityFlag = true;
        }
        this.initMasterLastChangedDate();
        this.initMasterExpireInterval();
    }

    public String adminHandlePrefix() {
        return INTERNAL_HANDLE_PREFIX;
    }

    public synchronized void addEncryptor(Encryptor inEnc) throws PasswordManagerException {
        if (inEnc == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"encryptor"}, "Can't use null encryptor");
        }
        if (this._encryptors != null) {
            this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 1, 8, "add enc(" + inEnc + ")", new Object[]{inEnc});
            this._encryptors.put(inEnc.getCode(), inEnc);
        }
    }

    public synchronized void removeEncryptor(String inCode) {
        if (this._encryptors != null && this._encryptors.containsKey(inCode)) {
            this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 2, 8, "remove encryptor(" + inCode + ")", new String[]{inCode});
            this._encryptors.remove(inCode);
        }
    }

    public void removeEncryptor(Encryptor inEnc) throws PasswordManagerException {
        if (inEnc == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"encryptor"}, "Can't remove null encryptor");
        }
        this.removeEncryptor(inEnc.getCode());
    }

    public synchronized void setDefaultEncryptor(Encryptor inEnc) throws PasswordManagerException {
        if (inEnc == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"default encryptor"}, "Can't use null default encryptor");
        }
        this._defaultEncCode = inEnc.getCode();
        if (this._encryptors == null || !this._encryptors.containsKey(this._defaultEncCode)) {
            this.addEncryptor(inEnc);
        }
    }

    public synchronized void setSanityEncryptor(Encryptor inEnc) throws PasswordManagerException {
        if (inEnc == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"sanity encryptor"}, "Can't use null sanity encryptor");
        }
        this._sanityEncCode = inEnc.getCode();
        if (this._encryptors == null || !this._encryptors.containsKey(this._sanityEncCode)) {
            this.addEncryptor(inEnc);
        }
    }

    public synchronized String[] listEncryptors() {
        ArrayList<Object> codeList = new ArrayList<Object>();
        if (this._encryptors != null) {
            Iterator it = this._encryptors.keySet().iterator();
            while (it.hasNext()) {
                codeList.add(it.next());
            }
        }
        codeList.add("default: " + this._defaultEncCode);
        codeList.add("sanity: " + this._sanityEncCode);
        return codeList.toArray(new String[0]);
    }

    public boolean storePassword(String inHandle, WmSecureString inPw) throws PasswordManagerException {
        return this.storePassword(inHandle, inPw, null);
    }

    public synchronized boolean storePassword(String inHandle, WmSecureString inPw, String inCode) throws PasswordManagerException {
        this.checkOurSanity("00008");
        String useThisCode = this._defaultEncCode;
        if (inCode != null && inCode.length() > 0) {
            useThisCode = inCode;
        }
        if (inHandle == null || inHandle.trim().length() == 0) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"handle"}, "Can't use null handle");
        }
        if (inPw == null) {
            throw new PasswordManagerException("BAP.0100.00002", EXCP_MSG_BUNDLE, new String[]{"secure string"}, "Can't use null secure string");
        }
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 3, 8, "store handle(" + inHandle + ")", new String[]{inHandle});
        this._ds.beginTransaction();
        try {
            this.nonSyncStorePassword(inHandle, inPw, useThisCode);
            this._ds.commitTransaction();
        }
        catch (PasswordManagerException pme) {
            this._ds.rollbackTransaction();
            throw pme;
        }
        catch (Throwable t) {
            this._ds.rollbackTransaction();
            throw new PasswordManagerException(t);
        }
        return true;
    }

    private void checkOurSanity(String inMsgId) throws PasswordSanityException {
        if (!this._sanityFlag) {
            throw new PasswordSanityException("BAP.0100." + inMsgId, EXCP_MSG_BUNDLE, new String[0], "Can't " + inMsgId + " while insane");
        }
    }

    private boolean nonSyncStorePassword(String inHandle, WmSecureString inPw, String inCode) throws PasswordManagerException {
        WmSecureString mpwBuff = this._mpw.retrieve();
        PasswordWrapper epw = this.encrypt(inPw, mpwBuff, inCode);
        this._ds.store(inHandle, epw);
        return true;
    }

    public synchronized WmSecureString retrievePassword(String inHandle) throws PasswordManagerException {
        this.checkOurSanity("00009");
        WmSecureString returnBuff = null;
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 4, 8, "retrieve password for handle(" + inHandle + ")", new String[]{inHandle});
        PasswordWrapper epw = (PasswordWrapper)this._ds.retrieve(inHandle);
        if (epw != null) {
            WmSecureString mpwBuff = this._mpw.retrieve();
            returnBuff = this.decrypt(epw, mpwBuff);
        }
        return returnBuff;
    }

    public synchronized String retrieveEncryptionCode(String inHandle) throws PasswordManagerException {
        String returnBuff = null;
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 15, 8, "retrieve enc code for handle(" + inHandle + ")", new String[]{inHandle});
        PasswordWrapper epw = (PasswordWrapper)this._ds.retrieve(inHandle);
        if (epw != null) {
            returnBuff = epw.getEncryptionCode();
        }
        return returnBuff;
    }

    public synchronized boolean removePassword(String inHandle) throws PasswordManagerException {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 5, 8, "remove handle(" + inHandle + ")", new String[]{inHandle});
        this.checkOurSanity("00011");
        this._ds.beginTransaction();
        boolean rc = false;
        try {
            rc = this.nonSyncRemovePassword(inHandle);
            this._ds.commitTransaction();
        }
        catch (PasswordManagerException pme) {
            this._ds.rollbackTransaction();
            throw pme;
        }
        catch (Throwable t) {
            this._ds.rollbackTransaction();
            throw new PasswordManagerException(t);
        }
        return rc;
    }

    private boolean nonSyncRemovePassword(String inHandle) throws PasswordManagerException {
        return this._ds.remove(inHandle) != null;
    }

    public synchronized boolean handleInUse(String inHandle) {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 6, 8, "enter handleInUse(" + inHandle + ")", new String[]{inHandle});
        Object epw = null;
        try {
            epw = this._ds.retrieve(inHandle);
        }
        catch (DataStorageException dse) {
            this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 14, 2, "can not retrieve password data store");
            epw = null;
        }
        return epw != null;
    }

    Encryptor getEncryptor(String inCode) {
        Encryptor returnEnc = null;
        if (this._encryptors != null && this._encryptors.containsKey(inCode)) {
            returnEnc = (Encryptor)this._encryptors.get(inCode);
        }
        return returnEnc;
    }

    public synchronized String[] listHandles() throws PasswordManagerException {
        return this.listHandles(null);
    }

    public synchronized String[] listHandles(String inPrefix) throws PasswordManagerException {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 7, 8, "enter listHandles(" + inPrefix + ")", new String[]{inPrefix});
        String[] handles = this._ds.listHandles();
        ArrayList<String> publicHandles = new ArrayList<String>();
        for (int ndx = 0; ndx < handles.length; ++ndx) {
            if (this.internalHandle(handles[ndx]) || inPrefix != null && !handles[ndx].startsWith(inPrefix)) continue;
            publicHandles.add(handles[ndx]);
        }
        return publicHandles.toArray(new String[0]);
    }

    public synchronized String[] listInternalHandles() throws PasswordManagerException {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 23, 8, "enter listInternalHandles()");
        String[] handles = this._ds.listHandles();
        ArrayList<String> nonPublicHandles = new ArrayList<String>();
        for (int ndx = 0; ndx < handles.length; ++ndx) {
            if (!this.internalHandle(handles[ndx])) continue;
            nonPublicHandles.add(handles[ndx]);
        }
        return nonPublicHandles.toArray(new String[0]);
    }

    private boolean internalHandle(String inHandle) {
        boolean returnBool = true;
        if (inHandle != null) {
            returnBool = inHandle.startsWith(INTERNAL_HANDLE_PREFIX);
        }
        return returnBool;
    }

    public synchronized int resetAllPasswords() throws PasswordManagerException {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 18, 8, "reset all passwords");
        String[] handles = this.listHandles();
        this._ds.beginTransaction();
        try {
            for (int ndx = 0; ndx < handles.length; ++ndx) {
                String nextHandle = handles[ndx];
                String nextCode = this.retrieveEncryptionCode(nextHandle);
                try {
                    this.nonSyncStorePassword(nextHandle, new WmSecureString(""), nextCode);
                    continue;
                }
                catch (PasswordSanityException pse) {
                    // empty catch block
                }
            }
            this._mpw.reset();
            this._masterLastChanged = Calendar.getInstance().getTime();
            this._sanityFlag = true;
            this.storeMasterLastChangedDate();
            this.initMasterExpireInterval();
            this.storeSanityHandle();
            this._ds.commitTransaction();
        }
        catch (PasswordManagerException pme) {
            this._ds.rollbackTransaction();
            throw pme;
        }
        catch (Throwable t) {
            this._ds.rollbackTransaction();
            throw new PasswordManagerException(t);
        }
        return handles.length;
    }

    public synchronized boolean verifyMasterPassword(WmSecureString inBuff) throws PasswordManagerException {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 8, 8, "enter verifyMasterPassword()");
        this.checkOurSanity("00012");
        WmSecureString mpwBuff = null;
        try {
            mpwBuff = this._mpw.retrieve();
        }
        catch (MasterPasswordException mpe) {
            this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 13, 2, "can not retrieve master password");
            mpwBuff = null;
        }
        boolean rc = mpwBuff != null && mpwBuff.equals(inBuff);
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 9, 8, "verifyMasterPassword() returns " + String.valueOf(rc), new String[]{String.valueOf(rc)});
        return rc;
    }

    public synchronized int updateMasterPassword(WmSecureString inOldMpw, WmSecureString inNewMpw) throws PasswordManagerException {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 10, 8, "enter updateMasterPassword()");
        this.checkOurSanity("00013");
        if (!this.verifyMasterPassword(inOldMpw)) {
            throw new PasswordManagerException("BAP.0100.00004", EXCP_MSG_BUNDLE, new String[0], "master password verify fails");
        }
        this._ds.beginTransaction();
        int conversionCount = 0;
        try {
            conversionCount = this.prepareForMasterUpdate(this._mpw.retrieve(), inNewMpw);
            this.storeMasterPassword(inNewMpw);
            this._ds.commitTransaction();
        }
        catch (PasswordManagerException pme) {
            this._ds.rollbackTransaction();
            throw pme;
        }
        catch (Throwable t) {
            this._ds.rollbackTransaction();
            throw new PasswordManagerException(t);
        }
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 11, 8, "leave updateMasterPassword(), returning " + String.valueOf(conversionCount), new String[]{String.valueOf(conversionCount)});
        return conversionCount;
    }

    public boolean sanityCheck() {
        String pw = null;
        try {
            WmSecureString secPw = this.retrievePassword(SANITY_CHECK_HANDLE);
            if (secPw == null) {
                this.storeSanityHandle();
                pw = SANITY_CHECK_PW;
            } else {
                pw = secPw.toString();
            }
        }
        catch (Exception e) {
            this._logger.log(EXCP_MSG_BUNDLE, PROD_ID_CODE, 0, 7, 1, "sanity check fails", new String[]{e.getMessage()});
            pw = null;
        }
        this._sanityFlag = pw == null ? false : SANITY_CHECK_PW.equals(pw);
        return this._sanityFlag;
    }

    public boolean getSanityFlag() {
        return this._sanityFlag;
    }

    public synchronized int getMasterExpirationInterval() {
        return this._masterExpireInterval;
    }

    public synchronized void setMasterExpirationInterval(int inDays) throws PasswordManagerException {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 19, 8, "enter setMasterExpirationInterval()");
        this.checkOurSanity("00014");
        if (inDays < 0 || inDays > 366) {
            String dayStr = String.valueOf(inDays);
            throw new PasswordManagerException("BAP.0100.00005", EXCP_MSG_BUNDLE, new String[]{dayStr}, "invalid expire days: " + dayStr);
        }
        this._masterExpireInterval = inDays;
        this.storeMasterExpireInterval();
    }

    public synchronized Date getMasterLastChangedDate() {
        return this._masterLastChanged;
    }

    public synchronized Date getMasterExpirationDate() {
        return ExpirationInterval.calculateExpirationDate(this._masterLastChanged, this._masterExpireInterval);
    }

    public synchronized int getMasterPasswordState() {
        int returnState = 0;
        if (!this._sanityFlag) {
            returnState = 3;
        } else if (this.masterExpired()) {
            returnState = 1;
        } else if (this.masterAboutToExpire()) {
            returnState = 2;
        }
        return returnState;
    }

    private boolean masterExpired() {
        ExpirationInterval epxInt = new ExpirationInterval(this._masterLastChanged, this._masterExpireInterval);
        Date now = Calendar.getInstance().getTime();
        return epxInt.isExpired(now);
    }

    public synchronized int daysToMasterExpiration() {
        return this.daysToMasterExpiration(Calendar.getInstance().getTime());
    }

    public synchronized int daysToMasterExpiration(Date inDate) {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 22, 8, "enter daysToMasterExpiration()");
        ExpirationInterval epxInt = new ExpirationInterval(this._masterLastChanged, this._masterExpireInterval);
        return epxInt.daysTilExpiration(inDate);
    }

    private boolean masterAboutToExpire() {
        this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 21, 8, "enter masterAboutToExpire()");
        ExpirationInterval epxInt = new ExpirationInterval(this._masterLastChanged, this._masterExpireInterval);
        Date now = Calendar.getInstance().getTime();
        return epxInt.isAboutToExpire(now);
    }

    private int prepareForMasterUpdate(WmSecureString inOldMpw, WmSecureString inNewMpw) throws PasswordManagerException {
        int returnCount = 0;
        this._mpw.validateNewMaster(inNewMpw);
        String[] handles = this._ds.listHandles();
        PasswordWrapper nextPw = null;
        for (int ndx = 0; ndx < handles.length; ++ndx) {
            String nextHandle = handles[ndx];
            nextPw = (PasswordWrapper)this._ds.retrieve(nextHandle);
            if (!this.internalHandle(nextHandle)) {
                ++returnCount;
            }
            WmSecureString clearPw = this.decrypt(nextPw, inOldMpw);
            String cryptCode = nextPw.getEncryptionCode();
            PasswordWrapper newPw = this.encrypt(clearPw, inNewMpw, cryptCode);
            this._ds.store(nextHandle, newPw);
        }
        return returnCount;
    }

    private PasswordWrapper encrypt(WmSecureString inPw, WmSecureString inMaster, String inCode) throws EncryptionException {
        Encryptor enc = this.getEncryptor(inCode);
        if (enc == null) {
            throw new EncryptionException("BAP.0105.00001", EXCP_MSG_BUNDLE, new String[]{inCode}, "unsupported encryption code(" + inCode + ")");
        }
        byte[] passArray = inPw == null || inPw.toString().length() == 0 ? new byte[]{} : enc.encrypt(inPw, inMaster);
        return new PasswordWrapper(passArray, inCode);
    }

    private WmSecureString decrypt(PasswordWrapper inPw, WmSecureString inMaster) throws EncryptionException {
        WmSecureString returnBuff = null;
        byte[] realPw = (byte[])inPw.getObject();
        if (realPw == null || realPw.length == 0) {
            returnBuff = new WmSecureString("");
        } else {
            String encCode = inPw.getEncryptionCode();
            Encryptor enc = this.getEncryptor(encCode);
            if (enc == null) {
                throw new EncryptionException("BAP.0105.00001", EXCP_MSG_BUNDLE, new String[]{encCode}, "unsupported encryption code(" + encCode + ")");
            }
            returnBuff = enc.decrypt(realPw, inMaster);
        }
        return returnBuff;
    }

    private void storeMasterPassword(WmSecureString inBuff) throws PasswordManagerException {
        this._mpw.store(inBuff);
        this._masterLastChanged = Calendar.getInstance().getTime();
        this.storeMasterLastChangedDate();
    }

    private void initializeEncryptors() {
        if (this._encryptors == null) {
            this._encryptors = new HashMap();
        }
        EncryptorImpl encryptor = new EncryptorImpl();
        try {
            this.addEncryptor(encryptor);
        }
        catch (PasswordManagerException pme) {
            this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 17, 1, "bogus msg, no-op enc is null");
        }
        this._defaultEncCode = this._noopEncCode = encryptor.getCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMasterLastChangedDate() throws PasswordManagerException {
        boolean needToStore = false;
        WmSecureString tempSec = null;
        try {
            tempSec = this.retrievePassword(HANDLE_EXPIRE_LCD);
        }
        catch (PasswordManagerException pme) {
            // empty catch block
        }
        if (tempSec == null) {
            this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 17, 2, "found null last-changed date, using default", new String[]{"null"});
            this._masterLastChanged = Calendar.getInstance().getTime();
            needToStore = true;
        } else {
            DateFormat df = DateFormat.getDateTimeInstance(3, 1);
            try {
                this._masterLastChanged = df.parse(tempSec.toString());
            }
            catch (ParseException pe) {
                String secStr = tempSec.toString();
                this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 17, 2, "found invalid last-changed date, " + secStr + ", using default", new String[]{secStr});
                this._masterLastChanged = Calendar.getInstance().getTime();
                needToStore = true;
            }
        }
        if (needToStore) {
            PassMan passMan = this;
            synchronized (passMan) {
                this.storeMasterLastChangedDate();
            }
        }
    }

    private void storeMasterLastChangedDate() throws PasswordManagerException {
        DateFormat df = DateFormat.getDateTimeInstance(3, 1);
        String dateStr = df.format(this._masterLastChanged);
        this.nonSyncStorePassword(HANDLE_EXPIRE_LCD, new WmSecureString(dateStr), this._noopEncCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMasterExpireInterval() throws PasswordManagerException {
        boolean needToStore = false;
        WmSecureString tempSec = this.retrievePassword(HANDLE_EXPIRE_INTERVAL);
        if (tempSec == null) {
            this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 16, 2, "found null expire interval, using default", new String[]{"null"});
            this._masterExpireInterval = 90;
            needToStore = true;
        } else {
            try {
                this._masterExpireInterval = new Integer(tempSec.toString());
            }
            catch (NumberFormatException nfe) {
                String secStr = tempSec.toString();
                this._logger.log(MSG_BUNDLE, PROD_ID_CODE, 0, 16, 2, "found invalid expire interval, " + secStr + ", using default", new String[]{secStr});
                this._masterExpireInterval = 90;
                needToStore = true;
            }
        }
        if (needToStore) {
            PassMan passMan = this;
            synchronized (passMan) {
                this.storeMasterExpireInterval();
            }
        }
    }

    private void storeMasterExpireInterval() throws PasswordManagerException {
        String intStr = String.valueOf(this._masterExpireInterval);
        this.nonSyncStorePassword(HANDLE_EXPIRE_INTERVAL, new WmSecureString(intStr), this._noopEncCode);
    }

    private synchronized void storeSanityHandle() throws PasswordManagerException {
        this.nonSyncStorePassword(SANITY_CHECK_HANDLE, new WmSecureString(SANITY_CHECK_PW), this._sanityEncCode);
    }

    public void dump(StringBuffer inBuff) {
        if (inBuff != null) {
            inBuff.append("Dumping pass man:\n");
            if (this._ds == null) {
                inBuff.append("...data store is NULL!\n");
            } else {
                inBuff.append("...data store: " + this._ds + "\n");
            }
            if (this._mpw == null) {
                inBuff.append("...master password is NULL!\n");
            } else {
                inBuff.append("...master password: " + this._mpw + "\n");
            }
            inBuff.append("...master password expiration interval: " + this._masterExpireInterval + "\n");
            if (this._masterLastChanged == null) {
                inBuff.append("...master password last changed date is NULL!\n");
            } else {
                DateFormat df = DateFormat.getDateInstance(3);
                inBuff.append("...master password last changed on: " + df.format(this._masterLastChanged) + "\n");
            }
            inBuff.append("...internal encryptor code: " + this._noopEncCode + "\n");
            inBuff.append("...default encryptor code: " + this._defaultEncCode + "\n");
            this.dumpEncryptors(inBuff);
        }
    }

    private void dumpEncryptors(StringBuffer inBuff) {
        if (this._encryptors == null) {
            inBuff.append("...encryptors list is NULL!\n");
        } else if (this._encryptors.size() == 0) {
            inBuff.append("...encryptors list is EMPTY!\n");
        } else {
            inBuff.append("...encryptors list:\n");
            Encryptor nextEnc = null;
            for (String nextCode : this._encryptors.keySet()) {
                nextEnc = (Encryptor)this._encryptors.get(nextCode);
                inBuff.append("......code(" + nextCode + ") ==> (" + nextEnc + ")\n");
            }
        }
    }
}

