/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.util;

import com.wm.app.log.JournalLogConsumer;
import com.wm.app.log.JournalLogEntry;
import com.wm.app.log.JournalLogHandler;
import com.wm.app.log.JournalLogListener;
import com.wm.app.log.JournalLogManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;

public class FileMsgHandler
implements JournalLogHandler {
    JournalLogManager _logMan;
    JournalLogConsumer _logCon;
    FileOutputStream _fos = null;
    OutputStreamWriter _osw = null;
    String _newLine;
    boolean _notifySent = false;

    public FileMsgHandler(JournalLogManager logMan, String filename) throws IOException {
        this(logMan, filename, false);
    }

    public FileMsgHandler(JournalLogManager logMan, String filename, boolean append) throws IOException {
        this._fos = new FileOutputStream(filename, append);
        this.init(logMan, this._fos);
    }

    public FileMsgHandler(JournalLogManager logMan, OutputStream os) throws IOException {
        this.init(logMan, os);
    }

    private void init(JournalLogManager logMan, OutputStream os) throws IOException {
        this._logMan = logMan;
        this._logCon = this._logMan.createConsumer();
        this._logCon.setListener(new JournalLogListener(){

            public void processEntry(JournalLogEntry entry) {
                FileMsgHandler.this.handleEntry(entry);
            }
        });
        this._osw = new OutputStreamWriter(os, "UTF-8");
        this._newLine = System.getProperty("line.separator", "\n");
    }

    public void destroy() {
        this._logCon.setListener(null);
        try {
            this._osw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._osw = null;
        this._fos = null;
    }

    public void setFilterLevel(int level) {
        this._logCon.setFilterLevel(level);
    }

    public void addFilterProductId(String prodId) {
        this._logCon.addFilterProductId(prodId);
    }

    public void addFilterProductId(String prodId, int[] majors) {
        this._logCon.addFilterProductId(prodId, majors);
    }

    public void removeFilterProductId(String prodId) {
        this._logCon.removeFilterProductId(prodId);
    }

    public int getFilterLevel() {
        return this._logCon.getFilterLevel();
    }

    public Hashtable getFilterProductIds() {
        return this._logCon.getFilterProductIds();
    }

    private synchronized void handleEntry(JournalLogEntry entry) {
        block2: {
            try {
                this._osw.write(entry.getMessage());
                this._osw.write(this._newLine);
                this._osw.flush();
                this._notifySent = false;
            }
            catch (IOException e) {
                if (this._notifySent) break block2;
                this._notifySent = true;
                this._logCon.failureNotify(e);
            }
        }
    }
}

