/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.util;

import com.wm.app.log.JournalLogEntry;
import com.wm.util.BasisIOException;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;

public class FileJavaSerReader {
    FileInputStream _input;
    ObjectInputStream _ois;
    int _filterLevel;
    Hashtable _filterIds;

    public FileJavaSerReader(FileInputStream in) throws IOException {
        this._input = in;
        this._ois = new ObjectInputStream(in);
        this._filterLevel = Integer.MAX_VALUE;
        this._filterIds = null;
    }

    public void setFilterLevel(int level) {
        this._filterLevel = level;
    }

    public void addFilterProductId(String prodId) {
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        }
        this._filterIds.put(prodId, null);
    }

    public void addFilterProductId(String prodId, int[] majors) {
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        }
        this._filterIds.put(prodId, majors);
    }

    public void removeFilterProductId(String prodId) {
        this._filterIds.remove(prodId);
    }

    public Hashtable getFilterProductIds() {
        return (Hashtable)this._filterIds.clone();
    }

    public JournalLogEntry nextEntry() throws IOException {
        JournalLogEntry entry = null;
        try {
            while (!this.passesFilter((entry = (JournalLogEntry)this._ois.readObject()).getProductId(), entry.getMajor(), entry.getLevel())) {
            }
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                entry = null;
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new BasisIOException("BAC.0002.0000", "com.wm.resources.CoreExcpMsgs", e);
        }
        return entry;
    }

    boolean passesFilter(String prodId, int major, int level) {
        boolean ret = false;
        if (level <= this._filterLevel) {
            if (this._filterIds == null) {
                ret = true;
            } else if (this._filterIds.containsKey(prodId)) {
                int[] majors = (int[])this._filterIds.get(prodId);
                if (majors == null) {
                    ret = true;
                } else {
                    for (int i = 0; i < majors.length; ++i) {
                        if (majors[i] != major) continue;
                        ret = true;
                        break;
                    }
                }
            }
        }
        return ret;
    }
}

