/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.util;

import com.wm.app.log.JournalLogConsumer;
import com.wm.app.log.JournalLogEntry;
import com.wm.app.log.JournalLogHandler;
import com.wm.app.log.JournalLogListener;
import com.wm.app.log.JournalLogManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class FileJavaSerHandler
implements JournalLogHandler {
    JournalLogManager _logMan;
    JournalLogConsumer _logCon;
    String _filename;
    FileOutputStream _fos = null;
    ObjectOutputStream _oos;
    boolean _notifySent = false;

    public FileJavaSerHandler(JournalLogManager logMan, String filename) throws IOException {
        this(logMan, filename, false);
    }

    public FileJavaSerHandler(JournalLogManager logMan, String filename, boolean append) throws IOException {
        this._logMan = logMan;
        this._logCon = this._logMan.createConsumer();
        this._logCon.setListener(new JournalLogListener(){

            public void processEntry(JournalLogEntry entry) {
                FileJavaSerHandler.this.handleEntry(entry);
            }
        });
        this._filename = filename;
        this._fos = new FileOutputStream(this._filename, append);
        this._oos = new ObjectOutputStream(this._fos);
    }

    public void destroy() {
        this._logCon.setListener(null);
        try {
            this._oos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._fos = null;
        this._oos = null;
    }

    public void setFilterLevel(int level) {
        this._logCon.setFilterLevel(level);
    }

    public void addFilterProductId(String prodId) {
        this._logCon.addFilterProductId(prodId);
    }

    public void addFilterProductId(String prodId, int[] majors) {
        this._logCon.addFilterProductId(prodId, majors);
    }

    public void removeFilterProductId(String prodId) {
        this._logCon.removeFilterProductId(prodId);
    }

    public int getFilterLevel() {
        return this._logCon.getFilterLevel();
    }

    public Hashtable getFilterProductIds() {
        return this._logCon.getFilterProductIds();
    }

    private synchronized void handleEntry(JournalLogEntry entry) {
        block2: {
            try {
                this._oos.writeObject(entry);
                this._oos.flush();
                this._notifySent = false;
            }
            catch (IOException e) {
                if (this._notifySent) break block2;
                this._notifySent = true;
                this._logCon.failureNotify(e);
            }
        }
    }
}

