/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.util;

import com.wm.app.log.JournalLogEntry;
import com.wm.io.codec.CodecException;
import com.wm.io.codec.IObjectReferer;
import com.wm.util.codec.BinaryCodec;
import com.wm.util.codec.SimpleReferenceManager;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class FileEntryReader {
    FileInputStream _input;
    BinaryCodec _codec;
    IObjectReferer _referrer;
    int _filterLevel;
    Hashtable _filterIds;

    public FileEntryReader(FileInputStream in) {
        this._input = in;
        this._codec = new BinaryCodec();
        this._referrer = new SimpleReferenceManager();
        this._filterLevel = Integer.MAX_VALUE;
        this._filterIds = null;
    }

    public void setFilterLevel(int level) {
        this._filterLevel = level;
    }

    public void addFilterProductId(String prodId) {
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        }
        this._filterIds.put(prodId, null);
    }

    public void addFilterProductId(String prodId, int[] majors) {
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        }
        this._filterIds.put(prodId, majors);
    }

    public void removeFilterProductId(String prodId) {
        this._filterIds.remove(prodId);
    }

    public Hashtable getFilterProductIds() {
        return (Hashtable)this._filterIds.clone();
    }

    public JournalLogEntry nextEntry() throws IOException, CodecException {
        JournalLogEntry entry = null;
        try {
            while (!this.passesFilter((entry = (JournalLogEntry)this._codec.decode(this._input, this._referrer)).getProductId(), entry.getMajor(), entry.getLevel())) {
            }
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                entry = null;
            }
            throw e;
        }
        return entry;
    }

    boolean passesFilter(String prodId, int major, int level) {
        boolean ret = false;
        if (level <= this._filterLevel) {
            if (this._filterIds == null) {
                ret = true;
            } else if (this._filterIds.containsKey(prodId)) {
                int[] majors = (int[])this._filterIds.get(prodId);
                if (majors == null) {
                    ret = true;
                } else {
                    for (int i = 0; i < majors.length; ++i) {
                        if (majors[i] != major) continue;
                        ret = true;
                        break;
                    }
                }
            }
        }
        return ret;
    }
}

