/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.util;

import com.wm.app.log.JournalLogConsumer;
import com.wm.app.log.JournalLogEntry;
import com.wm.app.log.JournalLogHandler;
import com.wm.app.log.JournalLogListener;
import com.wm.app.log.JournalLogManager;
import com.wm.io.codec.CodecException;
import com.wm.io.codec.IObjectReferer;
import com.wm.util.codec.BinaryCodec;
import com.wm.util.codec.SimpleReferenceManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class FileEntryHandler
implements JournalLogHandler {
    JournalLogManager _logMan;
    JournalLogConsumer _logCon;
    String _filename;
    FileOutputStream _fos = null;
    BinaryCodec _codec;
    IObjectReferer _referrer;
    boolean _notifySent = false;

    public FileEntryHandler(JournalLogManager logMan, String filename) throws IOException {
        this(logMan, filename, false);
    }

    public FileEntryHandler(JournalLogManager logMan, String filename, boolean append) throws IOException {
        this._logMan = logMan;
        this._logCon = this._logMan.createConsumer();
        this._logCon.setListener(new JournalLogListener(){

            public void processEntry(JournalLogEntry entry) {
                FileEntryHandler.this.handleEntry(entry);
            }
        });
        this._filename = filename;
        this._fos = new FileOutputStream(this._filename, append);
        this._codec = new BinaryCodec();
        this._referrer = new SimpleReferenceManager();
    }

    public void destroy() {
        this._logCon.setListener(null);
        try {
            this._fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._fos = null;
    }

    public void setFilterLevel(int level) {
        this._logCon.setFilterLevel(level);
    }

    public void addFilterProductId(String prodId) {
        this._logCon.addFilterProductId(prodId);
    }

    public void addFilterProductId(String prodId, int[] majors) {
        this._logCon.addFilterProductId(prodId, majors);
    }

    public void removeFilterProductId(String prodId) {
        this._logCon.removeFilterProductId(prodId);
    }

    public int getFilterLevel() {
        return this._logCon.getFilterLevel();
    }

    public Hashtable getFilterProductIds() {
        return this._logCon.getFilterProductIds();
    }

    private synchronized void handleEntry(JournalLogEntry entry) {
        block4: {
            try {
                this._codec.encode(entry, this._fos, this._referrer);
                this._fos.flush();
                this._notifySent = false;
            }
            catch (IOException e) {
                if (!this._notifySent) {
                    this._notifySent = true;
                    this._logCon.failureNotify(e);
                }
            }
            catch (CodecException e) {
                if (this._notifySent) break block4;
                this._notifySent = true;
                this._logCon.failureNotify(e);
            }
        }
    }
}

