/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.util;

import com.wm.app.log.JournalLogConsumer;
import com.wm.app.log.JournalLogEntry;
import com.wm.app.log.JournalLogHandler;
import com.wm.app.log.JournalLogListener;
import com.wm.app.log.JournalLogManager;
import com.wm.util.io.DailyFileUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;

public class DailyFileMsgHandler
implements JournalLogHandler {
    JournalLogManager _logMan;
    JournalLogConsumer _logCon;
    String _filenamePattern;
    String _filename;
    long _rollTime;
    FileOutputStream _fos = null;
    OutputStreamWriter _osw = null;
    String _newLine;
    boolean _notifySent = false;

    public DailyFileMsgHandler(JournalLogManager logMan, String filenamePattern) throws IOException {
        this(logMan, filenamePattern, false);
    }

    public DailyFileMsgHandler(JournalLogManager logMan, String filenamePattern, boolean append) throws IOException {
        this._logMan = logMan;
        this._logCon = this._logMan.createConsumer();
        this._logCon.setListener(new JournalLogListener(){

            public void processEntry(JournalLogEntry entry) {
                DailyFileMsgHandler.this.handleEntry(entry);
            }
        });
        this._filenamePattern = filenamePattern;
        this._filename = DailyFileUtil.generateFilename(this._filenamePattern);
        this._rollTime = DailyFileUtil.getMidnightTime();
        this._fos = new FileOutputStream(this._filename, append);
        this._osw = new OutputStreamWriter((OutputStream)this._fos, "UTF-8");
        this._newLine = System.getProperty("line.separator", "\n");
    }

    public void destroy() {
        this._logCon.setListener(null);
        try {
            this._osw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._osw = null;
        this._fos = null;
    }

    public void setFilterLevel(int level) {
        this._logCon.setFilterLevel(level);
    }

    public void addFilterProductId(String prodId) {
        this._logCon.addFilterProductId(prodId);
    }

    public void addFilterProductId(String prodId, int[] majors) {
        this._logCon.addFilterProductId(prodId, majors);
    }

    public void removeFilterProductId(String prodId) {
        this._logCon.removeFilterProductId(prodId);
    }

    public int getFilterLevel() {
        return this._logCon.getFilterLevel();
    }

    public Hashtable getFilterProductIds() {
        return this._logCon.getFilterProductIds();
    }

    public String getFilename() {
        return this._filename;
    }

    private synchronized void handleEntry(JournalLogEntry entry) {
        block3: {
            try {
                if (System.currentTimeMillis() >= this._rollTime) {
                    this._osw.close();
                    this._filename = DailyFileUtil.generateFilename(this._filenamePattern);
                    this._rollTime = DailyFileUtil.getMidnightTime();
                    this._fos = new FileOutputStream(this._filename);
                    this._osw = new OutputStreamWriter((OutputStream)this._fos, "UTF-8");
                }
                this._osw.write(entry.getMessage());
                this._osw.write(this._newLine);
                this._osw.flush();
                this._notifySent = false;
            }
            catch (IOException e) {
                if (this._notifySent) break block3;
                this._notifySent = true;
                this._logCon.failureNotify(e);
            }
        }
    }
}

