/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.impl.sc;

import com.webmethods.sc.logging.log4j.GlobalizedEvent;
import com.webmethods.sc.logging.log4j.GlobalizedEventFactory;
import com.wm.app.log.IFacilityInfo;
import com.wm.app.log.JournalLogProducer;
import com.wm.app.log.impl.sc.LevelTranslator;
import com.wm.app.log.impl.sc.SCLogManager;
import java.text.DecimalFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCLogProducer
extends JournalLogProducer {
    private static final DecimalFormat MAJOR_FMT = new DecimalFormat("0000");
    private static ArrayList<String> IS_PRODUCT_IDS = null;
    private static ArrayList<String> COMP_PRODUCT_IDS = null;
    public static ClassLoader CLASS_LOADER = null;
    public static IFacilityInfo facility_info = null;
    SCLogManager _logMan;

    public SCLogProducer(SCLogManager man) {
        this._logMan = man;
    }

    @Override
    public void logEntry(String bundle, String prodId, int major, int minor, int level, String dfltTxt, Object[] parms, boolean lookupByMajor) {
        if (IS_PRODUCT_IDS == null) {
            IS_PRODUCT_IDS = facility_info.getISProductIDs();
        }
        if (COMP_PRODUCT_IDS == null) {
            COMP_PRODUCT_IDS = facility_info.getBasisComponentProductIDs();
        }
        if (!this._logMan.anyListeners(prodId, major, level)) {
            return;
        }
        String msgKey = null;
        msgKey = !"BAS".equals(prodId) && COMP_PRODUCT_IDS.contains(prodId) ? this.buildCompMessageKey(prodId, major, minor) : (lookupByMajor ? this.buildMessageKey(major, minor) : this.buildMessageKey(minor));
        String majorStr = MAJOR_FMT.format(major);
        GlobalizedEvent event = GlobalizedEventFactory.getInstance().create(CLASS_LOADER, bundle, msgKey, parms, prodId, majorStr);
        String loggerName = null;
        loggerName = IS_PRODUCT_IDS.contains(prodId) ? facility_info.getLoggerId(major) : prodId + "." + majorStr;
        this._logMan.notifyListeners(event, LevelTranslator.findLog4jLevel(level), loggerName);
    }

    @Override
    public boolean anyListeners(String prodId, int major, int level) {
        return this._logMan.anyListeners(prodId, major, level);
    }

    private String buildMessageKey(int inMajor, int inMinor) {
        return String.valueOf(inMajor) + "." + String.valueOf(inMinor);
    }

    private String buildCompMessageKey(String prodId, int inMajor, int inMinor) {
        return prodId + "." + MAJOR_FMT.format(inMajor) + "." + ("BAP".equals(prodId) ? "0" : "") + MAJOR_FMT.format(inMinor);
    }

    private String buildMessageKey(int inMinor) {
        return String.valueOf(inMinor);
    }

    static ArrayList<String> getISProductIds() {
        if (IS_PRODUCT_IDS == null) {
            IS_PRODUCT_IDS = facility_info.getISProductIDs();
        }
        return IS_PRODUCT_IDS;
    }

    static ArrayList<String> getCompProductIds() {
        if (COMP_PRODUCT_IDS == null) {
            COMP_PRODUCT_IDS = facility_info.getBasisComponentProductIDs();
        }
        return COMP_PRODUCT_IDS;
    }
}

