/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.impl.sc;

import com.webmethods.sc.logging.log4j.GlobalizedEvent;
import com.wm.app.log.JournalLogConsumer;
import com.wm.app.log.JournalLogListener;
import com.wm.app.log.impl.sc.LevelTranslator;
import com.wm.app.log.impl.sc.SCLogListener;
import com.wm.app.log.impl.sc.SCLogManager;
import com.wm.app.log.impl.sc.SCLogProducer;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCLogConsumer
implements JournalLogConsumer {
    SCLogManager _logMan;
    SCLogConsumer _nextConsumer = null;
    SCLogListener _listener = null;
    int _filterLevel = Integer.MAX_VALUE;
    Hashtable<String, BitSet> _filterIds = null;
    HashMap<String, BitSet> filters = null;
    boolean ISFilterSet = false;
    boolean MonFilterSet = false;

    @Override
    public void setListener(JournalLogListener l) {
    }

    public void setListener(SCLogListener l) {
        this._listener = l;
    }

    @Override
    public void setFilterLevel(int level) {
        this._filterLevel = level;
    }

    public void setFilter(String loggerName, Level level) {
        if (level == null) {
            return;
        }
        if (this.isEmpty(loggerName)) {
            return;
        }
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        int l = LevelTranslator.findISLevelCode(level);
        BitSet bit = new BitSet(11);
        for (int i = 0; i <= l; ++i) {
            bit.set(i);
        }
        if (loggerName.equals("SERVER")) {
            for (String prodId : SCLogProducer.getISProductIds()) {
                this.filters.put(prodId, bit);
            }
            for (String prodId : SCLogProducer.getCompProductIds()) {
                this.filters.put(prodId, bit);
            }
        } else {
            String key = this.getFilterProdKey(loggerName);
            this.filters.put(key, bit);
        }
        if (!this.ISFilterSet) {
            this.ISFilterSet = true;
        }
    }

    public void removeFilter(String loggerName) {
        if (this.isEmpty(loggerName)) {
            return;
        }
        if (this.filters == null) {
            return;
        }
        if (loggerName.equals("SERVER")) {
            for (String prodId : SCLogProducer.getISProductIds()) {
                this.filters.remove(prodId);
            }
            for (String prodId : SCLogProducer.getCompProductIds()) {
                this.filters.remove(prodId);
            }
        } else {
            String key = this.getFilterProdKey(loggerName);
            this.filters.remove(key);
        }
        if (this.filters.isEmpty()) {
            this.filters = null;
            this.ISFilterSet = false;
        }
    }

    private String getFilterProdKey(String loggerName) {
        String fac = null;
        String prod = null;
        String key = null;
        if (loggerName.equals("SERVER")) {
            return loggerName;
        }
        int index = loggerName.indexOf("SERVER.");
        if (index >= 0) {
            index = loggerName.indexOf(46);
            if (index > 0) {
                int index1 = loggerName.indexOf(46, index + 1);
                prod = loggerName.substring(index + 1, index1);
                fac = loggerName.substring(index1 + 1);
                key = prod + Integer.parseInt(fac);
            }
        } else {
            index = loggerName.indexOf(46);
            if (index > 0) {
                prod = loggerName.substring(0, index);
                fac = loggerName.substring(index + 1);
                key = prod + Integer.parseInt(fac);
            } else {
                key = loggerName;
            }
        }
        return key;
    }

    public boolean passesFilter(String prodId, int major, int level) {
        if (!this.ISFilterSet) {
            return level <= this._filterLevel;
        }
        BitSet bit = this.filters.get(prodId + major);
        if (bit != null) {
            return bit.get(level);
        }
        bit = this.filters.get(prodId);
        if (bit != null) {
            return bit.get(level);
        }
        return level <= this._filterLevel;
    }

    @Override
    public void addFilterProductId(String prodId) {
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        }
        this._filterIds.put(prodId, new BitSet(0));
        this.MonFilterSet = true;
    }

    @Override
    public void addFilterProductId(String prodId, int[] majors) {
        BitSet bs = null;
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        } else {
            bs = this._filterIds.get(prodId);
        }
        if (bs == null || bs.length() == 0) {
            bs = new BitSet(64);
        }
        for (int i = 0; i < majors.length; ++i) {
            bs.set(majors[i]);
        }
        this._filterIds.put(prodId, bs);
        this.MonFilterSet = true;
    }

    @Override
    public void removeFilterProductId(String prodId) {
        if (this._filterIds != null) {
            this._filterIds.remove(prodId);
            if (this._filterIds.size() == 0) {
                this._filterIds = null;
                this.MonFilterSet = false;
            }
        }
    }

    @Override
    public int getFilterLevel() {
        return this._filterLevel;
    }

    @Override
    public Hashtable getFilterProductIds() {
        Hashtable<String, int[]> ht = null;
        if (this._filterIds != null) {
            ht = new Hashtable<String, int[]>();
            Enumeration<String> en = this._filterIds.keys();
            while (en.hasMoreElements()) {
                int i;
                String k = en.nextElement();
                BitSet bs = this._filterIds.get(k);
                if (bs.length() == 0) continue;
                int j = 0;
                for (i = 0; i < bs.length(); ++i) {
                    if (!bs.get(i)) continue;
                    ++j;
                }
                int[] ia = new int[j];
                j = 0;
                for (i = 0; i < bs.length(); ++i) {
                    if (!bs.get(i)) continue;
                    ia[j++] = i;
                }
                ht.put(k, ia);
            }
        }
        return ht;
    }

    @Override
    public void failureNotify(Exception e) {
        this._logMan.notifyFailure(e);
    }

    SCLogConsumer(SCLogManager logMan) {
        this._logMan = logMan;
        this._filterLevel = Integer.MAX_VALUE;
    }

    void notifyListener(GlobalizedEvent inEvent, Level inLevel, String inTarget) {
        if (this._listener != null) {
            this._listener.processEntry(inEvent, inLevel, inTarget);
        }
    }

    public void printFilterCache() {
        System.out.println("\n\nCurrent Filter level is " + this.getFilterLevel());
        SCLogConsumer.printHashMap(this.filters);
    }

    private static void printHashMap(HashMap<String, BitSet> map) {
        Set<String> set = map.keySet();
        for (String key : set) {
            System.out.print(key);
            System.out.print(" = ");
            System.out.println(map.get(key));
        }
    }

    private boolean isEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    public static void main(String[] args) {
        SCLogConsumer con = new SCLogConsumer(null);
        con.setFilterLevel(0);
        con.setFilter("SERVER", Level.OFF);
        System.out.println("ISFilterSet is " + con.ISFilterSet);
        con.setFilter("SERVER.ISU.0000", Level.DEBUG);
        con.setFilter("XSL", Level.ERROR);
        con.setFilter("XSL.0001", Level.TRACE);
        con.setFilter("FF", Level.INFO);
        con.setFilter("FF.0000", Level.TRACE);
        SCLogConsumer.printHashMap(con.filters);
        System.out.println("ISU-0-6 " + con.passesFilter("ISU", 0, 6));
        System.out.println("ISU-0-8 " + con.passesFilter("ISU", 0, 8));
        System.out.println("BAP-1-0 " + con.passesFilter("BAP", 1, 0));
        System.out.println("FF-2-3 " + con.passesFilter("FF", 2, 3));
        System.out.println("FF-2-5 " + con.passesFilter("FF", 2, 5));
        System.out.println("FF-0-8 " + con.passesFilter("FF", 0, 8));
        con.removeFilter("SERVER");
        con.removeFilter("SERVER.ISU.0000");
        con.removeFilter("XSL");
        con.removeFilter("XSL.0001");
        con.removeFilter("FF");
        con.removeFilter("FF.0000");
        if (con.filters == null) {
            System.out.println("\nfilters is null");
        } else {
            SCLogConsumer.printHashMap(con.filters);
        }
        System.out.println("ISFilterSet is " + con.ISFilterSet);
        System.out.println("ISU-0-6 " + con.passesFilter("ISU", 0, 6));
        System.out.println("ISU-0-8 " + con.passesFilter("ISU", 0, 8));
        System.out.println("BAP-1-0 " + con.passesFilter("BAP", 1, 0));
        System.out.println("FF-2-3 " + con.passesFilter("FF", 2, 3));
        System.out.println("FF-2-5 " + con.passesFilter("FF", 2, 3));
        System.out.println("FF-0-8 " + con.passesFilter("FF", 0, 8));
    }
}

