/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.impl.sc;

import java.util.HashMap;
import org.apache.log4j.Level;

public class LevelTranslator {
    private static HashMap<Level, String> LEVEL2STRING;
    private static HashMap<Level, Integer> LEVEL2CODE;
    private static HashMap<Integer, Level> CODE2LEVEL;

    private LevelTranslator() {
    }

    public static Level findLog4jLevel(int inLevel) {
        if (inLevel > 10) {
            return Level.TRACE;
        }
        if (inLevel < 0) {
            return Level.OFF;
        }
        return CODE2LEVEL.get(inLevel);
    }

    public static int findISLevelCode(Level inLevel) {
        return LEVEL2CODE.get(inLevel);
    }

    public static String findISLevelString(Level inLevel) {
        return LEVEL2STRING.get(inLevel);
    }

    private static synchronized void initLevelToStringTable() {
        LEVEL2STRING = new HashMap();
        LEVEL2STRING.put(Level.FATAL, "C");
        LEVEL2STRING.put(Level.ERROR, "E");
        LEVEL2STRING.put(Level.WARN, "W");
        LEVEL2STRING.put(Level.INFO, "I");
        LEVEL2STRING.put(Level.DEBUG, "D");
        LEVEL2STRING.put(Level.TRACE, "T");
    }

    private static synchronized void initCodeToLevelTable() {
        CODE2LEVEL = new HashMap();
        CODE2LEVEL.put(0, Level.FATAL);
        CODE2LEVEL.put(1, Level.ERROR);
        CODE2LEVEL.put(2, Level.WARN);
        CODE2LEVEL.put(3, Level.INFO);
        CODE2LEVEL.put(4, Level.INFO);
        CODE2LEVEL.put(5, Level.DEBUG);
        CODE2LEVEL.put(6, Level.DEBUG);
        CODE2LEVEL.put(7, Level.DEBUG);
        CODE2LEVEL.put(8, Level.TRACE);
        CODE2LEVEL.put(9, Level.TRACE);
        CODE2LEVEL.put(10, Level.TRACE);
    }

    private static synchronized void initLevelToCodeTable() {
        LEVEL2CODE = new HashMap();
        LEVEL2CODE.put(Level.FATAL, 0);
        LEVEL2CODE.put(Level.ERROR, 1);
        LEVEL2CODE.put(Level.WARN, 2);
        LEVEL2CODE.put(Level.INFO, 4);
        LEVEL2CODE.put(Level.DEBUG, 7);
        LEVEL2CODE.put(Level.TRACE, 10);
        LEVEL2CODE.put(Level.OFF, -1);
    }

    static {
        LevelTranslator.initLevelToStringTable();
        LevelTranslator.initLevelToCodeTable();
        LevelTranslator.initCodeToLevelTable();
    }
}

