/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.impl.sc;

import com.webmethods.sc.logging.log4j.GlobalizedEvent;
import com.wm.app.log.impl.sc.LevelTranslator;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

class GlobalizedEventISFormatter {
    private static final String NULL_EVENT_STR = "globalized IS event formatter found a NULL input event!";
    private static final String NULL_LEVEL_STR = "?";
    private static final String NL_STR = System.getProperty("line.separator");
    private static String TIMESTAMP_FORMAT = null;
    private static final int MAJOR_TARGET_LEN = 4;
    private static final int MINOR_TARGET_LEN = 4;
    private static final String[] PADS = new String[]{"", "0", "00", "000", "0000"};

    private GlobalizedEventISFormatter() {
    }

    public static String format(GlobalizedEvent inG8dEvent) {
        return GlobalizedEventISFormatter.format(inG8dEvent, null, null);
    }

    public static String format(GlobalizedEvent inG8dEvent, Locale inLocale) {
        return GlobalizedEventISFormatter.format(inG8dEvent, null, inLocale);
    }

    public static String format(GlobalizedEvent inG8dEvent, LoggingEvent inLog4jEvent) {
        return GlobalizedEventISFormatter.format(inG8dEvent, inLog4jEvent, null);
    }

    public static String format(GlobalizedEvent inG8dEvent, LoggingEvent inLog4jEvent, Locale inLocale) {
        Level level = inLog4jEvent == null ? null : inLog4jEvent.getLevel();
        String levelStr = level == null ? NULL_LEVEL_STR : LevelTranslator.findISLevelString(level);
        return GlobalizedEventISFormatter.fmt(inG8dEvent, levelStr, inLocale);
    }

    private static String fmt(GlobalizedEvent inG8dEvent, String inLevelStr, Locale inLocale) {
        StringBuilder buff = new StringBuilder();
        if (inG8dEvent == null) {
            buff.append(NULL_EVENT_STR);
        } else {
            SimpleDateFormat fmt = inLocale == null ? new SimpleDateFormat(TIMESTAMP_FORMAT) : new SimpleDateFormat(TIMESTAMP_FORMAT, inLocale);
            buff.append(fmt.format(inG8dEvent.getCreateTime()));
            buff.append(" [");
            buff.append(GlobalizedEventISFormatter.fillOutKey(inG8dEvent.getMessageKey(), inG8dEvent));
            buff.append(inLevelStr);
            buff.append("] ");
            buff.append(inG8dEvent.getMessage(inLocale));
            buff.append(NL_STR);
        }
        return buff.toString();
    }

    public static void setTimestampFormat(String timestampFormat) {
        TIMESTAMP_FORMAT = timestampFormat;
    }

    private static String fillOutKey(String inMsgKey, GlobalizedEvent inG8dEvent) {
        if (inMsgKey == null || inG8dEvent == null) {
            return inMsgKey;
        }
        String compId = inG8dEvent.getComponentId() + ".";
        String returnStr = compId + inMsgKey;
        int keyLen = inMsgKey.length();
        int dotNdx = inMsgKey.indexOf(".");
        int secondDot = inMsgKey.indexOf(".", dotNdx + 1);
        StringBuilder buff = new StringBuilder();
        int paddingNeeded = 0;
        if (dotNdx >= 0) {
            if (secondDot >= 0) {
                if (keyLen - secondDot > 4) {
                    String key = inMsgKey.substring(secondDot);
                    return inMsgKey.substring(0, secondDot) + "." + key.substring(2);
                }
                return inMsgKey;
            }
            paddingNeeded = 4 - dotNdx;
            if (paddingNeeded > 0 && paddingNeeded < 4) {
                buff.append(PADS[paddingNeeded]);
            }
            buff.append(inMsgKey.substring(0, dotNdx));
            buff.append(".");
            paddingNeeded = 4 - keyLen + ++dotNdx;
            if (paddingNeeded > 0 && paddingNeeded < 4) {
                buff.append(PADS[paddingNeeded]);
            }
            buff.append(inMsgKey.substring(dotNdx));
            returnStr = compId + buff.toString();
        } else {
            buff.append(inG8dEvent.getSubcomponentId());
            buff.append(".");
            ++dotNdx;
            paddingNeeded = 4 - keyLen;
            if (paddingNeeded > 0 && paddingNeeded < 4) {
                buff.append(PADS[paddingNeeded]);
            }
            buff.append(inMsgKey.substring(dotNdx));
            returnStr = compId + buff.toString();
        }
        return returnStr;
    }
}

