/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.impl.basic;

import com.wm.app.log.JournalLogData;
import com.wm.app.log.JournalLogEntry;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BasicLogEntry
extends JournalLogEntry {
    public static final String TIME = "logTime";
    public static final String BUNDLENAME = "logBundle";
    public static final String PRODID = "logProdId";
    public static final String MAJOR = "logMajor";
    public static final String MINOR = "logMinor";
    public static final String LEVEL = "logLevel";
    public static final String DFLTMSG = "logDfltMsg";
    public static final String PARMCOUNT = "logParmcnt";
    public static final String PARM = "logParm";
    public static final String DFLTDATEFORMAT = "yyyy-MM-dd HH:mm:ss z";
    private static SimpleDateFormat _defaultDf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static final String[] LEVELSUFFIX = new String[]{"C", "E", "W", "I", "D", "V"};
    private String _systemId;
    private Long _time = new Long(System.currentTimeMillis());
    private String _bundle;
    private String _productId;
    private Integer _major;
    private Integer _minor;
    private Integer _level;
    private String _dfltTxt;
    private Object[] _parms;
    private boolean _lookupByMajor;

    public BasicLogEntry() {
        this(null, null, 0, 0, 0, null, null);
    }

    public BasicLogEntry(String bundle, String productId, int majorCode, int minorCode, int level, String dfltTxt, Object[] parms) {
        this(bundle, productId, majorCode, minorCode, level, dfltTxt, parms, true);
    }

    public BasicLogEntry(String bundle, String productId, int majorCode, int minorCode, int level, String dfltTxt, Object[] parms, boolean lookupByMajor) {
        this._bundle = bundle;
        this._productId = productId;
        this._major = new Integer(majorCode);
        this._minor = new Integer(minorCode);
        this._level = new Integer(level);
        this._dfltTxt = dfltTxt;
        this._parms = this.cloneArray(parms);
        this._lookupByMajor = lookupByMajor;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public String getBundleBase() {
        return this._bundle;
    }

    public String getProductId() {
        return this._productId;
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getLevel() {
        return this._level;
    }

    public String getDefaultText() {
        return this._dfltTxt;
    }

    public Object[] getParms() {
        return this._parms;
    }

    public String getMessage(Locale loc, ClassLoader loader, DateFormat df) {
        ResourceBundle b = null;
        String m = null;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        try {
            if (this._bundle != null) {
                b = loader == null ? ResourceBundle.getBundle(this._bundle, loc) : ResourceBundle.getBundle(this._bundle, loc, loader);
                m = b.getString(this.getBundleKey());
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (m == null && this._dfltTxt != null) {
            m = "Message not found in \"" + this._bundle + "\". " + this._dfltTxt;
        }
        return new String(this.getTimestamp(df) + " " + this.format(m));
    }

    public IData getAsData() {
        IData data = JournalLogData.create();
        IDataCursor cursor = data.getCursor();
        int iParms = this._parms != null ? this._parms.length : 0;
        cursor.insertAfter(TIME, this._time);
        cursor.insertAfter(BUNDLENAME, this._bundle);
        cursor.insertAfter(PRODID, this._productId);
        cursor.insertAfter(MAJOR, this._major);
        cursor.insertAfter(MINOR, this._minor);
        cursor.insertAfter(LEVEL, this._level);
        cursor.insertAfter(DFLTMSG, this._dfltTxt);
        cursor.insertAfter(PARMCOUNT, new Integer(iParms));
        for (int i = 0; i < iParms; ++i) {
            cursor.insertAfter(PARM, this._parms[i]);
        }
        cursor.destroy();
        return data;
    }

    public void setFromData(IData data) {
        IDataCursor cursor = data.getCursor();
        int cnt = 0;
        int i = 0;
        if (cursor.first(PARMCOUNT)) {
            cnt = (Integer)cursor.getValue();
        }
        this._parms = cnt > 0 ? new String[cnt] : null;
        boolean rc = cursor.first();
        while (rc) {
            String key = cursor.getKey();
            if (key.equals(TIME)) {
                this._time = (Long)cursor.getValue();
            } else if (key.equals(BUNDLENAME)) {
                this._bundle = (String)cursor.getValue();
            } else if (key.equals(PRODID)) {
                this._productId = (String)cursor.getValue();
            } else if (key.equals(MAJOR)) {
                this._major = (Integer)cursor.getValue();
            } else if (key.equals(MINOR)) {
                this._minor = (Integer)cursor.getValue();
            } else if (key.equals(LEVEL)) {
                this._level = (Integer)cursor.getValue();
            } else if (key.equals(DFLTMSG)) {
                this._dfltTxt = (String)cursor.getValue();
            } else if (key.equals(PARM) && this._parms != null) {
                this._parms[i++] = (String)cursor.getValue();
            }
            rc = cursor.next();
        }
        cursor.destroy();
    }

    private Object[] cloneArray(Object[] a) {
        if (a == null) {
            return null;
        }
        int len = a.length;
        Object[] a1 = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object o = a[i];
            a1[i] = o instanceof String || o instanceof Number || o instanceof Date ? o : (o instanceof Throwable && this._level >= 4 ? this.getStackTrace((Throwable)o) : (o == null ? "" : o.toString()));
        }
        return a1;
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private String format(String msgformat) {
        StringBuffer sb;
        MessageFormat mf;
        int iParms;
        String s;
        block7: {
            s = null;
            iParms = this._parms == null ? 0 : this._parms.length;
            if (msgformat != null) {
                try {
                    mf = new MessageFormat(msgformat);
                    if (this._productId == null) {
                        s = mf.format(this._parms);
                    } else {
                        sb = new StringBuffer();
                        sb.append(this.getMessageId());
                        sb.append(" ");
                        sb.append(mf.format(this._parms));
                        s = sb.toString();
                    }
                }
                catch (Exception e) {
                    if (msgformat == null) break block7;
                    s = this._productId == null ? msgformat : this.getMessageId() + " " + msgformat;
                }
            }
        }
        if (s == null) {
            sb = new StringBuffer();
            sb.append(this.getMessageId());
            sb.append("  Message not found in \"");
            sb.append(this._bundle);
            sb.append("\".");
            for (int i = 0; i < iParms; ++i) {
                sb.append(" ");
                sb.append(i);
                sb.append("={");
                sb.append(i);
                sb.append("}");
            }
            mf = new MessageFormat(sb.toString());
            s = mf.format(this._parms);
        }
        return s;
    }

    private String getBundleKey() {
        if (this._lookupByMajor) {
            return new String(this._major + "." + this._minor);
        }
        return new String("" + this._minor);
    }

    private String getMessageId() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this._productId);
        sb.append(".");
        this.appendIntPadded(sb, this._major, 4);
        sb.append(".");
        this.appendIntPadded(sb, this._minor, 4);
        int lev = this._level;
        if (lev <= 4) {
            sb.append(LEVELSUFFIX[lev]);
        } else {
            sb.append(LEVELSUFFIX[5]);
            sb.append(lev - 4);
        }
        sb.append("]");
        return new String(sb);
    }

    private void appendIntPadded(StringBuffer sb, Integer in, int width) {
        String s = in.toString();
        int pads = width - s.length();
        if (pads > 0) {
            while (pads-- > 0) {
                sb.append('0');
            }
        }
        sb.append(s);
    }

    private String getTimestamp(DateFormat df) {
        String ret = null;
        if (df != null) {
            try {
                ret = df.format(new Date(this._time));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = _defaultDf.format(new Date(this._time));
        }
        return ret;
    }
}

