/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log.impl.basic;

import com.wm.app.log.JournalLogConsumer;
import com.wm.app.log.JournalLogEntry;
import com.wm.app.log.JournalLogListener;
import com.wm.app.log.impl.basic.BasicLogManager;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;

public class BasicLogConsumer
implements JournalLogConsumer {
    BasicLogManager _logMan;
    BasicLogConsumer _nextConsumer = null;
    JournalLogListener _listener = null;
    int _filterLevel = Integer.MAX_VALUE;
    Hashtable _filterIds = null;

    public void setListener(JournalLogListener l) {
        this._listener = l;
    }

    public void setFilterLevel(int level) {
        this._filterLevel = level;
    }

    public void addFilterProductId(String prodId) {
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        }
        this._filterIds.put(prodId, new BitSet(0));
    }

    public void addFilterProductId(String prodId, int[] majors) {
        BitSet bs = null;
        if (this._filterIds == null) {
            this._filterIds = new Hashtable();
        } else {
            bs = (BitSet)this._filterIds.get(prodId);
        }
        if (bs == null || bs.length() == 0) {
            bs = new BitSet(64);
        }
        for (int i = 0; i < majors.length; ++i) {
            bs.set(majors[i]);
        }
        this._filterIds.put(prodId, bs);
    }

    public void removeFilterProductId(String prodId) {
        if (this._filterIds != null) {
            this._filterIds.remove(prodId);
            if (this._filterIds.size() == 0) {
                this._filterIds = null;
            }
        }
    }

    public int getFilterLevel() {
        return this._filterLevel;
    }

    public Hashtable getFilterProductIds() {
        Hashtable ht = null;
        if (this._filterIds != null) {
            ht = (Hashtable)this._filterIds.clone();
        }
        if (ht != null) {
            Enumeration en = ht.keys();
            while (en.hasMoreElements()) {
                int i;
                String k = (String)en.nextElement();
                BitSet bs = (BitSet)ht.get(k);
                if (bs.length() == 0) continue;
                int j = 0;
                for (i = 0; i < bs.length(); ++i) {
                    if (!bs.get(i)) continue;
                    ++j;
                }
                int[] ia = new int[j];
                j = 0;
                for (i = 0; i < bs.length(); ++i) {
                    if (!bs.get(i)) continue;
                    ia[j++] = i;
                }
                ht.put(k, ia);
            }
        }
        return ht;
    }

    public void failureNotify(Exception e) {
        this._logMan.notifyFailure(e);
    }

    BasicLogConsumer(BasicLogManager logMan) {
        this._logMan = logMan;
        this._filterLevel = Integer.MAX_VALUE;
    }

    void notifyListener(JournalLogEntry entry) {
        if (this._listener == null) {
            return;
        }
        if (this.passesFilter(entry.getProductId(), entry.getMajor(), entry.getLevel())) {
            this._listener.processEntry(entry);
        }
    }

    boolean passesFilter(String prodId, int major, int level) {
        boolean ret = false;
        if (level <= this._filterLevel) {
            BitSet majors;
            if (this._filterIds == null) {
                ret = true;
            } else if (this._filterIds.containsKey(prodId) && ((majors = (BitSet)this._filterIds.get(prodId)).length() == 0 || majors.get(major))) {
                ret = true;
            }
        }
        return ret;
    }
}

