/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.log;

import com.wm.app.log.JournalLogException;
import com.wm.app.log.JournalLogHandler;
import com.wm.app.log.JournalLogManager;
import com.wm.app.log.impl.basic.BasicLogManager;
import com.wm.app.log.impl.sc.SCLogManager;
import com.wm.app.log.util.DailyFileMsgHandler;
import com.wm.app.log.util.FileEntryHandler;
import com.wm.app.log.util.FileJavaSerHandler;
import com.wm.app.log.util.FileMsgHandler;
import java.io.IOException;
import java.util.Properties;

public class JournalLogFactory {
    public static String MGR_TYPE = "log.managerType";
    public static String MGR_ID = "log.managerId";
    public static String HNDLR_TYPE = "log.handlerType";
    public static String HNDLR_FILENAME = "log.handlerFilename";
    public static String MGR_TYPE_BASIC = "Basic";
    public static String MGR_TYPE_COMMON = "Commons";
    public static String HNDLR_TYPE_FILEMSG = "FileMsg";
    public static String HNDLR_TYPE_FILEENTRY = "FileEntry";
    public static String HNDLR_TYPE_FILEJSER = "FileJavaSer";
    public static String HNDLR_TYPE_DAILYFILEMSG = "DailyFileMsg";
    private static String EXCP001 = "BAL.0001.0001";

    public static JournalLogManager createManager(Properties prop) throws JournalLogException {
        JournalLogManager logMan = null;
        if (prop == null) {
            prop = new Properties();
        }
        String mgrType = prop.getProperty(MGR_TYPE, "Basic");
        String mgrId = prop.getProperty(MGR_ID);
        if (mgrType.equalsIgnoreCase(MGR_TYPE_BASIC)) {
            logMan = new BasicLogManager(mgrId);
        } else if (mgrType.equalsIgnoreCase(MGR_TYPE_COMMON)) {
            logMan = new SCLogManager(mgrId);
        } else {
            throw new JournalLogException(EXCP001, new String[]{MGR_TYPE, mgrType});
        }
        return logMan;
    }

    public static JournalLogHandler createHandler(JournalLogManager logMan, Properties prop) throws JournalLogException {
        JournalLogHandler logHandler = null;
        String type = prop.getProperty(HNDLR_TYPE, "not specified");
        String filename = prop.getProperty(HNDLR_FILENAME, "");
        if (type.equalsIgnoreCase(HNDLR_TYPE_FILEMSG)) {
            try {
                if (!filename.equals("")) {
                    logHandler = new FileMsgHandler(logMan, filename);
                }
                logHandler = new FileMsgHandler(logMan, System.out);
            }
            catch (IOException e) {
                throw new JournalLogException(e);
            }
        } else if (type.equalsIgnoreCase(HNDLR_TYPE_FILEENTRY)) {
            try {
                logHandler = new FileEntryHandler(logMan, filename);
            }
            catch (IOException e) {
                throw new JournalLogException(e);
            }
        } else if (type.equalsIgnoreCase(HNDLR_TYPE_FILEJSER)) {
            try {
                logHandler = new FileJavaSerHandler(logMan, filename);
            }
            catch (IOException e) {
                throw new JournalLogException(e);
            }
        } else if (type.equalsIgnoreCase(HNDLR_TYPE_DAILYFILEMSG)) {
            try {
                logHandler = new DailyFileMsgHandler(logMan, filename, true);
            }
            catch (IOException e) {
                throw new JournalLogException(e);
            }
        } else {
            throw new JournalLogException(EXCP001, new String[]{HNDLR_TYPE, type});
        }
        return logHandler;
    }
}

