/*
 * Decompiled with CFR 0.152.
 */
package com.wm.app.b2b.util.tx;

import com.wm.app.b2b.client.ServiceException;
import com.wm.app.b2b.client.TContext;
import com.wm.app.b2b.util.tx.JobMgrThread;
import com.wm.app.b2b.util.tx.TXJobIllegalArgumentException;
import com.wm.app.b2b.util.tx.TXJobLog;
import com.wm.app.b2b.util.tx.TXRepoJobStore;
import com.wm.app.b2b.util.tx.TXRmtJob;
import com.wm.app.b2b.util.tx.TxJobMgrTrustDeciderManager;
import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.security.Config;
import com.wm.security.TrustDeciderManager;
import com.wm.security.TrustManager;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import com.wm.util.pool.ObjectPool;
import com.wm.util.pool.PooledObject;
import com.wm.util.pool.PooledThread;
import com.wm.util.pool.ThreadPool;
import com.wm.util.resources.TXJobExceptionBundle;
import com.wm.util.sync.CountingSemaphore;
import com.wm.util.tx.TXJobException;
import com.wm.util.tx.TXJobId;
import com.wm.util.tx.TXJobStore;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;

public class TXRmtJobMgr
implements Runnable {
    public static final int TRXJOB0039 = 39;
    public static final int TRXJOB0040 = 40;
    public static final int TRXJOB0041 = 41;
    public static final int TRXJOB0042 = 42;
    public static final int TRXJOB0043 = 43;
    public static final int TRXJOB0044 = 44;
    public static final int TRXJOB0045 = 45;
    public static final int TRXJOB0046 = 46;
    public static final int TRXJOB0047 = 47;
    public static final int TRXJOB0048 = 48;
    public static final int TRXJOB0049 = 49;
    public static final int TRXJOB0050 = 50;
    public static final int TRXJOB0051 = 51;
    public static final int TRXJOB0052 = 52;
    public static final int TRXJOB0053 = 53;
    public static final int TRXJOB0054 = 54;
    public static final int TRXJOB0055 = 55;
    public static final int TRXJOB0056 = 56;
    public static final int TRXJOB0057 = 57;
    public static final int TRXJOB0058 = 58;
    public static final int TRXJOB0059 = 59;
    public static final int TRXJOB0060 = 60;
    public static final int TRXJOB0061 = 61;
    public static final int TRXJOB0062 = 62;
    public static final int TRXJOB0063 = 63;
    public static final int TRXJOB0064 = 64;
    public static final int TRXJOB0065 = 65;
    public static final int TRXJOB0066 = 66;
    public static final int TRXJOB0067 = 67;
    public static final int TRXJOB0068 = 68;
    public static final int TRXJOB0074 = 74;
    public static final int TRXJOB0104 = 104;
    public static final Integer TXSTATUS_START = new Integer(1);
    public static final Integer TXSTATUS_STOP = new Integer(2);
    public static final Integer TXSTATUS_DISABLE = new Integer(3);
    public static final Integer TXSTATUS_CREATE = new Integer(4);
    public static final Integer TXSTATUS_END = new Integer(5);
    public static final Integer TXSTATUS_EXPIRE = new Integer(6);
    public static final Integer TXSTATUS_RESET_LOG = new Integer(7);
    public static final Integer TXSTATUS_RESET_LOGSTREAM = new Integer(8);
    public static final Integer TXSTATUS_RESET_LOGWRITER = new Integer(9);
    public static final Integer TXSTATUS_JOB_STARTED = new Integer(10);
    public static final Integer TXSTATUS_JOB_RESTARTED = new Integer(11);
    public static final Integer TXSTATUS_RETRY_LIMIT = new Integer(12);
    public static final Integer TXSTATUS_INVOKE = new Integer(13);
    public static final Integer TXSTATUS_RETRIEVE_COMPLETED_JOB = new Integer(14);
    public static final Integer TXSTATUS_RETRIEVE_ERROR = new Integer(15);
    public static final Integer TXSTATUS_EXECUTE = new Integer(16);
    public static final Integer TXSTATUS_JOB_ERROR = new Integer(17);
    public static final Integer TXSTATUS_JOB_SUCCESS = new Integer(18);
    public static final Integer TXSTATUS_RESTART = new Integer(19);
    public static final Integer TXSTATUS_EXPIRE_HEURISTIC = new Integer(20);
    public static final Integer TXSTATUS_HEURISTIC_RETRY = new Integer(21);
    public static final Integer TXSTATUS_HEURISTIC_FAIL = new Integer(22);
    public static final Integer TXSTATUS_JOB_DATA_RETRIEVED = new Integer(23);
    public static final Integer TXSTATUS_JOB_DATA_RETRIEVAL_ERROR = new Integer(24);
    public static final Integer TXSTATUS_MAPPED_TID = new Integer(25);
    public static final Integer TXSTATUS_END_ONEWAY = new Integer(26);
    private static String self = "TXRmtJobMgr";
    private static final String TXJOBMGR_TRUSTDECIDER_MGR = "com.wm.app.b2b.util.tx.TxJobMgrTrustDeciderManager";
    private Thread runner;
    private int timeout;
    private long backoffTime;
    private ThreadPool tPool;
    private Hashtable jobs;
    private TXJobStore jobStore;
    private boolean auditLog;
    private Method txOutLog;
    private Method getClusterHostnames;
    private TXJobLog jobLog;
    private long defaultTTL;
    private int mgrRefs;
    private boolean newJobs;
    private CountingSemaphore jobsObj = new CountingSemaphore(0);
    private static String TX_IFC = "wm.server.tx";
    private static String TX_SVC_START = "start";
    private static String TX_SVC_RESTART = "restart";
    private static String TX_SVC_EXECUTE = "execute";
    private static String TX_SVC_END = "end";
    private static TXRmtJobMgr jobMgr;
    private static boolean enabled;
    private static int debugLevel;

    private TXRmtJobMgr(OutputStream logstream, Writer logwriter, boolean audit) throws TXJobException {
        this.auditLog = audit;
        if (this.auditLog) {
            try {
                Class<?> alm = Class.forName("com.wm.app.b2b.server.AuditLogManager");
                this.txOutLog = alm.getMethod("txOutLog", Integer.TYPE, String.class, String.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new TXJobException(ex);
            }
        } else {
            this.jobLog = logstream != null ? new TXJobLog(logstream) : (logwriter != null ? new TXJobLog(logwriter) : new TXJobLog(com.wm.util.Config.getProperty("tx.log", "watt.tx.logfile")));
        }
        if (Boolean.getBoolean("watt.server")) {
            try {
                Class<?> dbjs = Class.forName("com.wm.app.b2b.server.tx.TXDBJobStore");
                this.jobStore = (TXJobStore)dbjs.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (Exception e) {
                throw new TXJobException(e);
            }
        }
        if (this.jobStore == null) {
            this.jobStore = new TXRepoJobStore();
        }
        try {
            Class<?> clMgr = Class.forName("com.wm.app.b2b.server.cluster.ClusterManager");
            this.getClusterHostnames = clMgr.getMethod("getClusterHostNames", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        debugLevel = 0;
        try {
            String level = System.getProperty("watt.tx.debug", "0");
            debugLevel = Integer.parseInt(level);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.jobs = this.jobStore.loadJobs();
        }
        catch (Exception e) {
            return;
        }
        this.timeout = 60;
        String sweepTime = com.wm.util.Config.getProperty("watt.tx.sweepTime");
        try {
            this.timeout = Integer.parseInt(sweepTime);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.timeout *= 1000;
        this.defaultTTL = 30L;
        String timeToLive = com.wm.util.Config.getProperty("watt.tx.defaultTTLMins");
        try {
            this.defaultTTL = Long.parseLong(timeToLive);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.backoffTime = 60L;
        String backoffProp = com.wm.util.Config.getProperty("watt.tx.retryBackoffTime");
        try {
            this.backoffTime = Long.parseLong(backoffProp);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.backoffTime *= 1000L;
        int threadCount = 5;
        String jobsProp = com.wm.util.Config.getProperty("watt.tx.jobThreads");
        try {
            threadCount = Integer.parseInt(jobsProp);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.tPool = new JobMgrThreadPool(threadCount);
        JournalLogger.logDebugPlus(3, 39, 63, this.tPool.toString());
    }

    public static TXRmtJobMgr init(OutputStream logstream) throws TXJobException {
        if (enabled) {
            JournalLogger.logError(40, 63);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_ALREADY_INITED, "");
        }
        if (Config.isSSLPresent()) {
            try {
                Class<?> mgr = Class.forName(TXJOBMGR_TRUSTDECIDER_MGR);
                TrustDeciderManager tdm = (TrustDeciderManager)mgr.newInstance();
                TrustManager.setManager(tdm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        jobMgr = new TXRmtJobMgr(logstream, null, false);
        enabled = true;
        return TXRmtJobMgr.init();
    }

    public static TXRmtJobMgr init(Writer logwriter) throws TXJobException {
        if (enabled) {
            JournalLogger.logError(40, 63);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_ALREADY_INITED, "");
        }
        TxJobMgrTrustDeciderManager.init();
        jobMgr = new TXRmtJobMgr(null, logwriter, false);
        enabled = true;
        return TXRmtJobMgr.init();
    }

    public static TXRmtJobMgr init(boolean audit) throws TXJobException {
        if (enabled) {
            JournalLogger.logError(40, 63);
            throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_ALREADY_INITED, "");
        }
        TxJobMgrTrustDeciderManager.init();
        jobMgr = new TXRmtJobMgr(null, null, true);
        enabled = true;
        return TXRmtJobMgr.init();
    }

    private static TXRmtJobMgr init() throws TXJobException {
        TXRmtJobMgr.jobMgr.runner = new Thread((Runnable)jobMgr, "webM Client TX Remote Job Manager");
        TXRmtJobMgr.jobMgr.runner.setDaemon(true);
        TXRmtJobMgr.jobMgr.runner.start();
        while (!TXRmtJobMgr.jobMgr.runner.isAlive()) {
            Thread.yield();
        }
        JournalLogger.logDebugPlus(3, 41, 63);
        jobMgr.log(TXSTATUS_START, "TXRmtJobManager", null);
        return jobMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TXRmtJobMgr get() throws TXJobException {
        if (!enabled) {
            JournalLogger.logDebugPlus(3, 42, 63);
            return null;
        }
        TXRmtJobMgr tXRmtJobMgr = jobMgr;
        synchronized (tXRmtJobMgr) {
            JournalLogger.logDebugPlus(3, 43, 63);
            return jobMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        TXRmtJobMgr tXRmtJobMgr = this;
        synchronized (tXRmtJobMgr) {
            ++this.mgrRefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        TXRmtJobMgr tXRmtJobMgr = this;
        synchronized (tXRmtJobMgr) {
            if (this.mgrRefs > 0) {
                --this.mgrRefs;
                JournalLogger.logDebugPlus(3, 44, 63);
            } else {
                JournalLogger.logDebugPlus(3, 45, 63);
            }
        }
    }

    public boolean enabled() {
        return enabled;
    }

    public static void shutdown(boolean force) throws TXJobException {
        if (jobMgr == null) {
            return;
        }
        if (TXRmtJobMgr.jobMgr.mgrRefs > 0) {
            JournalLogger.logDebugPlus(3, 46, 63);
            if (!force) {
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TXMGR_JOBS_SHUTDOWN, "");
            }
        }
        jobMgr.terminate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(boolean logError) {
        JournalLogger.logDebugPlus(3, 47, 63);
        enabled = false;
        if (logError) {
            jobMgr.log(TXSTATUS_STOP, "TXRmtJobManager", null);
        }
        TXRmtJobMgr tXRmtJobMgr = this;
        synchronized (tXRmtJobMgr) {
            this.mgrRefs = 0;
            jobMgr = null;
        }
        if (this.jobStore != null) {
            this.jobStore.shutdown();
        }
        if (this.runner != null && this.runner.isAlive() && this.runner != Thread.currentThread()) {
            this.runner.interrupt();
        }
        if (!this.auditLog) {
            this.jobLog.close();
        }
        if (this.tPool != null) {
            this.tPool.releaseAll();
        }
    }

    private void disable(Throwable e) {
        this.disable(e, false);
    }

    private void disable(Throwable e, boolean logError) {
        JournalLogger.logError(48, 63);
        if (!this.enabled()) {
            return;
        }
        if (!logError) {
            this.log(TXSTATUS_DISABLE, "TXRmtJobManager", e.toString());
        }
        TXRmtJobMgr.debugLog("disabling JobMgr", null, 7);
        enabled = false;
    }

    public void resetLogFile(String logfile) throws TXJobException {
        if (!this.auditLog) {
            this.log(TXSTATUS_RESET_LOG, logfile, null);
            this.jobLog.resetFile(logfile);
            this.log(TXSTATUS_RESET_LOG, null, null);
        }
    }

    public void resetLogStream(OutputStream logstream) throws TXJobException {
        if (!this.auditLog) {
            this.log(TXSTATUS_RESET_LOGSTREAM, null, null);
            this.jobLog.setCustomStream(logstream);
            this.log(TXSTATUS_RESET_LOGSTREAM, null, null);
        }
    }

    public void resetLogWriter(Writer logwriter) throws TXJobException {
        if (!this.auditLog) {
            this.log(TXSTATUS_RESET_LOGWRITER, null, null);
            this.jobLog.setCustomWriter(logwriter);
            this.log(TXSTATUS_RESET_LOGWRITER, null, null);
        }
    }

    public String startJob(TContext context, long ttl) throws TXJobException {
        return this.startJob(context, null, ttl, 0);
    }

    public String startJob(TContext context, long ttl, int retries) throws TXJobException {
        return this.startJob(context, null, ttl, retries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startJob(TContext context, String followTid, long ttl, int retries) throws TXJobException {
        if (ttl == 0L) {
            ttl = this.defaultTTL;
        }
        String tid = TXJobId.get();
        TXRmtJob job = new TXRmtJob(tid, context, ttl * 60L * 1000L);
        if (retries > 0) {
            job.setRetryLimit(retries);
        }
        if (followTid != null) {
            job.setFollowTid(followTid);
        }
        Hashtable hashtable = this.jobs;
        synchronized (hashtable) {
            TXRmtJobMgr.debugLog("creating job", tid, 6);
            this.jobStore.addJob(tid, job);
            this.newJobs = true;
        }
        this.wakeRunner();
        this.log(TXSTATUS_CREATE, job.getStatusMsg(), null);
        return tid;
    }

    public void sendJob(String tid, String ifc, String svc, IData data) throws TXJobException {
        this.doSend(tid, ifc, svc, data, true);
    }

    public void executeJob(String tid, String ifc, String svc, IData data) throws TXJobException {
        this.doSend(tid, ifc, svc, data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(String tid, String ifc, String svc, IData data, boolean fireAndForget) throws TXJobException {
        TXJobStore tXJobStore = this.jobStore;
        synchronized (tXJobStore) {
            TXRmtJob job = null;
            if (tid != null) {
                TXRmtJobMgr.debugLog("doSend getting job", tid, 6);
                job = (TXRmtJob)this.jobStore.getJob(tid);
            }
            if (job == null) {
                JournalLogger.logDebugPlus(3, 49, 63, tid);
                throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_UNKNOWN_TRANSACTION, "");
            }
            job.setOneWay(fireAndForget);
            if (data == null) {
                data = IDataFactory.create();
            }
            TXRmtJobMgr.debugLog("doSend entering sync block", tid, 0);
            TXRmtJob tXRmtJob = job;
            synchronized (tXRmtJob) {
                TXRmtJobMgr.debugLog("doSend entered sync block", tid, 0);
                if (this.jobStore.jobGone(tid) || job.isExpired()) {
                    JournalLogger.logDebugPlus(3, 50, 63, tid);
                    throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_EXPIRED_TRANSACTION, "");
                }
                if (!job.isNew()) {
                    this.jobStore.releaseJob(tid);
                    JournalLogger.logDebugPlus(3, 51, 63, tid);
                    throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_DUPLICATE_TRANSACTION, "");
                }
                TXRmtJobMgr.debugLog("starting job", tid, 0);
                job.start(ifc, svc, data);
                this.jobStore.updateJob(job);
                this.newJobs = true;
                this.wakeRunner();
                this.log(TXSTATUS_JOB_STARTED, job.getStatusMsg(), null);
            }
        }
    }

    public IData retrieveJob(String tid) throws TXJobException {
        return this.retrieveJob(tid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IData retrieveJob(String tid, boolean block) throws TXJobException {
        TXRmtJob job = null;
        if (tid != null) {
            TXRmtJobMgr.debugLog("retrieveJob getting job", tid, 6);
            job = (TXRmtJob)this.jobStore.getJob(tid);
        }
        if (job == null) {
            JournalLogger.logDebugPlus(3, 51, 63, tid);
            throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_UNKNOWN_TRANSACTION, "");
        }
        Object object = job.getObjectToSync();
        synchronized (object) {
            StringBuffer stacktrace = new StringBuffer("");
            StackTraceElement[] st = new Exception("").getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                stacktrace.append(st[i].toString() + "----");
            }
            if (!block && job.isInvoked()) {
                return null;
            }
        }
        TXRmtJobMgr.debugLog("retrieveJob entering sync block", tid, 0);
        object = job;
        synchronized (object) {
            TXRmtJobMgr.debugLog("retrieveJob entered sync block", tid, 0);
            if (this.jobStore.jobGone(tid)) {
                JournalLogger.logDebugPlus(3, 52, 63, tid);
                throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_ENDED_TRANSACTION, "");
            }
            if (job.isNew()) {
                this.jobStore.releaseJob(tid);
                JournalLogger.logDebugPlus(3, 53, 63);
                throw new TXJobIllegalArgumentException("[Tx] New transaction " + job.getTid(), false);
            }
            while (job.isPending()) {
                if (!block) {
                    this.jobStore.releaseJob(tid);
                    return null;
                }
                this.newJobs = true;
                this.wakeRunner();
                this.jobStore.doWait(job);
                if (!enabled) {
                    throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_OUT_MGR_DISABLE, "");
                }
                job = (TXRmtJob)this.jobStore.getJob(tid);
                if (job == null) {
                    JournalLogger.logDebugPlus(3, 52, 63, tid);
                    throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_ENDED_TRANSACTION, "");
                }
                if (!job.isPending()) continue;
                this.jobStore.releaseJob(tid);
            }
            System.out.println("The job with tid " + tid + " just came out of while pending block in retrieve job method");
            if (job.isFailed()) {
                TXJobException je;
                if (job.isHeuristicFailure()) {
                    this.jobStore.releaseJob(tid);
                    JournalLogger.logDebugPlus(3, 54, 63);
                    je = new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_FAILED_TRANS, "");
                    je.setHeuristic();
                    throw je;
                }
                this.jobStore.releaseJob(tid);
                JournalLogger.logDebugPlus(3, 55, 63);
                je = new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_EXPIRED_TRANS, "");
                if (!job.exceedsRetries()) throw je;
                je.setExceedsRetries();
                throw je;
            }
            if (!job.isDone() && !(job = (TXRmtJob)this.jobStore.getJob(tid)).isDone()) {
                this.jobStore.releaseJob(tid);
                JournalLogger.logDebugPlus(3, 56, 63);
                throw new TXJobException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_EXPIRED_RETR, "");
            }
            try {
                IData data = this.jobStore.getJobData(job);
                this.log(TXSTATUS_JOB_DATA_RETRIEVED, job.getStatusMsg(), null);
                IData iData = data;
                return iData;
            }
            catch (TXJobException e) {
                this.log(TXSTATUS_JOB_DATA_RETRIEVAL_ERROR, null, job.getStatusMsg());
                throw e;
            }
            finally {
                this.jobStore.releaseJob(tid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endJob(String tid) throws TXJobException {
        if (tid == null) {
            return;
        }
        TXRmtJob job = (TXRmtJob)this.jobStore.getJob(tid);
        if (job == null) {
            return;
        }
        TXRmtJobMgr.debugLog("endJob entering sync block", tid, 0);
        TXRmtJob tXRmtJob = job;
        synchronized (tXRmtJob) {
            TXRmtJobMgr.debugLog("endJob entered sync block", tid, 0);
            if (this.jobStore.jobGone(tid)) {
                JournalLogger.logDebugPlus(3, 74, 63, tid);
                throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_ENDED_TRANSACTION, "");
            }
            this.doEnd(job);
        }
        this.log(TXSTATUS_END, job.getStatusMsg(), null);
    }

    private void doEnd(TXRmtJob job) throws TXJobException {
        if (!job.needsRmtTid()) {
            try {
                Values in = new Values();
                in.put("tid", job.getRmtTid());
                TContext tc = (TContext)job.getContext();
                Values out = tc.clusterInvokeJob(TX_IFC, TX_SVC_END, in);
            }
            catch (Exception e) {
                JournalLogger.logDebugPlus(3, 57, 63, job.getTid());
            }
        }
        this.jobStore.removeJob(job.getTid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartJob(String tid) throws TXJobException {
        if (tid == null) {
            return;
        }
        TXRmtJob job = (TXRmtJob)this.jobStore.getJob(tid);
        if (job == null) {
            JournalLogger.logDebugPlus(3, 58, 63, tid);
            throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_UNKNOWN_TRANSACTION, "");
        }
        TXRmtJobMgr.debugLog("restartJob entering sync block", tid, 0);
        TXRmtJob tXRmtJob = job;
        synchronized (tXRmtJob) {
            TXRmtJobMgr.debugLog("restartJob entered sync block", tid, 0);
            if (this.jobStore.jobGone(tid)) {
                JournalLogger.logDebugPlus(3, 59, 63, tid);
                throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_ENDED_TRANSACTION, "");
            }
            if (!job.isFailed()) {
                this.jobStore.releaseJob(tid);
                JournalLogger.logDebugPlus(3, 60, 63, tid);
                throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_ACTIVE_TRANSACTION, "");
            }
            if (!this.jobStore.jobHasData(job)) {
                this.jobStore.releaseJob(tid);
                JournalLogger.logDebugPlus(3, 61, 63, tid);
                throw new TXJobIllegalArgumentException(TXJobExceptionBundle.class, TXJobExceptionBundle.TXJOB_TX_NON_PENDING_TRANSACTION, "");
            }
            job.restart();
            Hashtable hashtable = this.jobs;
            synchronized (hashtable) {
                this.jobStore.addJob(tid, job);
                this.newJobs = true;
            }
            this.wakeRunner();
            this.log(TXSTATUS_JOB_RESTARTED, job.getStatusMsg(), null);
        }
    }

    public Enumeration getJobIds() {
        return this.jobStore.jobKeys();
    }

    public String getJobStatus(String tid) {
        if (tid == null) {
            return "UNKNOWN";
        }
        TXRmtJob job = (TXRmtJob)this.jobStore.viewJob(tid);
        if (job == null) {
            JournalLogger.logDebugPlus(3, 62, 63, tid);
            return "UNKNOWN";
        }
        return job.getStatus();
    }

    public int getJobStatusVal(String tid) {
        if (tid == null) {
            return -1;
        }
        TXRmtJob job = (TXRmtJob)this.jobStore.viewJob(tid);
        if (job == null) {
            JournalLogger.logDebugPlus(3, 62, 63, tid);
            return -1;
        }
        return job.getStatusVal();
    }

    public IData getJobData(String tid) {
        if (tid == null) {
            return null;
        }
        try {
            TXRmtJob job = (TXRmtJob)this.jobStore.getJob(tid);
            if (job == null) {
                JournalLogger.logDebugPlus(3, 63, 63, tid);
                return null;
            }
            IData data = this.jobStore.getJobData(job);
            this.jobStore.releaseJob(tid);
            return data;
        }
        catch (TXJobException e) {
            JournalLogger.log(9998, 63, e);
            return null;
        }
    }

    public String getChainedWait(String tid) {
        if (tid == null) {
            return null;
        }
        TXRmtJob job = (TXRmtJob)this.jobStore.viewJob(tid);
        if (job == null) {
            JournalLogger.logDebugPlus(3, 63, 63, tid);
            return null;
        }
        return this.chainedWait(job);
    }

    public String getRmtTid(String tid) {
        if (tid == null) {
            return null;
        }
        TXRmtJob job = (TXRmtJob)this.jobStore.viewJob(tid);
        if (job == null) {
            JournalLogger.logDebugPlus(3, 64, 63, tid);
            return null;
        }
        return job.getRmtTid();
    }

    private void log(Integer status, String msg, String emsg) {
        try {
            if (!this.auditLog) {
                String logmsg = this.getTxStatusAsString(status);
                if (msg != null) {
                    logmsg = logmsg + " " + msg;
                }
                if (emsg != null) {
                    logmsg = logmsg + " " + emsg;
                }
                this.jobLog.write(logmsg);
            } else {
                Object[] parms = new Object[]{status, msg, emsg};
                this.txOutLog.invoke(null, parms);
            }
        }
        catch (Exception e) {
            this.disable(e, true);
        }
    }

    private String getTxStatusAsString(Integer status) {
        String s = null;
        switch (status) {
            case 1: {
                s = "Start";
                break;
            }
            case 2: {
                s = "Stop";
                break;
            }
            case 3: {
                s = "Disable";
                break;
            }
            case 4: {
                s = "Create";
                break;
            }
            case 5: {
                s = "End";
                break;
            }
            case 6: {
                s = "Expire";
                break;
            }
            case 7: {
                s = "Reset Log";
                break;
            }
            case 8: {
                s = "Reset Log Stream";
                break;
            }
            case 9: {
                s = "Reset Log Writer";
                break;
            }
            case 10: {
                s = "Job Started";
                break;
            }
            case 11: {
                s = "Job Restarted";
                break;
            }
            case 12: {
                s = "Retry Limit";
                break;
            }
            case 13: {
                s = "Invoke";
                break;
            }
            case 14: {
                s = "Retrieve Completed Job";
                break;
            }
            case 15: {
                s = "Retrieve Error";
                break;
            }
            case 16: {
                s = "Execute";
                break;
            }
            case 17: {
                s = "Job Error";
                break;
            }
            case 18: {
                s = "Job Success";
                break;
            }
            case 19: {
                s = "Restart";
                break;
            }
            case 20: {
                s = "Expire(HeuristicFailure)";
                break;
            }
            case 21: {
                s = "Heuristic Error Retry";
                break;
            }
            case 22: {
                s = "Heuristic Error Fail";
                break;
            }
            case 23: {
                s = "Job Data Retrieved";
                break;
            }
            case 24: {
                s = "Job Data Retrieval Error";
                break;
            }
            case 25: {
                s = "Mapped Tid";
                break;
            }
            case 26: {
                s = "End (Oneway)";
                break;
            }
            default: {
                s = "NoValue";
            }
        }
        return s;
    }

    private void wakeRunner() {
        this.jobsObj.semPost();
    }

    public void run() {
        do {
            try {
                this.purgeStaleLocks();
                this.processJobs();
                if (this.newJobs) continue;
                this.jobsObj.semWait(this.timeout);
            }
            catch (InterruptedException e) {
            }
            catch (Throwable e) {
                this.disable(e);
            }
        } while (this.enabled());
        JournalLogger.logDebugPlus(3, 65, 63);
    }

    private void purgeStaleLocks() {
        try {
            Values hostnames = null;
            if (this.getClusterHostnames != null) {
                String[] h = (String[])this.getClusterHostnames.invoke(null, (Object[])null);
                Object[][] h2 = new String[][]{h, h};
                hostnames = new Values(h2);
            }
            this.jobStore.purgeStaleLocks(hostnames);
        }
        catch (Exception e) {
            JournalLogger.log(9998, 63, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJobs() {
        Enumeration e = null;
        Hashtable hashtable = this.jobs;
        synchronized (hashtable) {
            e = this.jobStore.jobKeys();
            this.newJobs = false;
        }
        while (e.hasMoreElements()) {
            try {
                String tid = (String)e.nextElement();
                TXRmtJob job = (TXRmtJob)this.jobStore.getJobNoWait(tid);
                if (job == null) continue;
                TXRmtJobMgr.debugLog("processJobs got job-" + job.getStatus(), tid, 0);
                TXRmtJob tXRmtJob = job;
                synchronized (tXRmtJob) {
                    if (job.isActive()) {
                        continue;
                    }
                    if (job.isComplete()) {
                        this.jobStore.releaseJob(tid);
                        continue;
                    }
                    TXRmtJobMgr.debugLog("processJobs entering sync block", tid, 0);
                    TXRmtJobMgr.debugLog("processJobs entered sync block", tid, 0);
                    if (job.exceedsRetries()) {
                        this.log(TXSTATUS_RETRY_LIMIT, job.getStatusMsg(), null);
                        job.fail();
                        this.jobStore.updateJob(job, true);
                        this.jobStore.doNotify(job);
                        continue;
                    }
                    if (job.isExpired()) {
                        this.log(TXSTATUS_EXPIRE, job.getStatusMsg(), null);
                        if (job.isNew()) {
                            this.jobStore.removeJob(tid);
                        } else {
                            job.fail();
                            this.jobStore.updateJob(job, true);
                            this.jobStore.doNotify(job);
                        }
                        continue;
                    }
                    if (job.isPending()) {
                        long lastUpdate = System.currentTimeMillis() - job.getTimeUpdated();
                        if (job.isRetry() && lastUpdate < this.backoffTime) {
                            this.jobStore.releaseJob(tid);
                            JournalLogger.logDebugPlus(3, 66, 63);
                            continue;
                        }
                        if (this.chainedWait(job) != null) {
                            this.jobStore.releaseJob(tid);
                            continue;
                        }
                    }
                    JobExecutor je = new JobExecutor(job);
                    PooledThread tp = (PooledThread)this.tPool.allocate();
                    job.setActive(true);
                    tp.runTarget(je);
                }
            }
            catch (TXJobException j) {
                this.disable(j);
                return;
            }
        }
    }

    private String chainedWait(TXRmtJob job) {
        String tid = job.getFollowTid();
        if (tid == null) {
            return null;
        }
        TXRmtJob follow = (TXRmtJob)this.jobStore.viewJob(tid);
        if (follow == null) {
            return null;
        }
        JournalLogger.logDebugPlus(3, 67, 63, tid);
        return follow.isDone() ? null : tid;
    }

    public static void debugLog(String msg, String tid, int stackFrames) {
        if (debugLevel < 1) {
            return;
        }
        StringBuffer sb = new StringBuffer("\n");
        sb.append(Thread.currentThread().hashCode());
        sb.append(": ");
        sb.append(new Timestamp(System.currentTimeMillis()).toString());
        sb.append(' ');
        if (tid != null) {
            sb.append('[').append(tid).append("] ");
        }
        if (msg != null) {
            sb.append(msg);
        }
        if (stackFrames > 0 && debugLevel > 1) {
            Exception ex = new Exception();
            StackTraceElement[] trace = ex.getStackTrace();
            int size = trace.length;
            for (int i = 1; i < size && i < stackFrames + 1; ++i) {
                sb.append("\n  at ");
                sb.append(trace[i].getClassName());
                sb.append('.');
                sb.append(trace[i].getMethodName());
                sb.append('(');
                if (trace[i].isNativeMethod()) {
                    sb.append("native code");
                } else {
                    sb.append(trace[i].getLineNumber());
                }
                sb.append(')');
            }
        }
        System.out.println(sb);
    }

    class JobMgrThreadPool
    extends ThreadPool {
        public JobMgrThreadPool(int threadCount) {
            super(threadCount, threadCount, "webM Client TX Thread Pool");
        }

        public PooledObject createObject() {
            return new JobMgrPooledThread(this, "webM Client TX Thread Pool");
        }
    }

    class JobMgrPooledThread
    extends PooledThread {
        public JobMgrPooledThread(ObjectPool pool, String tname) {
            super(pool, tname);
        }

        public Thread newThread(Runnable target) {
            return new JobMgrThread(target);
        }
    }

    class JobExecutor
    implements Runnable {
        TXRmtJob job;

        public JobExecutor(TXRmtJob job) {
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TXRmtJobMgr.debugLog("JobExecutor started", this.job.getTid(), 0);
            try {
                TContext tc = (TContext)this.job.getContext();
                tc.updateCredentials();
                this.invokeJob();
            }
            catch (TXJobException e) {
                TXRmtJobMgr.this.disable(e);
            }
            catch (Throwable e) {
                TXRmtJobMgr.this.disable(e);
                JournalLogger.logError(68, 63, e);
            }
            finally {
                this.job.setActive(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getRmtJobId() throws Exception {
            TXRmtJob tXRmtJob = this.job;
            synchronized (tXRmtJob) {
                if (this.job.getRmtTid() == null || "".equals(this.job.getRmtTid())) {
                    Values in = new Values();
                    in.put("ttl", this.job.getTtl() / 60L / 1000L);
                    TContext tc = (TContext)this.job.getContext();
                    Values out = tc.clusterInvokeJob(TX_IFC, TX_SVC_START, in);
                    String tid = out.getString("tid");
                    if (tid == null || tid.length() == 0) {
                        JournalLogger.logDebug(104, 63, new Object[]{TX_IFC, TX_SVC_START});
                        return;
                    }
                    this.job.setRmtTid(tid);
                    TXRmtJobMgr.this.jobStore.updateJob(this.job, true);
                    TXRmtJobMgr.this.log(TXSTATUS_MAPPED_TID, "(Local=" + this.job.getTid() + "; Remote=" + tid + ")", null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeJob() throws Exception {
            try {
                TXRmtJobMgr.debugLog("JobExecutor.invokeJob", this.job.getTid(), 0);
                Object object = this.job.getObjectToSync();
                synchronized (object) {
                    StringBuffer stacktrace = new StringBuffer("");
                    StackTraceElement[] st = new Exception("").getStackTrace();
                    for (int i = 0; i < st.length; ++i) {
                        stacktrace.append(st[i].toString() + "----");
                    }
                    this.job.setInvoked(true);
                }
                TXRmtJobMgr.debugLog("invokeJob entering sync block", this.job.getTid(), 0);
                object = this.job;
                synchronized (object) {
                    TXRmtJobMgr.debugLog("invokeJob entered sync block", this.job.getTid(), 0);
                    if (!TXRmtJobMgr.this.jobStore.jobExists(this.job.getTid())) {
                        return;
                    }
                    if (this.job.isNew()) {
                        TXRmtJobMgr.this.jobStore.releaseJob(this.job.getTid());
                        return;
                    }
                    if (this.job.needsRmtTid()) {
                        this.getRmtJobId();
                    }
                    if (this.job.isNew() || this.job.needsRmtTid()) {
                        TXRmtJobMgr.this.jobStore.releaseJob(this.job.getTid());
                        return;
                    }
                    TXRmtJobMgr.this.log(TXSTATUS_INVOKE, this.job.getStatusMsg(), null);
                    Values in = new Values();
                    in.put("tid", this.job.getRmtTid());
                    in.put("ifc", this.job.getIfc());
                    in.put("svc", this.job.getSvc());
                    in.put("data", TXRmtJobMgr.this.jobStore.getJobData(this.job));
                    TContext tc = (TContext)this.job.getContext();
                    Values out = tc.clusterInvokeJob(TX_IFC, TX_SVC_EXECUTE, in);
                    TXRmtJobMgr.debugLog("finished clusterInvokeJob", this.job.getTid(), 0);
                    TXRmtJobMgr.this.newJobs = true;
                    this.job.done(out);
                    System.out.println("THe Job done is called for job " + this.job.getTid());
                    if (!this.job.isOneWay()) {
                        TXRmtJobMgr.this.jobStore.updateJob(this.job, true);
                        TXRmtJobMgr.this.jobStore.doNotify(this.job);
                    } else {
                        TXRmtJobMgr.this.doEnd(this.job);
                        TXRmtJobMgr.this.log(TXSTATUS_END_ONEWAY, this.job.getStatusMsg(), null);
                    }
                    TXRmtJobMgr.this.wakeRunner();
                }
            }
            catch (TXJobException e) {
                TXRmtJobMgr.debugLog("JobExecutor.invokeJob TXJobException", this.job.getTid(), 0);
                if (e.isTransient()) {
                    if (e.isFailedJob()) {
                        TXRmtJobMgr.debugLog("invokeJob-isFailed entering sync block", this.job.getTid(), 0);
                        TXRmtJob in = this.job;
                        synchronized (in) {
                            TXRmtJobMgr.debugLog("invokeJob-isFailed entered sync block", this.job.getTid(), 0);
                            this.job.fail();
                            TXRmtJobMgr.this.jobStore.updateJob(this.job, true);
                            TXRmtJobMgr.this.log(TXSTATUS_HEURISTIC_FAIL, this.job.getStatusMsg(), null);
                            TXRmtJobMgr.this.jobStore.doNotify(this.job);
                        }
                    }
                    TXRmtJobMgr.debugLog("invokeJob-not Failed entering sync block", this.job.getTid(), 0);
                    TXRmtJob in = this.job;
                    synchronized (in) {
                        TXRmtJobMgr.debugLog("invokeJob-not Failed entered sync block", this.job.getTid(), 0);
                        this.job.retryFailed();
                        TXRmtJobMgr.this.jobStore.updateJob(this.job);
                    }
                }
                TXRmtJobMgr.this.disable(e);
            }
            catch (ServiceException e) {
                TXRmtJobMgr.debugLog("JobExecutor.invokeJob ServiceException", this.job.getTid(), 0);
                Values out = new Values();
                out.put("$error", e.getMessage());
                out.put("$errorType", e.getErrorType());
                out.put("$localizedError", e.getLocalizedMessage());
                TXRmtJobMgr.debugLog("invokeJob-SvcEx entering sync block", this.job.getTid(), 0);
                TXRmtJob tXRmtJob = this.job;
                synchronized (tXRmtJob) {
                    TXRmtJobMgr.debugLog("invokeJob-SvcEx entered sync block", this.job.getTid(), 0);
                    this.job.done(out);
                    TXRmtJobMgr.this.jobStore.updateJob(this.job, true);
                    TXRmtJobMgr.this.jobStore.doNotify(this.job);
                }
            }
            catch (Exception e) {
                TXRmtJobMgr.this.jobStore.releaseJob(this.job.getTid());
            }
        }
    }
}

